/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import com.datastax.driver.core.Row;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.hawkular.metrics.core.service.DataAccess;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.core.service.PatternUtil;
import org.hawkular.metrics.core.service.transformers.ItemsToSetTransformer;
import org.hawkular.metrics.core.service.transformers.TagsIndexRowTransformer;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import rx.Observable;
import rx.functions.Func1;

public class TagQueryParser {
    private DataAccess dataAccess;
    private MetricsService metricsService;
    private boolean enableACostQueries;

    public TagQueryParser(DataAccess dataAccess, MetricsService metricsService, boolean disableACostQueries) {
        this.dataAccess = dataAccess;
        this.metricsService = metricsService;
        this.enableACostQueries = !disableACostQueries;
    }

    public Observable<MetricId<?>> findMetricIdentifiersWithFilters(String tenantId, MetricType<?> metricType, Map<String, String> tagsQueries) {
        Observable groupMetrics;
        block13: {
            List<Query> groupCEntries;
            List<Query> groupBEntries;
            block11: {
                block12: {
                    Map<Long, List<Query>> costSortedMap = QueryOptimizer.reOrderTagsQuery(tagsQueries, this.enableACostQueries);
                    List<Query> groupAEntries = costSortedMap.get(10L);
                    List<Query> groupAOREntries = costSortedMap.get(11L);
                    groupBEntries = costSortedMap.get(50L);
                    groupCEntries = costSortedMap.get(99L);
                    groupMetrics = null;
                    if (groupAEntries.isEmpty() && groupAOREntries.isEmpty()) break block11;
                    if (!groupAEntries.isEmpty()) {
                        groupMetrics = Observable.from(groupAEntries).flatMap(e -> this.dataAccess.findMetricsByTagNameValue(tenantId, e.getTagName(), e.getTagValueMatcher()).compose(new TagsIndexRowTransformer(metricType)).compose(new ItemsToSetTransformer())).reduce((s1, s2) -> {
                            s1.retainAll((Collection<?>)s2);
                            return s1;
                        }).flatMap(Observable::from);
                    }
                    if (!groupAOREntries.isEmpty()) {
                        Observable groupAORMetrics = Observable.from(groupAOREntries).flatMap(e -> this.dataAccess.findMetricsByTagNameValue(tenantId, e.getTagName(), e.getTagValues()).compose(new TagsIndexRowTransformer(metricType)).compose(new ItemsToSetTransformer()).reduce((s1, s2) -> {
                            s1.addAll(s2);
                            return s1;
                        })).flatMap(Observable::from);
                        if (groupMetrics == null) {
                            groupMetrics = groupAORMetrics;
                        } else {
                            Observable groupAPart = groupMetrics.toList().map(HashSet::new);
                            Observable groupAORPart = groupAORMetrics.toList().map(HashSet::new);
                            groupMetrics = groupAPart.mergeWith(groupAORPart).reduce((s1, s2) -> {
                                s1.retainAll((Collection<?>)s2);
                                return s1;
                            }).flatMap(Observable::from);
                        }
                    }
                    if (!groupBEntries.isEmpty()) break block12;
                    if (groupCEntries.isEmpty()) break block13;
                }
                Observable<Metric<?>> enrichedMetrics = groupMetrics.flatMap(this.metricsService::findMetric);
                if (!groupBEntries.isEmpty()) {
                    enrichedMetrics = this.applyBFilters(enrichedMetrics, groupBEntries);
                }
                if (!groupCEntries.isEmpty()) {
                    enrichedMetrics = this.applyCFilters(enrichedMetrics, groupCEntries);
                }
                groupMetrics = enrichedMetrics.map(Metric::getMetricId);
                break block13;
            }
            if (!groupBEntries.isEmpty()) {
                groupMetrics = Observable.from(groupBEntries).flatMap(e -> this.dataAccess.findMetricsByTagName(tenantId, e.getTagName()).filter(this.tagValueFilter(e.getTagValueMatcher(), 3)).compose(new TagsIndexRowTransformer(metricType)).compose(new ItemsToSetTransformer()).reduce((s1, s2) -> {
                    s1.addAll(s2);
                    return s1;
                })).reduce((s1, s2) -> {
                    s1.retainAll((Collection<?>)s2);
                    return s1;
                }).flatMap(Observable::from);
                if (!groupCEntries.isEmpty()) {
                    groupMetrics = this.applyCFilters(groupMetrics.flatMap(this.metricsService::findMetric), groupCEntries).map(Metric::getMetricId);
                }
            } else {
                Observable tagsMetrics = this.dataAccess.findAllMetricsFromTagsIndex().compose(new TagsIndexRowTransformer(metricType)).filter(mId -> mId.getTenantId().equals(tenantId));
                Observable dataMetrics = this.metricsService.findAllMetricIdentifiers().filter(m -> m.getTenantId().equals(tenantId)).filter(this.metricTypeFilter(metricType));
                groupMetrics = this.applyCFilters(Observable.concat((Observable)tagsMetrics, (Observable)dataMetrics).distinct().flatMap(this.metricsService::findMetric), groupCEntries).map(Metric::getMetricId);
            }
        }
        return groupMetrics;
    }

    private Observable<Metric<?>> applyBFilters(Observable<Metric<?>> metrics, List<Query> groupBEntries) {
        for (Query groupBQuery : groupBEntries) {
            metrics = metrics.filter(this.tagValueFilter(groupBQuery.getTagValueMatcher(), groupBQuery.getTagName()));
        }
        return metrics;
    }

    private Observable<Metric<?>> applyCFilters(Observable<Metric<?>> metrics, List<Query> groupCEntries) {
        for (Query groupCQuery : groupCEntries) {
            metrics = metrics.filter(this.tagNotExistsFilter(groupCQuery.getTagName().substring(1)));
        }
        return metrics;
    }

    public Observable<Map<String, Set<String>>> getTagValues(String tenantId, MetricType<?> metricType, Map<String, String> tagsQueries) {
        return Observable.from(tagsQueries.entrySet()).flatMap(e -> this.dataAccess.findMetricsByTagName(tenantId, (String)e.getKey()).filter(this.typeFilter(metricType)).filter(this.tagValueFilter((String)e.getValue(), 3)).map(row -> {
            HashMap idMap = new HashMap();
            HashMap valueMap = new HashMap();
            valueMap.put(e.getKey(), row.getString(3));
            idMap.put(row.getString(2), valueMap);
            return idMap;
        }).switchIfEmpty(Observable.just(new HashMap())).reduce((map1, map2) -> {
            map1.putAll(map2);
            return map1;
        })).reduce((m1, m2) -> {
            Iterator iterator = m1.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                if (!m2.containsKey(next.getKey())) {
                    iterator.remove();
                    continue;
                }
                Map map2 = (Map)m2.get(next.getKey());
                map2.forEach((k, v) -> ((Map)next.getValue()).put(k, v));
            }
            return m1;
        }).map(m -> {
            HashMap tagValueMap = new HashMap();
            m.forEach((k, v) -> v.forEach((subKey, subValue) -> {
                if (tagValueMap.containsKey(subKey)) {
                    ((Set)tagValueMap.get(subKey)).add(subValue);
                } else {
                    HashSet<String> values = new HashSet<String>();
                    values.add((String)subValue);
                    tagValueMap.put(subKey, values);
                }
            }));
            return tagValueMap;
        });
    }

    private Func1<Metric<?>, Boolean> tagNotExistsFilter(String unwantedTagName) {
        return tMetric -> !tMetric.getTags().keySet().contains(unwantedTagName);
    }

    private Func1<Row, Boolean> tagValueFilter(String regexp, int index) {
        boolean positive = !regexp.startsWith("!");
        Pattern p = PatternUtil.filterPattern(regexp);
        return r -> positive == p.matcher(r.getString(index)).matches();
    }

    private Func1<Metric<?>, Boolean> tagValueFilter(String regexp, String tagName) {
        return tMetric -> {
            String tagValue = tMetric.getTags().get(tagName);
            if (tagValue != null) {
                boolean positive = !regexp.startsWith("!");
                Pattern p = PatternUtil.filterPattern(regexp);
                return positive == p.matcher(tagValue).matches();
            }
            return false;
        };
    }

    public Func1<Row, Boolean> typeFilter(MetricType<?> type) {
        return row -> {
            MetricType<?> metricType = MetricType.fromCode(row.getByte(1));
            return type == null && metricType.isUserType() || metricType == type;
        };
    }

    public Func1<MetricId<?>, Boolean> metricTypeFilter(MetricType<?> type) {
        return tMetric -> type == null && tMetric.getType().isUserType() || tMetric.getType() == type;
    }

    static class QueryOptimizer {
        public static final long GROUP_A_COST = 10L;
        public static final long GROUP_A_OR_COST = 11L;
        public static final long GROUP_B_COST = 50L;
        public static final long GROUP_C_COST = 99L;
        public static String IS_REGEXP = "^.*[]?+*{}()\\[^$|\\\\]+.*$|^[!].*";
        public static Pattern MATCH_REGEXP = Pattern.compile(IS_REGEXP);

        QueryOptimizer() {
        }

        public static Map<Long, List<Query>> reOrderTagsQuery(Map<String, String> tagsQuery, boolean enableACostQueries) {
            TreeMap<Long, List<Query>> costSortedMap = new TreeMap<Long, List<Query>>();
            costSortedMap.put(10L, new ArrayList());
            costSortedMap.put(11L, new ArrayList());
            costSortedMap.put(50L, new ArrayList());
            costSortedMap.put(99L, new ArrayList());
            block3: for (Map.Entry<String, String> tagQuery : tagsQuery.entrySet()) {
                if (tagQuery.getKey().startsWith("!")) {
                    ((List)costSortedMap.get(99L)).add(new Query(tagQuery.getKey(), tagQuery.getValue(), new String[0]));
                    continue;
                }
                if (enableACostQueries && !QueryOptimizer.isRegExp(tagQuery.getValue())) {
                    ((List)costSortedMap.get(10L)).add(new Query(tagQuery.getKey(), tagQuery.getValue(), new String[0]));
                    continue;
                }
                RegExpOptimizer strategy = QueryOptimizer.optimalStrategy(tagQuery.getValue());
                switch (strategy) {
                    case OR_SINGLE_SEEK: {
                        String[] queries = tagQuery.getValue().split("\\|");
                        ((List)costSortedMap.get(11L)).add(new Query(tagQuery.getKey(), null, queries));
                        continue block3;
                    }
                }
                ((List)costSortedMap.get(50L)).add(new Query(tagQuery.getKey(), tagQuery.getValue(), new String[0]));
            }
            return costSortedMap;
        }

        public static boolean isRegExp(String tagValuesQuery) {
            return MATCH_REGEXP.matcher(tagValuesQuery).matches();
        }

        public static RegExpOptimizer optimalStrategy(String tagValuesQuery) {
            String[] orParts = tagValuesQuery.split("\\|");
            if (orParts.length > 1) {
                for (String orPart : orParts) {
                    if (!QueryOptimizer.isRegExp(orPart)) continue;
                    return RegExpOptimizer.NONE;
                }
                return RegExpOptimizer.OR_SINGLE_SEEK;
            }
            return RegExpOptimizer.NONE;
        }

        static enum RegExpOptimizer {
            OR_SINGLE_SEEK,
            NONE;

        }
    }

    static class Query {
        private String tagName;
        private String tagValueMatcher;
        private String[] tagValues;

        public Query(String tagName, String tagValueMatcher, String ... tagValues) {
            this.tagName = tagName;
            if (tagValues.length > 0) {
                this.tagValues = tagValues;
            } else {
                this.tagValueMatcher = tagValueMatcher;
            }
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getTagValueMatcher() {
            return this.tagValueMatcher;
        }

        public String[] getTagValues() {
            return this.tagValues;
        }
    }
}

