/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.compress;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.metrics.core.service.compress.TagsSerializer;

public class TagsDeserializer {
    private long blockStart;

    public TagsDeserializer(long blockStart) {
        this.blockStart = blockStart;
    }

    public Map<Long, Map<String, String>> deserialize(ByteBuffer bb) {
        HashMap<Long, Map<String, String>> tagsMap = new HashMap<Long, Map<String, String>>();
        if (bb.hasRemaining()) {
            if (TagsSerializer.SIMPLE_SERIALIZER == bb.get()) {
                while (bb.hasRemaining()) {
                    int delta = bb.getInt();
                    long timestamp = this.blockStart + (long)delta;
                    int tagsSize = bb.get() & 0xFF;
                    HashMap<String, String> entryMap = new HashMap<String, String>();
                    for (int i = 0; i < tagsSize; i = (int)((byte)(i + 1))) {
                        int keyLength = bb.get() & 0xFF;
                        int valueLength = bb.get() & 0xFF;
                        byte[] key = new byte[keyLength];
                        byte[] value = new byte[valueLength];
                        bb.get(key);
                        bb.get(value);
                        String mapKey = new String(key, StandardCharsets.UTF_8);
                        String mapValue = new String(value, StandardCharsets.UTF_8);
                        entryMap.put(mapKey, mapValue);
                    }
                    tagsMap.put(timestamp, entryMap);
                }
            } else {
                bb.rewind();
            }
        }
        return tagsMap;
    }
}

