/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.AggregatorUtils;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.runner.options.TimeValue;
import org.openjdk.jmh.util.ListStatistics;
import org.openjdk.jmh.util.Statistics;

public class ThroughputResult
extends Result<ThroughputResult> {
    private static final long serialVersionUID = 7269598073169413322L;

    public ThroughputResult(ResultRole role, String label, long operations, long durationNs, TimeUnit outputTimeUnit) {
        this(role, label, ThroughputResult.of(1.0 * (double)operations * (double)TimeUnit.NANOSECONDS.convert(1L, outputTimeUnit) / (double)durationNs), "ops/" + TimeValue.tuToString(outputTimeUnit), AggregationPolicy.SUM);
    }

    ThroughputResult(ResultRole role, String label, Statistics s, String unit, AggregationPolicy policy) {
        super(role, label, s, unit, policy);
    }

    @Override
    protected Aggregator<ThroughputResult> getThreadAggregator() {
        return new ThroughputAggregator(AggregationPolicy.SUM);
    }

    @Override
    protected Aggregator<ThroughputResult> getIterationAggregator() {
        return new ThroughputAggregator(AggregationPolicy.AVG);
    }

    static class ThroughputAggregator
    implements Aggregator<ThroughputResult> {
        private final AggregationPolicy policy;

        ThroughputAggregator(AggregationPolicy policy) {
            this.policy = policy;
        }

        @Override
        public ThroughputResult aggregate(Collection<ThroughputResult> results) {
            ListStatistics stat = new ListStatistics();
            for (ThroughputResult r : results) {
                stat.addValue(r.getScore());
            }
            return new ThroughputResult(AggregatorUtils.aggregateRoles(results), AggregatorUtils.aggregateLabels(results), stat, AggregatorUtils.aggregateUnits(results), this.policy);
        }
    }
}

