/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.cql3;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.google.common.collect.Sets;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LimitedLocalNodeFirstLocalBalancingPolicy
implements LoadBalancingPolicy {
    private static final Logger logger = LoggerFactory.getLogger(LimitedLocalNodeFirstLocalBalancingPolicy.class);
    private static final Set<InetAddress> localAddresses = Collections.unmodifiableSet(LimitedLocalNodeFirstLocalBalancingPolicy.getLocalInetAddresses());
    private final CopyOnWriteArraySet<Host> liveReplicaHosts = new CopyOnWriteArraySet();
    private final Set<InetAddress> replicaAddresses = new HashSet<InetAddress>();

    public LimitedLocalNodeFirstLocalBalancingPolicy(String[] replicas) {
        for (String replica : replicas) {
            try {
                InetAddress[] addresses = InetAddress.getAllByName(replica);
                Collections.addAll(this.replicaAddresses, addresses);
            }
            catch (UnknownHostException e) {
                logger.warn("Invalid replica host name: {}, skipping it", (Object)replica);
            }
        }
        logger.trace("Created instance with the following replicas: {}", (Object)Arrays.asList(replicas));
    }

    @Override
    public void init(Cluster cluster, Collection<Host> hosts) {
        ArrayList<Host> replicaHosts = new ArrayList<Host>();
        for (Host host : hosts) {
            if (!this.replicaAddresses.contains(host.getAddress())) continue;
            replicaHosts.add(host);
        }
        this.liveReplicaHosts.addAll(replicaHosts);
        logger.trace("Initialized with replica hosts: {}", (Object)replicaHosts);
    }

    @Override
    public void close() {
    }

    @Override
    public HostDistance distance(Host host) {
        if (LimitedLocalNodeFirstLocalBalancingPolicy.isLocalHost(host)) {
            return HostDistance.LOCAL;
        }
        return HostDistance.REMOTE;
    }

    @Override
    public Iterator<Host> newQueryPlan(String keyspace, Statement statement) {
        ArrayList<Host> local = new ArrayList<Host>(1);
        ArrayList<Host> remote = new ArrayList<Host>(this.liveReplicaHosts.size());
        for (Host liveReplicaHost : this.liveReplicaHosts) {
            if (LimitedLocalNodeFirstLocalBalancingPolicy.isLocalHost(liveReplicaHost)) {
                local.add(liveReplicaHost);
                continue;
            }
            remote.add(liveReplicaHost);
        }
        Collections.shuffle(remote);
        logger.trace("Using the following hosts order for the new query plan: {} | {}", (Object)local, (Object)remote);
        return Iterators.concat(local.iterator(), remote.iterator());
    }

    @Override
    public void onAdd(Host host) {
        if (this.replicaAddresses.contains(host.getAddress())) {
            this.liveReplicaHosts.add(host);
            logger.trace("Added a new host {}", (Object)host);
        }
    }

    @Override
    public void onUp(Host host) {
        if (this.replicaAddresses.contains(host.getAddress())) {
            this.liveReplicaHosts.add(host);
            logger.trace("The host {} is now up", (Object)host);
        }
    }

    @Override
    public void onDown(Host host) {
        if (this.liveReplicaHosts.remove(host)) {
            logger.trace("The host {} is now down", (Object)host);
        }
    }

    @Override
    public void onRemove(Host host) {
        if (this.liveReplicaHosts.remove(host)) {
            logger.trace("Removed the host {}", (Object)host);
        }
    }

    public void onSuspected(Host host) {
    }

    private static boolean isLocalHost(Host host) {
        InetAddress hostAddress = host.getAddress();
        return hostAddress.isLoopbackAddress() || localAddresses.contains(hostAddress);
    }

    private static Set<InetAddress> getLocalInetAddresses() {
        try {
            return Sets.newHashSet(Iterators.concat(Iterators.transform(Iterators.forEnumeration(NetworkInterface.getNetworkInterfaces()), new Function<NetworkInterface, Iterator<InetAddress>>(){

                @Override
                public Iterator<InetAddress> apply(NetworkInterface netIface) {
                    return Iterators.forEnumeration(netIface.getInetAddresses());
                }
            })));
        }
        catch (SocketException e) {
            logger.warn("Could not retrieve local network interfaces.", e);
            return Collections.emptySet();
        }
    }
}

