/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.RowIndexEntry;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;

public class SimpleSSTableMultiWriter
implements SSTableMultiWriter {
    private final SSTableWriter writer;
    private final LifecycleTransaction txn;

    protected SimpleSSTableMultiWriter(SSTableWriter writer, LifecycleTransaction txn) {
        this.txn = txn;
        this.writer = writer;
    }

    @Override
    public boolean append(UnfilteredRowIterator partition) {
        RowIndexEntry indexEntry = this.writer.append(partition);
        return indexEntry != null;
    }

    @Override
    public Collection<SSTableReader> finish(long repairedAt, long maxDataAge, boolean openResult) {
        return Collections.singleton(this.writer.finish(repairedAt, maxDataAge, openResult));
    }

    @Override
    public Collection<SSTableReader> finish(boolean openResult) {
        return Collections.singleton(this.writer.finish(openResult));
    }

    @Override
    public Collection<SSTableReader> finished() {
        return Collections.singleton(this.writer.finished());
    }

    @Override
    public SSTableMultiWriter setOpenResult(boolean openResult) {
        this.writer.setOpenResult(openResult);
        return this;
    }

    @Override
    public String getFilename() {
        return this.writer.getFilename();
    }

    @Override
    public long getFilePointer() {
        return this.writer.getFilePointer();
    }

    @Override
    public UUID getCfId() {
        return this.writer.metadata.cfId;
    }

    @Override
    public Throwable commit(Throwable accumulate) {
        return this.writer.commit(accumulate);
    }

    @Override
    public Throwable abort(Throwable accumulate) {
        this.txn.untrackNew(this.writer);
        return this.writer.abort(accumulate);
    }

    @Override
    public void prepareToCommit() {
        this.writer.prepareToCommit();
    }

    @Override
    public void close() {
        this.writer.close();
    }

    public static SSTableMultiWriter create(Descriptor descriptor, long keyCount, long repairedAt, CFMetaData cfm, MetadataCollector metadataCollector, SerializationHeader header, Collection<Index> indexes, LifecycleTransaction txn) {
        SSTableWriter writer = SSTableWriter.create(descriptor, keyCount, (Long)repairedAt, cfm, metadataCollector, header, indexes, txn);
        return new SimpleSSTableMultiWriter(writer, txn);
    }
}

