/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.jobs;

import com.google.common.collect.ImmutableMap;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.core.jobs.CompressData;
import org.hawkular.metrics.core.jobs.DeleteTenant;
import org.hawkular.metrics.core.jobs.JobsService;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.datetime.DateTimeService;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.metrics.scheduler.api.RepeatingTrigger;
import org.hawkular.metrics.scheduler.api.RetryPolicy;
import org.hawkular.metrics.scheduler.api.Scheduler;
import org.hawkular.metrics.scheduler.api.SingleExecutionTrigger;
import org.hawkular.metrics.sysconfig.Configuration;
import org.hawkular.metrics.sysconfig.ConfigurationService;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.jboss.logging.Logger;
import org.joda.time.Minutes;
import rx.Single;
import rx.functions.Func2;

public class JobsServiceImpl
implements JobsService {
    private static Logger logger = Logger.getLogger(JobsServiceImpl.class);
    private Scheduler scheduler;
    private RxSession session;
    private MetricsService metricsService;
    private DeleteTenant deleteTenant;
    private ConfigurationService configurationService;

    public void setMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public void setSession(RxSession session) {
        this.session = session;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public List<JobDetails> start() {
        this.scheduler.start();
        ArrayList<JobDetails> backgroundJobs = new ArrayList<JobDetails>();
        Configuration configuration = (Configuration)this.configurationService.load("org.hawkular.metrics.jobs").toBlocking().lastOrDefault(null);
        this.deleteTenant = new DeleteTenant(this.session, this.metricsService);
        ConcurrentHashMap deleteTenantAttempts = new ConcurrentHashMap();
        Func2 deleteTenantRetryPolicy = (details, throwable) -> () -> {
            logger.warn((Object)("Execution of " + details + " failed"), throwable);
            logger.info((Object)(details + " will be retried in 5 minutes"));
            return Minutes.minutes(5).toStandardDuration().getMillis();
        };
        this.scheduler.register("DELETE_TENANT", this.deleteTenant, (Func2<JobDetails, Throwable, RetryPolicy>)deleteTenantRetryPolicy);
        CompressData compressDataJob = new CompressData(this.metricsService, this.configurationService);
        this.scheduler.register("COMPRESS_DATA", compressDataJob);
        this.maybeScheduleCompressData(backgroundJobs);
        return backgroundJobs;
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdown();
    }

    @Override
    public Single<JobDetails> submitDeleteTenantJob(String tenantId, String jobName) {
        return this.scheduler.scheduleJob("DELETE_TENANT", jobName, ImmutableMap.of("tenantId", tenantId), new SingleExecutionTrigger.Builder().withDelay(1L, TimeUnit.MINUTES).build());
    }

    private void maybeScheduleCompressData(List<JobDetails> backgroundJobs) {
        String configId = "org.hawkular.metrics.jobs.COMPRESS_DATA";
        Configuration config = (Configuration)this.configurationService.load(configId).toBlocking().firstOrDefault((Object)new Configuration(configId, new HashMap<String, String>()));
        if (config.get("jobId") == null) {
            logger.info((Object)"Preparing to create and schedule COMPRESS_DATA job");
            long nextStart = LocalDateTime.now(ZoneOffset.UTC).with(DateTimeService.startOfNextOddHour()).toInstant(ZoneOffset.UTC).toEpochMilli();
            JobDetails jobDetails = (JobDetails)this.scheduler.scheduleJob("COMPRESS_DATA", "COMPRESS_DATA", ImmutableMap.of(), new RepeatingTrigger.Builder().withTriggerTime(nextStart).withInterval(2, TimeUnit.HOURS).build()).toBlocking().value();
            backgroundJobs.add(jobDetails);
            this.configurationService.save(configId, "jobId", jobDetails.getJobId().toString()).toBlocking();
            logger.info((Object)("Created and scheduled " + jobDetails));
        }
    }
}

