/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.objects.AbstractObject2ObjectMap;
import it.unimi.dsi.fastutil.objects.AbstractObjectCollection;
import it.unimi.dsi.fastutil.objects.AbstractObjectSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import it.unimi.dsi.fastutil.objects.ObjectCollection;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.NoSuchElementException;

public class Object2ObjectOpenHashMap<K, V>
extends AbstractObject2ObjectMap<K, V>
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient K[] key;
    protected transient V[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Object2ObjectMap.FastEntrySet<K, V> entries;
    protected volatile transient ObjectSet<K> keys;
    protected volatile transient ObjectCollection<V> values;

    public Object2ObjectOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new Object[this.n];
        this.value = new Object[this.n];
        this.used = new boolean[this.n];
    }

    public Object2ObjectOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Object2ObjectOpenHashMap() {
        this(16, 0.75f);
    }

    public Object2ObjectOpenHashMap(Map<? extends K, ? extends V> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Object2ObjectOpenHashMap(Map<? extends K, ? extends V> m) {
        this(m, 0.75f);
    }

    public Object2ObjectOpenHashMap(Object2ObjectMap<K, V> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Object2ObjectOpenHashMap(Object2ObjectMap<K, V> m) {
        this(m, 0.75f);
    }

    public Object2ObjectOpenHashMap(K[] k, V[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Object2ObjectOpenHashMap(K[] k, V[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public V put(K k, V v) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode() ^ this.mask)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == null ? k == null : this.key[pos].equals(k)) {
                V oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return (V)this.defRetValue;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = (this.key[pos] == null ? 142593372 : HashCommon.murmurHash3(this.key[pos].hashCode() ^ this.mask)) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
        }
        this.used[last] = false;
        this.key[last] = null;
        this.value[last] = null;
        return last;
    }

    @Override
    public V remove(Object k) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode() ^ this.mask)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == null ? k == null : this.key[pos].equals(k)) {
                --this.size;
                V v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    @Override
    public V get(Object k) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode() ^ this.mask)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == null ? k == null : this.key[pos].equals(k)) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return (V)this.defRetValue;
    }

    @Override
    public boolean containsKey(Object k) {
        int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode() ^ this.mask)) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == null ? k == null : this.key[pos].equals(k)) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object v) {
        V[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || !(value[i] == null ? v == null : value[i].equals(v))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        ObjectArrays.fill(this.key, null);
        ObjectArrays.fill(this.value, null);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    public Object2ObjectMap.FastEntrySet<K, V> object2ObjectEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public ObjectSet<K> keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ObjectCollection<V> values() {
        if (this.values == null) {
            this.values = new AbstractObjectCollection<V>(){

                @Override
                public ObjectIterator<V> iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Object2ObjectOpenHashMap.this.size;
                }

                @Override
                public boolean contains(Object v) {
                    return Object2ObjectOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Object2ObjectOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = 0;
        boolean[] used = this.used;
        K[] key = this.key;
        V[] value = this.value;
        int mask = newN - 1;
        Object[] newKey = new Object[newN];
        Object[] newValue = new Object[newN];
        boolean[] newUsed = new boolean[newN];
        int j = this.size;
        while (j-- != 0) {
            while (!used[i]) {
                ++i;
            }
            K k = key[i];
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode() ^ mask)) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            ++i;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
    }

    public Object2ObjectOpenHashMap<K, V> clone() {
        Object2ObjectOpenHashMap c;
        try {
            c = (Object2ObjectOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (Object[])this.key.clone();
        c.value = (Object[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            if (this != this.key[i]) {
                int n = t = this.key[i] == null ? 0 : this.key[i].hashCode();
            }
            if (this != this.value[i]) {
                t ^= this.value[i] == null ? 0 : this.value[i].hashCode();
            }
            h += t;
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        K[] key = this.key;
        V[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeObject(key[e]);
            s.writeObject(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new Object[this.n];
        Object[] key = this.key;
        this.value = new Object[this.n];
        Object[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            Object k = s.readObject();
            Object v = s.readObject();
            pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode() ^ this.mask)) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ObjectIterator<V> {
        @Override
        public V next() {
            return Object2ObjectOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractObjectSet<K> {
        private KeySet() {
        }

        @Override
        public ObjectIterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Object2ObjectOpenHashMap.this.size;
        }

        @Override
        public boolean contains(Object k) {
            return Object2ObjectOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(Object k) {
            int oldSize = Object2ObjectOpenHashMap.this.size;
            Object2ObjectOpenHashMap.this.remove(k);
            return Object2ObjectOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Object2ObjectOpenHashMap.this.clear();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements ObjectIterator<K> {
        @Override
        public K next() {
            return Object2ObjectOpenHashMap.this.key[this.nextEntry()];
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSet<Object2ObjectMap.Entry<K, V>>
    implements Object2ObjectMap.FastEntrySet<K, V> {
        private MapEntrySet() {
        }

        @Override
        public ObjectIterator<Object2ObjectMap.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public ObjectIterator<Object2ObjectMap.Entry<K, V>> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode() ^ Object2ObjectOpenHashMap.this.mask)) & Object2ObjectOpenHashMap.this.mask;
            while (Object2ObjectOpenHashMap.this.used[pos]) {
                if (Object2ObjectOpenHashMap.this.key[pos] == null ? k == null : Object2ObjectOpenHashMap.this.key[pos].equals(k)) {
                    return Object2ObjectOpenHashMap.this.value[pos] == null ? e.getValue() == null : Object2ObjectOpenHashMap.this.value[pos].equals(e.getValue());
                }
                pos = pos + 1 & Object2ObjectOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode() ^ Object2ObjectOpenHashMap.this.mask)) & Object2ObjectOpenHashMap.this.mask;
            while (Object2ObjectOpenHashMap.this.used[pos]) {
                if (Object2ObjectOpenHashMap.this.key[pos] == null ? k == null : Object2ObjectOpenHashMap.this.key[pos].equals(k)) {
                    Object2ObjectOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Object2ObjectOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Object2ObjectOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Object2ObjectOpenHashMap.this.clear();
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectIterator<Object2ObjectMap.Entry<K, V>> {
        final AbstractObject2ObjectMap.BasicEntry<K, V> entry;

        private FastEntryIterator() {
            this.entry = new AbstractObject2ObjectMap.BasicEntry<Object, Object>(null, null);
        }

        @Override
        public AbstractObject2ObjectMap.BasicEntry<K, V> next() {
            int e = this.nextEntry();
            this.entry.key = Object2ObjectOpenHashMap.this.key[e];
            this.entry.value = Object2ObjectOpenHashMap.this.value[e];
            return this.entry;
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectIterator<Object2ObjectMap.Entry<K, V>> {
        private MapEntry entry;

        private EntryIterator() {
        }

        @Override
        public Object2ObjectMap.Entry<K, V> next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }
    }

    private class MapIterator {
        int pos;
        int last;
        int c;
        ObjectArrayList<K> wrapped;

        private MapIterator() {
            this.pos = Object2ObjectOpenHashMap.this.n;
            this.last = -1;
            this.c = Object2ObjectOpenHashMap.this.size;
            boolean[] used = Object2ObjectOpenHashMap.this.used;
            if (this.c != 0) {
                while (!used[--this.pos]) {
                }
            }
        }

        public boolean hasNext() {
            return this.c != 0;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.pos < 0) {
                this.last = --this.pos;
                Object k = this.wrapped.get(-this.pos - 2);
                int pos = (k == null ? 142593372 : HashCommon.murmurHash3(k.hashCode() ^ Object2ObjectOpenHashMap.this.mask)) & Object2ObjectOpenHashMap.this.mask;
                while (Object2ObjectOpenHashMap.this.used[pos]) {
                    if (Object2ObjectOpenHashMap.this.key[pos] == null ? k == null : Object2ObjectOpenHashMap.this.key[pos].equals(k)) {
                        return pos;
                    }
                    pos = pos + 1 & Object2ObjectOpenHashMap.this.mask;
                }
            }
            this.last = this.pos;
            if (this.c != 0) {
                boolean[] used = Object2ObjectOpenHashMap.this.used;
                while (this.pos-- != 0 && !used[this.pos]) {
                }
            }
            return this.last;
        }

        protected final int shiftKeys(int pos) {
            int last;
            while (true) {
                last = pos;
                pos = last + 1 & Object2ObjectOpenHashMap.this.mask;
                while (Object2ObjectOpenHashMap.this.used[pos]) {
                    int slot = (Object2ObjectOpenHashMap.this.key[pos] == null ? 142593372 : HashCommon.murmurHash3(Object2ObjectOpenHashMap.this.key[pos].hashCode() ^ Object2ObjectOpenHashMap.this.mask)) & Object2ObjectOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Object2ObjectOpenHashMap.this.mask;
                }
                if (!Object2ObjectOpenHashMap.this.used[pos]) break;
                if (pos < last) {
                    if (this.wrapped == null) {
                        this.wrapped = new ObjectArrayList();
                    }
                    this.wrapped.add(Object2ObjectOpenHashMap.this.key[pos]);
                }
                Object2ObjectOpenHashMap.this.key[last] = Object2ObjectOpenHashMap.this.key[pos];
                Object2ObjectOpenHashMap.this.value[last] = Object2ObjectOpenHashMap.this.value[pos];
            }
            Object2ObjectOpenHashMap.this.used[last] = false;
            Object2ObjectOpenHashMap.this.key[last] = null;
            Object2ObjectOpenHashMap.this.value[last] = null;
            return last;
        }

        public void remove() {
            if (this.last == -1) {
                throw new IllegalStateException();
            }
            if (this.pos < -1) {
                Object2ObjectOpenHashMap.this.remove(this.wrapped.set(-this.pos - 2, (Object)null));
                this.last = -1;
                return;
            }
            --Object2ObjectOpenHashMap.this.size;
            if (this.shiftKeys(this.last) == this.pos && this.c > 0) {
                ++this.c;
                this.nextEntry();
            }
            this.last = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Object2ObjectMap.Entry<K, V>,
    Map.Entry<K, V> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public K getKey() {
            return Object2ObjectOpenHashMap.this.key[this.index];
        }

        @Override
        public V getValue() {
            return Object2ObjectOpenHashMap.this.value[this.index];
        }

        @Override
        public V setValue(V v) {
            Object oldValue = Object2ObjectOpenHashMap.this.value[this.index];
            Object2ObjectOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return (Object2ObjectOpenHashMap.this.key[this.index] == null ? e.getKey() == null : Object2ObjectOpenHashMap.this.key[this.index].equals(e.getKey())) && (Object2ObjectOpenHashMap.this.value[this.index] == null ? e.getValue() == null : Object2ObjectOpenHashMap.this.value[this.index].equals(e.getValue()));
        }

        @Override
        public int hashCode() {
            return (Object2ObjectOpenHashMap.this.key[this.index] == null ? 0 : Object2ObjectOpenHashMap.this.key[this.index].hashCode()) ^ (Object2ObjectOpenHashMap.this.value[this.index] == null ? 0 : Object2ObjectOpenHashMap.this.value[this.index].hashCode());
        }

        public String toString() {
            return Object2ObjectOpenHashMap.this.key[this.index] + "=>" + Object2ObjectOpenHashMap.this.value[this.index];
        }
    }
}

