/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tracing;

import java.net.InetAddress;
import java.util.Collections;
import java.util.UUID;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.exceptions.OverloadedException;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.TraceKeyspace;
import org.apache.cassandra.tracing.TraceState;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.WrappedRunnable;

public class TraceStateImpl
extends TraceState {
    public TraceStateImpl(InetAddress coordinator, UUID sessionId, Tracing.TraceType traceType) {
        super(coordinator, sessionId, traceType);
    }

    @Override
    protected void traceImpl(String message) {
        String threadName = Thread.currentThread().getName();
        int elapsed = this.elapsed();
        TraceStateImpl.executeMutation(TraceKeyspace.makeEventMutation(this.sessionIdBytes, message, elapsed, threadName, this.ttl));
    }

    static void executeMutation(final Mutation mutation) {
        StageManager.getStage(Stage.TRACING).execute(new WrappedRunnable(){

            @Override
            protected void runMayThrow() throws Exception {
                TraceStateImpl.mutateWithCatch(mutation);
            }
        });
    }

    static void mutateWithCatch(Mutation mutation) {
        try {
            StorageProxy.mutate(Collections.singletonList(mutation), ConsistencyLevel.ANY);
        }
        catch (OverloadedException e) {
            Tracing.logger.warn("Too many nodes are overloaded to save trace events");
        }
    }
}

