/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.tools.nodetool;

import com.google.common.base.Preconditions;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.db.ColumnFamilyStoreMBean;
import org.apache.cassandra.tools.NodeProbe;
import org.apache.cassandra.tools.NodeTool;

@Command(name="getcompactionthreshold", description="Print min and max compaction thresholds for a given table")
public class GetCompactionThreshold
extends NodeTool.NodeToolCmd {
    @Arguments(usage="<keyspace> <table>", description="The keyspace with a table")
    private List<String> args = new ArrayList<String>();

    @Override
    public void execute(NodeProbe probe) {
        Preconditions.checkArgument(this.args.size() == 2, "getcompactionthreshold requires ks and cf args");
        String ks = this.args.get(0);
        String cf = this.args.get(1);
        ColumnFamilyStoreMBean cfsProxy = probe.getCfsProxy(ks, cf);
        System.out.println("Current compaction thresholds for " + ks + "/" + cf + ": \n" + " min = " + cfsProxy.getMinimumCompactionThreshold() + ", " + " max = " + cfsProxy.getMaximumCompactionThreshold());
    }
}

