/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.Collection;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.OperationType;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.SSTableMultiWriter;
import org.apache.cassandra.io.sstable.SimpleSSTableMultiWriter;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.apache.cassandra.utils.concurrent.Transactional;

public class SSTableTxnWriter
extends Transactional.AbstractTransactional
implements Transactional {
    private final LifecycleTransaction txn;
    private final SSTableMultiWriter writer;

    public SSTableTxnWriter(LifecycleTransaction txn, SSTableMultiWriter writer) {
        this.txn = txn;
        this.writer = writer;
    }

    public boolean append(UnfilteredRowIterator iterator) {
        return this.writer.append(iterator);
    }

    public String getFilename() {
        return this.writer.getFilename();
    }

    public long getFilePointer() {
        return this.writer.getFilePointer();
    }

    @Override
    protected Throwable doCommit(Throwable accumulate) {
        return this.writer.commit(this.txn.commit(accumulate));
    }

    @Override
    protected Throwable doAbort(Throwable accumulate) {
        return this.txn.abort(this.writer.abort(accumulate));
    }

    @Override
    protected void doPrepare() {
        this.writer.prepareToCommit();
        this.txn.prepareToCommit();
    }

    @Override
    protected Throwable doPostCleanup(Throwable accumulate) {
        this.txn.close();
        this.writer.close();
        return super.doPostCleanup(accumulate);
    }

    public Collection<SSTableReader> finish(boolean openResult) {
        this.writer.setOpenResult(openResult);
        this.finish();
        return this.writer.finished();
    }

    public static SSTableTxnWriter create(ColumnFamilyStore cfs, Descriptor descriptor, long keyCount, long repairedAt, int sstableLevel, SerializationHeader header) {
        LifecycleTransaction txn = LifecycleTransaction.offline(OperationType.WRITE);
        SSTableMultiWriter writer = cfs.createSSTableMultiWriter(descriptor, keyCount, repairedAt, sstableLevel, header, txn);
        return new SSTableTxnWriter(txn, writer);
    }

    public static SSTableTxnWriter create(CFMetaData cfm, Descriptor descriptor, long keyCount, long repairedAt, int sstableLevel, SerializationHeader header) {
        LifecycleTransaction txn = LifecycleTransaction.offline(OperationType.WRITE);
        MetadataCollector collector = new MetadataCollector(cfm.comparator).sstableLevel(sstableLevel);
        SSTableMultiWriter writer = SimpleSSTableMultiWriter.create(descriptor, keyCount, repairedAt, cfm, collector, header, txn);
        return new SSTableTxnWriter(txn, writer);
    }

    public static SSTableTxnWriter create(ColumnFamilyStore cfs, String filename, long keyCount, long repairedAt, int sstableLevel, SerializationHeader header) {
        Descriptor desc = Descriptor.fromFilename(filename);
        return SSTableTxnWriter.create(cfs, desc, keyCount, repairedAt, sstableLevel, header);
    }

    public static SSTableTxnWriter create(ColumnFamilyStore cfs, String filename, long keyCount, long repairedAt, SerializationHeader header) {
        return SSTableTxnWriter.create(cfs, filename, keyCount, repairedAt, 0, header);
    }
}

