/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.locator;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.cassandra.gms.ApplicationState;
import org.apache.cassandra.gms.EndpointState;
import org.apache.cassandra.gms.Gossiper;
import org.apache.cassandra.gms.IEndpointStateChangeSubscriber;
import org.apache.cassandra.gms.VersionedValue;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.net.MessagingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReconnectableSnitchHelper
implements IEndpointStateChangeSubscriber {
    private static final Logger logger = LoggerFactory.getLogger(ReconnectableSnitchHelper.class);
    private final IEndpointSnitch snitch;
    private final String localDc;
    private final boolean preferLocal;

    public ReconnectableSnitchHelper(IEndpointSnitch snitch, String localDc, boolean preferLocal) {
        this.snitch = snitch;
        this.localDc = localDc;
        this.preferLocal = preferLocal;
    }

    private void reconnect(InetAddress publicAddress, VersionedValue localAddressValue) {
        try {
            this.reconnect(publicAddress, InetAddress.getByName(localAddressValue.value));
        }
        catch (UnknownHostException e) {
            logger.error("Error in getting the IP address resolved: ", e);
        }
    }

    private void reconnect(InetAddress publicAddress, InetAddress localAddress) {
        if (this.snitch.getDatacenter(publicAddress).equals(this.localDc) && !MessagingService.instance().getConnectionPool(publicAddress).endPoint().equals(localAddress)) {
            MessagingService.instance().getConnectionPool(publicAddress).reset(localAddress);
            logger.debug(String.format("Intiated reconnect to an Internal IP %s for the %s", localAddress, publicAddress));
        }
    }

    @Override
    public void beforeChange(InetAddress endpoint, EndpointState currentState, ApplicationState newStateKey, VersionedValue newValue) {
    }

    @Override
    public void onJoin(InetAddress endpoint, EndpointState epState) {
        if (this.preferLocal && !Gossiper.instance.isDeadState(epState) && epState.getApplicationState(ApplicationState.INTERNAL_IP) != null) {
            this.reconnect(endpoint, epState.getApplicationState(ApplicationState.INTERNAL_IP));
        }
    }

    @Override
    public void onChange(InetAddress endpoint, ApplicationState state, VersionedValue value) {
        if (this.preferLocal && !Gossiper.instance.isDeadState(Gossiper.instance.getEndpointStateForEndpoint(endpoint)) && state == ApplicationState.INTERNAL_IP) {
            this.reconnect(endpoint, value);
        }
    }

    @Override
    public void onAlive(InetAddress endpoint, EndpointState state) {
        if (this.preferLocal && state.getApplicationState(ApplicationState.INTERNAL_IP) != null) {
            this.reconnect(endpoint, state.getApplicationState(ApplicationState.INTERNAL_IP));
        }
    }

    @Override
    public void onDead(InetAddress endpoint, EndpointState state) {
    }

    @Override
    public void onRemove(InetAddress endpoint) {
    }

    @Override
    public void onRestart(InetAddress endpoint, EndpointState state) {
    }
}

