/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.dropwizard;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class MetaData {
    private static final String HAWKULAR_METRICS_NAMESPACE = "org.hawkular.metrics";
    private static final String NAMESPACE_PROPERTY = "namespace";
    private static final String NAME_PROPERTY = "name";
    private static final String SCOPE_PROPERTY = "scope";
    private static final String TYPE_PROPERTY = "type";
    private static final String HOSTNAME_PROPERTY = "hostname";
    private static final Set<String> REQUIRED_PROPERTIES = ImmutableSet.of("name", "scope", "namespace", "type", "hostname");
    private Map<String, String> tags = new HashMap<String, String>();

    public MetaData(String name, String scope, String type, String hostname) {
        this(name, scope, type, hostname, Collections.emptyMap());
    }

    public MetaData(String name, String scope, String type, String hostname, Map<String, String> optional) {
        this.tags.put(NAMESPACE_PROPERTY, HAWKULAR_METRICS_NAMESPACE);
        this.tags.put(NAME_PROPERTY, name);
        this.tags.put(SCOPE_PROPERTY, scope);
        this.tags.put(TYPE_PROPERTY, type);
        this.tags.put(HOSTNAME_PROPERTY, hostname);
        this.tags.putAll(optional);
    }

    public String getNamespace() {
        return this.tags.get(NAMESPACE_PROPERTY);
    }

    public String getName() {
        return this.tags.get(NAME_PROPERTY);
    }

    public String getScope() {
        return this.tags.get(SCOPE_PROPERTY);
    }

    public String getType() {
        return this.tags.get(TYPE_PROPERTY);
    }

    public String getHostname() {
        return this.tags.get(HOSTNAME_PROPERTY);
    }

    public Map<String, String> getTags() {
        return ImmutableMap.copyOf(this.tags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetaData metaData = (MetaData)o;
        return Objects.equals(this.tags, metaData.tags);
    }

    public int hashCode() {
        return Objects.hash(this.tags);
    }

    public String toString() {
        Map<String, String> optional = this.tags.entrySet().stream().filter(e -> !REQUIRED_PROPERTIES.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        return MoreObjects.toStringHelper(this).add(NAMESPACE_PROPERTY, this.getNamespace()).add(HOSTNAME_PROPERTY, this.getHostname()).add(NAME_PROPERTY, this.getName()).add(SCOPE_PROPERTY, this.getScope()).add(TYPE_PROPERTY, this.getType()).add("optional", optional).toString();
    }
}

