/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.generator;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import com.google.common.base.Stopwatch;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cassandra.io.sstable.CQLSSTableWriter;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.math3.random.ValueServer;
import org.hawkular.metrics.core.service.TimeUUIDUtils;
import org.hawkular.metrics.model.MetricType;
import org.slf4j.LoggerFactory;

public class DataGenerator {
    public static final int STATUS_SHOW_USAGE = 1;
    private Options options;
    private String keyspace;
    private File dataDir;
    private int tenants;
    private int metricsPerTenant;
    private long interval;
    private long startTime;
    private long endTime;
    private int bufferSize;
    private Pattern startEndRegexp = Pattern.compile("(\\d+)(m|h|d)");
    private Pattern intervalRegexp = Pattern.compile("(\\d+)(s|m|h|d)");

    public DataGenerator() {
        Option keyspace = new Option(null, "keyspace", true, "The keyspace in which data will be stored. Defaults to hawkular_metrics");
        Option dataDir = new Option(null, "data-dir", true, "The directory in which to store data files. Defaults to ./data.");
        Option tenants = new Option(null, "tenants", true, "The number of tenants. Defaults to 100.");
        Option metricsPerTenant = new Option(null, "metrics-per-tenant", true, "The number of metrics per tenant. Defaults to 100.");
        Option start = new Option(null, "start", true, "Specified using the regex pattern (d+)(m|h|d) where m is for minutes, h is for hours, and d is for days. The value is subtracted from \"now\" to determine a start time. A value of 4h would be interpreted as four hours ago. Defaults to one hour ago. Must be less than the end time.");
        Option end = new Option(null, "end", true, "Specified using the regex pattern (d+)(m|h|d) where m is for minutes, h is for hours, and d is for days. The value is substracted from \"now\" to determine the end time. A value of 4h would be interpreted as four hours ago. Defaults to \"now\". Must be greater than the start time.");
        Option interval = new Option(null, "interval", true, "Specified using the regex pattern (d+)(s|m|h|d) where s is for seconds, m for minutes, h for hours, and d for days. Used to determine the number of data points written. Defaults to one minute.");
        Option bufferSize = new Option(null, "buffer-size", true, "Defines how much data will be buffered before being written out as a new SSTable. This corresponds roughly to the data size of the SSTable. Interpreted as mega bytes and defaults to 128 MB.");
        this.options = new Options().addOption(new Option("h", "help", false, "Show this message.")).addOption(keyspace).addOption(dataDir).addOption(tenants).addOption(metricsPerTenant).addOption(start).addOption(end).addOption(interval).addOption(bufferSize);
    }

    public void run(CommandLine cmdLine) throws Exception {
        Stopwatch stopwatch = Stopwatch.createStarted();
        if (cmdLine.hasOption("h")) {
            this.printUsage();
            return;
        }
        this.keyspace = cmdLine.getOptionValue("keyspace", "hawkular_metrics");
        this.dataDir = new File(cmdLine.getOptionValue("data-dir", "./data"));
        this.dataDir.mkdirs();
        this.tenants = Integer.parseInt(cmdLine.getOptionValue("tenants", "100"));
        this.metricsPerTenant = Integer.parseInt(cmdLine.getOptionValue("metrics-per-tenant", "100"));
        ValueServer valueServer = new ValueServer();
        valueServer.setMu(100.0);
        valueServer.setMode(2);
        String endValue = cmdLine.getOptionValue("end");
        this.endTime = endValue == null ? System.currentTimeMillis() : this.getDuration("end", endValue, this.startEndRegexp);
        String startValue = cmdLine.getOptionValue("start");
        this.startTime = startValue == null ? this.endTime - TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS) : this.endTime - this.getDuration("start", startValue, this.startEndRegexp);
        String intervalValue = cmdLine.getOptionValue("interval");
        this.interval = intervalValue == null ? TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES) : this.getDuration("interval", intervalValue, this.intervalRegexp);
        this.bufferSize = Integer.parseInt(cmdLine.getOptionValue("buffer-size", "128"));
        CQLSSTableWriter writer = this.createWriter();
        long totalDataPoints = 0L;
        for (long currentTime = this.startTime; currentTime <= this.endTime; currentTime += this.interval) {
            for (int i = 0; i < this.tenants; ++i) {
                for (int j = 0; j < this.metricsPerTenant; ++j) {
                    UUID timeUUID = TimeUUIDUtils.getTimeUUID(currentTime);
                    writer.addRow("TENANT-" + i, MetricType.GAUGE.getCode(), "GAUGE-" + j, 0L, timeUUID, valueServer.getNext());
                    ++totalDataPoints;
                }
            }
        }
        writer.close();
        stopwatch.stop();
        System.out.println("\n\nStart time: " + this.startTime);
        System.out.println("End time: " + this.endTime);
        System.out.println("Total duration: " + (this.endTime - this.startTime) + " ms");
        System.out.println("Interval: " + this.interval);
        System.out.println("Tenants: " + this.tenants);
        System.out.println("Metrics per tenant: " + this.metricsPerTenant);
        System.out.println("Total data points: " + totalDataPoints);
        System.out.println("Execution time: " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms");
    }

    private long getDuration(String option, String optionValue, Pattern regexp) {
        Matcher matcher = regexp.matcher(optionValue);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(optionValue + " is an invalid value for --" + option);
        }
        long value = Long.valueOf(matcher.group(1));
        String units = matcher.group(2);
        return this.convertDurationToMillis(value, units);
    }

    private long convertDurationToMillis(long value, String units) {
        switch (units) {
            case "s": {
                return TimeUnit.MILLISECONDS.convert(value, TimeUnit.SECONDS);
            }
            case "m": {
                return TimeUnit.MILLISECONDS.convert(value, TimeUnit.MINUTES);
            }
            case "h": {
                return TimeUnit.MILLISECONDS.convert(value, TimeUnit.HOURS);
            }
            case "d": {
                return TimeUnit.MILLISECONDS.convert(value, TimeUnit.DAYS);
            }
        }
        throw new IllegalArgumentException(units + " is an invalid time unit");
    }

    private CQLSSTableWriter createWriter() {
        String schema = "CREATE TABLE " + this.keyspace + ".data ( tenant_id text, type tinyint, metric text, dpart bigint, time timeuuid, data_retention int static, n_value double, availability blob, l_value bigint, PRIMARY KEY ((tenant_id, type, metric, dpart), time) ) WITH CLUSTERING ORDER BY (time DESC)";
        String insertGauge = "INSERT INTO " + this.keyspace + ".data (tenant_id, type, metric, dpart, time, n_value) VALUES (?, ?, ?, ?, ?, ?)";
        return CQLSSTableWriter.builder().inDirectory(this.dataDir).forTable(schema).using(insertGauge).withBufferSizeInMB(this.bufferSize).build();
    }

    private void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        String syntax = "java -jar hawkular-metrics-data-generator.jar [options]";
        String header = "";
        helpFormatter.printHelp(syntax, header, this.getHelpOptions(), null);
    }

    public Options getOptions() {
        return this.options;
    }

    public Options getHelpOptions() {
        Options helpOptions = new Options();
        for (Option option : this.options.getOptions()) {
            helpOptions.addOption(option);
        }
        return helpOptions;
    }

    public static void main(String[] args) throws Exception {
        Logger root = (Logger)LoggerFactory.getLogger("ROOT");
        root.setLevel(Level.WARN);
        DataGenerator dataGenerator = new DataGenerator();
        try {
            PosixParser parser = new PosixParser();
            CommandLine cmdLine = parser.parse(dataGenerator.getOptions(), args);
            dataGenerator.run(cmdLine);
        }
        catch (ParseException parseException) {
            dataGenerator.printUsage();
            System.exit(1);
        }
    }
}

