/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.CFName;
import org.apache.cassandra.cql3.CQL3Type;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.statements.CFProperties;
import org.apache.cassandra.cql3.statements.CFStatement;
import org.apache.cassandra.cql3.statements.ParsedStatement;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.CompactTables;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CollectionType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.EmptyType;
import org.apache.cassandra.db.marshal.ReversedType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.AlreadyExistsException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.TableParams;
import org.apache.cassandra.schema.Types;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Event;
import org.apache.commons.lang3.StringUtils;

public class CreateTableStatement
extends SchemaAlteringStatement {
    private List<AbstractType<?>> keyTypes;
    private List<AbstractType<?>> clusteringTypes;
    private final Map<ByteBuffer, CollectionType> collections = new HashMap<ByteBuffer, CollectionType>();
    private final List<ColumnIdentifier> keyAliases = new ArrayList<ColumnIdentifier>();
    private final List<ColumnIdentifier> columnAliases = new ArrayList<ColumnIdentifier>();
    private boolean isDense;
    private boolean isCompound;
    private boolean hasCounters;
    private final Map<ColumnIdentifier, AbstractType> columns = new TreeMap<ColumnIdentifier, AbstractType>((o1, o2) -> o1.bytes.compareTo(o2.bytes));
    private final Set<ColumnIdentifier> staticColumns;
    private final TableParams params;
    private final boolean ifNotExists;
    private final UUID id;

    public CreateTableStatement(CFName name, TableParams params, boolean ifNotExists, Set<ColumnIdentifier> staticColumns, UUID id) {
        super(name);
        this.params = params;
        this.ifNotExists = ifNotExists;
        this.staticColumns = staticColumns;
        this.id = id;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.hasKeyspaceAccess(this.keyspace(), Permission.CREATE);
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws RequestValidationException {
        try {
            MigrationManager.announceNewColumnFamily(this.getCFMetaData(), isLocalOnly);
            return new Event.SchemaChange(Event.SchemaChange.Change.CREATED, Event.SchemaChange.Target.TABLE, this.keyspace(), this.columnFamily());
        }
        catch (AlreadyExistsException e) {
            if (this.ifNotExists) {
                return null;
            }
            throw e;
        }
    }

    @Override
    protected void grantPermissionsToCreator(QueryState state) {
        try {
            DataResource resource = DataResource.table(this.keyspace(), this.columnFamily());
            DatabaseDescriptor.getAuthorizer().grant(AuthenticatedUser.SYSTEM_USER, resource.applicablePermissions(), resource, RoleResource.role(state.getClientState().getUser().getName()));
        }
        catch (RequestExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public CFMetaData.Builder metadataBuilder() {
        boolean isCompactTable;
        int i;
        CFMetaData.Builder builder = CFMetaData.Builder.create(this.keyspace(), this.columnFamily(), this.isDense, this.isCompound, this.hasCounters);
        builder.withId(this.id);
        for (i = 0; i < this.keyAliases.size(); ++i) {
            builder.addPartitionKey(this.keyAliases.get(i), this.keyTypes.get(i));
        }
        for (i = 0; i < this.columnAliases.size(); ++i) {
            builder.addClusteringColumn(this.columnAliases.get(i), this.clusteringTypes.get(i));
        }
        boolean isStaticCompact = !this.isDense && !this.isCompound;
        for (Map.Entry<ColumnIdentifier, AbstractType> entry : this.columns.entrySet()) {
            ColumnIdentifier name = entry.getKey();
            if (this.staticColumns.contains(name) || isStaticCompact) {
                builder.addStaticColumn(name, entry.getValue());
                continue;
            }
            builder.addRegularColumn(name, entry.getValue());
        }
        boolean bl = isCompactTable = this.isDense || !this.isCompound;
        if (isCompactTable) {
            CompactTables.DefaultNames names = CompactTables.defaultNameGenerator(builder.usedColumnNames());
            if (isStaticCompact) {
                builder.addClusteringColumn(names.defaultClusteringName(), (AbstractType)UTF8Type.instance);
                builder.addRegularColumn(names.defaultCompactValueName(), this.hasCounters ? CounterColumnType.instance : BytesType.instance);
            } else if (this.isDense && !builder.hasRegulars()) {
                builder.addRegularColumn(names.defaultCompactValueName(), (AbstractType)EmptyType.instance);
            }
        }
        return builder;
    }

    public CFMetaData getCFMetaData() {
        return this.metadataBuilder().build().params(this.params);
    }

    public TableParams params() {
        return this.params;
    }

    public static class RawStatement
    extends CFStatement {
        private final Map<ColumnIdentifier, CQL3Type.Raw> definitions = new HashMap<ColumnIdentifier, CQL3Type.Raw>();
        public final CFProperties properties = new CFProperties();
        private final List<List<ColumnIdentifier>> keyAliases = new ArrayList<List<ColumnIdentifier>>();
        private final List<ColumnIdentifier> columnAliases = new ArrayList<ColumnIdentifier>();
        private final Set<ColumnIdentifier> staticColumns = new HashSet<ColumnIdentifier>();
        private final Multiset<ColumnIdentifier> definedNames = HashMultiset.create(1);
        private final boolean ifNotExists;

        public RawStatement(CFName name, boolean ifNotExists) {
            super(name);
            this.ifNotExists = ifNotExists;
        }

        @Override
        public ParsedStatement.Prepared prepare() throws RequestValidationException {
            KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.keyspace());
            if (ksm == null) {
                throw new ConfigurationException(String.format("Keyspace %s doesn't exist", this.keyspace()));
            }
            return this.prepare(ksm.types);
        }

        public ParsedStatement.Prepared prepare(Types udts) throws RequestValidationException {
            boolean bl;
            if (!this.columnFamily().matches("\\w+")) {
                throw new InvalidRequestException(String.format("\"%s\" is not a valid table name (must be alphanumeric character or underscore only: [a-zA-Z_0-9]+)", this.columnFamily()));
            }
            if (this.columnFamily().length() > 48) {
                throw new InvalidRequestException(String.format("Table names shouldn't be more than %s characters long (got \"%s\")", 48, this.columnFamily()));
            }
            for (Multiset.Entry<ColumnIdentifier> entry : this.definedNames.entrySet()) {
                if (entry.getCount() <= 1) continue;
                throw new InvalidRequestException(String.format("Multiple definition of identifier %s", entry.getElement()));
            }
            this.properties.validate();
            TableParams params = this.properties.properties.asNewTableParams();
            CreateTableStatement stmt = new CreateTableStatement(this.cfName, params, this.ifNotExists, this.staticColumns, this.properties.properties.getId());
            for (Map.Entry<ColumnIdentifier, CQL3Type.Raw> entry : this.definitions.entrySet()) {
                ColumnIdentifier id = entry.getKey();
                CQL3Type pt = entry.getValue().prepare(this.keyspace(), udts);
                if (pt.isCollection() && ((CollectionType)pt.getType()).isMultiCell()) {
                    stmt.collections.put(id.bytes, (CollectionType)pt.getType());
                }
                if (entry.getValue().isCounter()) {
                    stmt.hasCounters = true;
                }
                stmt.columns.put(id, pt.getType());
            }
            if (this.keyAliases.isEmpty()) {
                throw new InvalidRequestException("No PRIMARY KEY specifed (exactly one required)");
            }
            if (this.keyAliases.size() > 1) {
                throw new InvalidRequestException("Multiple PRIMARY KEYs specifed (exactly one required)");
            }
            if (stmt.hasCounters && params.defaultTimeToLive > 0) {
                throw new InvalidRequestException("Cannot set default_time_to_live on a table with counters");
            }
            List<ColumnIdentifier> kAliases = this.keyAliases.get(0);
            stmt.keyTypes = new ArrayList(kAliases.size());
            for (ColumnIdentifier alias : kAliases) {
                stmt.keyAliases.add(alias);
                AbstractType<?> t = this.getTypeAndRemove(stmt.columns, alias);
                if (t.asCQL3Type().getType() instanceof CounterColumnType) {
                    throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", alias));
                }
                if (this.staticColumns.contains(alias)) {
                    throw new InvalidRequestException(String.format("Static column %s cannot be part of the PRIMARY KEY", alias));
                }
                stmt.keyTypes.add(t);
            }
            stmt.clusteringTypes = new ArrayList(this.columnAliases.size());
            for (ColumnIdentifier t : this.columnAliases) {
                stmt.columnAliases.add(t);
                AbstractType<?> type = this.getTypeAndRemove(stmt.columns, t);
                if (type.asCQL3Type().getType() instanceof CounterColumnType) {
                    throw new InvalidRequestException(String.format("counter type is not supported for PRIMARY KEY part %s", t));
                }
                if (this.staticColumns.contains(t)) {
                    throw new InvalidRequestException(String.format("Static column %s cannot be part of the PRIMARY KEY", t));
                }
                stmt.clusteringTypes.add(type);
            }
            if (stmt.hasCounters) {
                for (AbstractType type : stmt.columns.values()) {
                    if (type.isCounter()) continue;
                    throw new InvalidRequestException("Cannot mix counter and non counter columns in the same table");
                }
            }
            stmt.isDense = (bl = this.properties.useCompactStorage) && !stmt.clusteringTypes.isEmpty();
            stmt.isCompound = !bl || stmt.clusteringTypes.size() > 1;
            if (bl) {
                if (!stmt.collections.isEmpty()) {
                    throw new InvalidRequestException("Non-frozen collection types are not supported with COMPACT STORAGE");
                }
                if (!this.staticColumns.isEmpty()) {
                    throw new InvalidRequestException("Static columns are not supported in COMPACT STORAGE tables");
                }
                if (stmt.clusteringTypes.isEmpty() && stmt.columns.isEmpty()) {
                    throw new InvalidRequestException("No definition found that is not part of the PRIMARY KEY");
                }
                if (stmt.isDense) {
                    if (stmt.columns.size() > 1) {
                        throw new InvalidRequestException(String.format("COMPACT STORAGE with composite PRIMARY KEY allows no more than one column not part of the PRIMARY KEY (got: %s)", StringUtils.join(stmt.columns.keySet(), ", ")));
                    }
                } else if (stmt.columns.isEmpty()) {
                    throw new InvalidRequestException("COMPACT STORAGE with non-composite PRIMARY KEY require one column not part of the PRIMARY KEY, none given");
                }
            } else if (stmt.clusteringTypes.isEmpty() && !this.staticColumns.isEmpty() && this.columnAliases.isEmpty()) {
                throw new InvalidRequestException("Static columns are only useful (and thus allowed) if the table has at least one clustering column");
            }
            if (!this.properties.definedOrdering.isEmpty()) {
                if (this.properties.definedOrdering.size() > this.columnAliases.size()) {
                    throw new InvalidRequestException("Only clustering key columns can be defined in CLUSTERING ORDER directive");
                }
                int i = 0;
                for (ColumnIdentifier id : this.properties.definedOrdering.keySet()) {
                    ColumnIdentifier c;
                    if (!id.equals(c = this.columnAliases.get(i))) {
                        if (this.properties.definedOrdering.containsKey(c)) {
                            throw new InvalidRequestException(String.format("The order of columns in the CLUSTERING ORDER directive must be the one of the clustering key (%s must appear before %s)", c, id));
                        }
                        throw new InvalidRequestException(String.format("Missing CLUSTERING ORDER for column %s", c));
                    }
                    ++i;
                }
            }
            return new ParsedStatement.Prepared(stmt);
        }

        private AbstractType<?> getTypeAndRemove(Map<ColumnIdentifier, AbstractType> columns, ColumnIdentifier t) throws InvalidRequestException {
            ReversedType type = columns.get(t);
            if (type == null) {
                throw new InvalidRequestException(String.format("Unknown definition %s referenced in PRIMARY KEY", t));
            }
            if (type.isCollection() && type.isMultiCell()) {
                throw new InvalidRequestException(String.format("Invalid collection type for PRIMARY KEY component %s", t));
            }
            columns.remove(t);
            Boolean isReversed = this.properties.definedOrdering.get(t);
            return isReversed != null && isReversed != false ? ReversedType.getInstance(type) : type;
        }

        public void addDefinition(ColumnIdentifier def, CQL3Type.Raw type, boolean isStatic) {
            this.definedNames.add(def);
            this.definitions.put(def, type);
            if (isStatic) {
                this.staticColumns.add(def);
            }
        }

        public void addKeyAliases(List<ColumnIdentifier> aliases) {
            this.keyAliases.add(aliases);
        }

        public void addColumnAlias(ColumnIdentifier alias) {
            this.columnAliases.add(alias);
        }
    }
}

