/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.dropwizard;

import com.codahale.metrics.Gauge;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Configuration;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.Metrics;
import com.datastax.driver.core.PoolingOptions;
import com.datastax.driver.core.Session;
import java.util.Optional;
import org.hawkular.metrics.core.dropwizard.HawkularMetricRegistry;

public class CassandraDriverMetrics {
    private static final String SCOPE = "com.datastax.driver";
    private static final String LOAD_TYPE = "Load";
    private static final String ERROR_TYPE = "Error";
    private HawkularMetricRegistry metricsRegistry;
    private Session session;

    public CassandraDriverMetrics(Session session, HawkularMetricRegistry metricsRegistry) {
        this.session = session;
        this.metricsRegistry = metricsRegistry;
    }

    public void registerAll() {
        Metrics driverMetrics = this.session.getCluster().getMetrics();
        this.registerLoadMetrics(driverMetrics);
        this.registerErrorMetrics(driverMetrics);
        this.registerPerHostMetrics();
    }

    private void registerErrorMetrics(Metrics driverMetrics) {
        this.metricsRegistry.register("ConnectionErrors", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getConnectionErrors());
        this.metricsRegistry.register("AuthenticationErrors", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getAuthenticationErrors());
        this.metricsRegistry.register("WriteTimeouts", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getWriteTimeouts());
        this.metricsRegistry.register("ReadTimeouts", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getReadTimeouts());
        this.metricsRegistry.register("Unavailables", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getUnavailables());
        this.metricsRegistry.register("ClientTimeouts", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getClientTimeouts());
        this.metricsRegistry.register("OtherErrors", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getOthers());
        this.metricsRegistry.register("Retries", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getRetries());
        this.metricsRegistry.register("RetriesOnReadTimeout", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getRetriesOnReadTimeout());
        this.metricsRegistry.register("RetriesOnWriteTimeout", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getRetriesOnWriteTimeout());
        this.metricsRegistry.register("RetriesOnUnavailable", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getRetriesOnUnavailable());
        this.metricsRegistry.register("RetriesOnClientTimeout", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getRetriesOnReadTimeout());
        this.metricsRegistry.register("RetriesOnConnectionError", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getRetriesOnConnectionError());
        this.metricsRegistry.register("RetriesOnOtherErrors", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getRetriesOnOtherErrors());
        this.metricsRegistry.register("Ignores", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getIgnores());
        this.metricsRegistry.register("IgnoresOnReadTimeout", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getIgnoresOnReadTimeout());
        this.metricsRegistry.register("IgnoresOnWriteTimeout", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getIgnoresOnWriteTimeout());
        this.metricsRegistry.register("IgnoresOnUnavailable", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getIgnoresOnUnavailable());
        this.metricsRegistry.register("IgnoresOnClientTimeout", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getIgnoresOnClientTimeout());
        this.metricsRegistry.register("IgnoresOnConnectionErrors", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getIgnoresOnConnectionError());
        this.metricsRegistry.register("IgnoresOnOtherErrors", SCOPE, ERROR_TYPE, driverMetrics.getErrorMetrics().getIgnoresOnOtherErrors());
    }

    private void registerLoadMetrics(Metrics driverMetrics) {
        this.metricsRegistry.register("Requests", SCOPE, LOAD_TYPE, driverMetrics.getRequestsTimer());
        this.metricsRegistry.register("KnownHosts", SCOPE, LOAD_TYPE, driverMetrics.getKnownHosts());
        this.metricsRegistry.register("ConnectedToHosts", SCOPE, LOAD_TYPE, driverMetrics.getConnectedToHosts());
        this.metricsRegistry.register("OpenConnections", SCOPE, LOAD_TYPE, driverMetrics.getOpenConnections());
        this.metricsRegistry.register("TrashedConnections", SCOPE, LOAD_TYPE, driverMetrics.getTrashedConnections());
        this.metricsRegistry.register("ExecutorQueueDepth", SCOPE, LOAD_TYPE, driverMetrics.getExecutorQueueDepth());
        this.metricsRegistry.register("BlockingExecutorQueueDepth", SCOPE, LOAD_TYPE, driverMetrics.getBlockingExecutorQueueDepth());
        this.metricsRegistry.register("ReconnectionSchedulerQueueSize", SCOPE, LOAD_TYPE, driverMetrics.getReconnectionSchedulerQueueSize());
        this.metricsRegistry.register("TaskSchedulerQueueSize", SCOPE, LOAD_TYPE, driverMetrics.getTaskSchedulerQueueSize());
    }

    private void registerPerHostMetrics() {
        this.session.getCluster().getMetadata().getAllHosts().forEach(this::registerPerHostMetrics);
        this.session.getCluster().register(new Host.StateListener(){

            @Override
            public void onAdd(Host host) {
                CassandraDriverMetrics.this.registerPerHostMetrics(host);
            }

            @Override
            public void onUp(Host host) {
            }

            @Override
            public void onDown(Host host) {
            }

            @Override
            public void onRemove(Host host) {
                String hostname = CassandraDriverMetrics.this.getHostKey(host);
                CassandraDriverMetrics.this.metricsRegistry.removeMatching((name, metric) -> name.startsWith(hostname));
            }

            @Override
            public void onRegister(Cluster cluster) {
            }

            @Override
            public void onUnregister(Cluster cluster) {
            }
        });
    }

    private void registerPerHostMetrics(Host host) {
        String hostname = this.getHostKey(host);
        this.metricsRegistry.register("OpenConnections_" + hostname, SCOPE, LOAD_TYPE, this.createOpenConnections(hostname));
        this.metricsRegistry.register("Load_" + hostname, SCOPE, LOAD_TYPE, this.createLoad(hostname));
        this.metricsRegistry.register("MaxLoad_" + hostname, SCOPE, LOAD_TYPE, this.createMaxLoad(hostname));
    }

    private String getHostKey(Host host) {
        return host.getSocketAddress().getHostString() + ":" + host.getSocketAddress().getPort();
    }

    private Optional<Host> getHost(Session.State state, String hostname) {
        return state.getConnectedHosts().stream().filter(h -> this.getHostKey((Host)h).equals(hostname)).findFirst();
    }

    private Gauge<Integer> createOpenConnections(String hostname) {
        return () -> {
            Session.State state = this.session.getState();
            return this.getHost(state, hostname).map(state::getOpenConnections).orElse(0);
        };
    }

    private Gauge<Integer> createLoad(String hostname) {
        return () -> {
            Session.State state = this.session.getState();
            return this.getHost(state, hostname).map(state::getInFlightQueries).orElse(0);
        };
    }

    private Gauge<Integer> createMaxLoad(String hostname) {
        return () -> {
            Session.State state = this.session.getState();
            return this.getHost(state, hostname).map(host -> {
                Configuration configuration = this.session.getCluster().getConfiguration();
                PoolingOptions poolingOptions = configuration.getPoolingOptions();
                HostDistance distance = configuration.getPolicies().getLoadBalancingPolicy().distance((Host)host);
                int connections = state.getOpenConnections((Host)host);
                return connections * poolingOptions.getMaxRequestsPerConnection(distance);
            }).orElse(0);
        };
    }
}

