/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.transformers;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.apache.commons.math3.stat.descriptive.moment.Mean;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.apache.commons.math3.stat.descriptive.rank.PSquarePercentile;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.hawkular.metrics.core.service.PercentileWrapper;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.NumericBucketPoint;
import org.hawkular.metrics.model.Percentile;

public final class NumericDataPointCollector {
    public static Function<Double, PercentileWrapper> createPercentile = p -> new PercentileWrapper((Double)p){
        PSquarePercentile percentile;
        final /* synthetic */ Double val$p;
        {
            this.val$p = d;
            this.percentile = new PSquarePercentile(this.val$p);
        }

        @Override
        public synchronized void addValue(double value) {
            this.percentile.increment(value);
        }

        @Override
        public synchronized double getResult() {
            return this.percentile.getResult();
        }
    };
    private final Buckets buckets;
    private final int bucketIndex;
    private int samples = 0;
    private Min min = new Min();
    private Mean average = new Mean();
    private Max max = new Max();
    private Sum sum = new Sum();
    private List<PercentileWrapper> percentiles;
    private List<Percentile> percentileList;

    public NumericDataPointCollector(Buckets buckets, int bucketIndex, List<Percentile> percentilesList) {
        this.buckets = buckets;
        this.bucketIndex = bucketIndex;
        this.percentiles = new ArrayList<PercentileWrapper>(percentilesList.size() + 1);
        this.percentileList = percentilesList;
        percentilesList.stream().forEach(d -> this.percentiles.add(createPercentile.apply(d.getQuantile())));
        this.percentiles.add(createPercentile.apply(50.0));
    }

    public void increment(DataPoint<? extends Number> dataPoint) {
        Number value = dataPoint.getValue();
        this.min.increment(value.doubleValue());
        this.average.increment(value.doubleValue());
        this.max.increment(value.doubleValue());
        this.sum.increment(value.doubleValue());
        ++this.samples;
        this.percentiles.stream().forEach(p -> p.addValue(value.doubleValue()));
    }

    public NumericBucketPoint toBucketPoint() {
        long from = this.buckets.getBucketStart(this.bucketIndex);
        long to = from + this.buckets.getStep();
        ArrayList<Percentile> percentileReturns = new ArrayList<Percentile>(this.percentileList.size());
        if (this.percentileList.size() > 0) {
            for (int i = 0; i < this.percentileList.size(); ++i) {
                Percentile p = this.percentileList.get(i);
                PercentileWrapper pw = this.percentiles.get(i);
                percentileReturns.add(new Percentile(p.getOriginalQuantile(), pw.getResult()));
            }
        }
        return new NumericBucketPoint.Builder(from, to).setMin(this.min.getResult()).setAvg(this.average.getResult()).setMedian(this.percentiles.get(this.percentiles.size() - 1).getResult()).setMax(this.max.getResult()).setSum(this.sum.getResult()).setSamples(this.samples).setPercentiles(percentileReturns).build();
    }
}

