/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.HostDistance;
import com.datastax.driver.core.ProtocolVersion;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.Executor;

public class PoolingOptions {
    public static final int UNSET = Integer.MIN_VALUE;
    public static final String CORE_POOL_LOCAL_KEY = "corePoolLocal";
    public static final String MAX_POOL_LOCAL_KEY = "maxPoolLocal";
    public static final String CORE_POOL_REMOTE_KEY = "corePoolRemote";
    public static final String MAX_POOL_REMOTE_KEY = "maxPoolRemote";
    public static final String NEW_CONNECTION_THRESHOLD_LOCAL_KEY = "newConnectionThresholdLocal";
    public static final String NEW_CONNECTION_THRESHOLD_REMOTE_KEY = "newConnectionThresholdRemote";
    public static final String MAX_REQUESTS_PER_CONNECTION_LOCAL_KEY = "maxRequestsPerConnectionLocal";
    public static final String MAX_REQUESTS_PER_CONNECTION_REMOTE_KEY = "maxRequestsPerConnectionRemote";
    public static final Map<ProtocolVersion, Map<String, Integer>> DEFAULTS = ImmutableMap.of(ProtocolVersion.V1, ImmutableMap.builder().put("corePoolLocal", 2).put("maxPoolLocal", 8).put("corePoolRemote", 1).put("maxPoolRemote", 2).put("newConnectionThresholdLocal", 100).put("newConnectionThresholdRemote", 100).put("maxRequestsPerConnectionLocal", 128).put("maxRequestsPerConnectionRemote", 128).build(), ProtocolVersion.V3, ImmutableMap.builder().put("corePoolLocal", 1).put("maxPoolLocal", 1).put("corePoolRemote", 1).put("maxPoolRemote", 1).put("newConnectionThresholdLocal", 800).put("newConnectionThresholdRemote", 200).put("maxRequestsPerConnectionLocal", 1024).put("maxRequestsPerConnectionRemote", 256).build());
    public static final int DEFAULT_IDLE_TIMEOUT_SECONDS = 120;
    @Deprecated
    public static final int DEFAULT_POOL_TIMEOUT_MILLIS = 5000;
    public static final int DEFAULT_MAX_QUEUE_SIZE = 256;
    public static final int DEFAULT_HEARTBEAT_INTERVAL_SECONDS = 30;
    private static final Executor DEFAULT_INITIALIZATION_EXECUTOR = MoreExecutors.sameThreadExecutor();
    private volatile Cluster.Manager manager;
    private volatile ProtocolVersion protocolVersion;
    private final int[] coreConnections = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, 0};
    private final int[] maxConnections = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, 0};
    private final int[] newConnectionThreshold = new int[]{Integer.MIN_VALUE, Integer.MIN_VALUE, 0};
    private volatile int maxRequestsPerConnectionLocal = Integer.MIN_VALUE;
    private volatile int maxRequestsPerConnectionRemote = Integer.MIN_VALUE;
    private volatile int idleTimeoutSeconds = 120;
    private volatile int maxQueueSize = 256;
    private volatile int heartbeatIntervalSeconds = 30;
    private volatile Executor initializationExecutor = DEFAULT_INITIALIZATION_EXECUTOR;

    void register(Cluster.Manager manager) {
        this.manager = manager;
    }

    public int getCoreConnectionsPerHost(HostDistance distance) {
        return this.coreConnections[distance.ordinal()];
    }

    public synchronized PoolingOptions setCoreConnectionsPerHost(HostDistance distance, int newCoreConnections) {
        if (distance == HostDistance.IGNORED) {
            throw new IllegalArgumentException("Cannot set core connections per host for " + (Object)((Object)distance) + " hosts");
        }
        Preconditions.checkArgument(newCoreConnections >= 0, "core number of connections must be positive");
        if (this.maxConnections[distance.ordinal()] != Integer.MIN_VALUE) {
            PoolingOptions.checkConnectionsPerHostOrder(newCoreConnections, this.maxConnections[distance.ordinal()], distance);
        }
        int oldCore = this.coreConnections[distance.ordinal()];
        this.coreConnections[distance.ordinal()] = newCoreConnections;
        if (oldCore < newCoreConnections && this.manager != null) {
            this.manager.ensurePoolsSizing();
        }
        return this;
    }

    public int getMaxConnectionsPerHost(HostDistance distance) {
        return this.maxConnections[distance.ordinal()];
    }

    public synchronized PoolingOptions setMaxConnectionsPerHost(HostDistance distance, int newMaxConnections) {
        if (distance == HostDistance.IGNORED) {
            throw new IllegalArgumentException("Cannot set max connections per host for " + (Object)((Object)distance) + " hosts");
        }
        Preconditions.checkArgument(newMaxConnections >= 0, "max number of connections must be positive");
        if (this.coreConnections[distance.ordinal()] != Integer.MIN_VALUE) {
            PoolingOptions.checkConnectionsPerHostOrder(this.coreConnections[distance.ordinal()], newMaxConnections, distance);
        }
        this.maxConnections[distance.ordinal()] = newMaxConnections;
        return this;
    }

    public synchronized PoolingOptions setConnectionsPerHost(HostDistance distance, int core, int max) {
        if (distance == HostDistance.IGNORED) {
            throw new IllegalArgumentException("Cannot set connections per host for " + (Object)((Object)distance) + " hosts");
        }
        Preconditions.checkArgument(core >= 0, "core number of connections must be positive");
        Preconditions.checkArgument(max >= 0, "max number of connections must be positive");
        PoolingOptions.checkConnectionsPerHostOrder(core, max, distance);
        this.coreConnections[distance.ordinal()] = core;
        this.maxConnections[distance.ordinal()] = max;
        return this;
    }

    public int getNewConnectionThreshold(HostDistance distance) {
        return this.newConnectionThreshold[distance.ordinal()];
    }

    public synchronized PoolingOptions setNewConnectionThreshold(HostDistance distance, int newValue) {
        if (distance == HostDistance.IGNORED) {
            throw new IllegalArgumentException("Cannot set new connection threshold for " + (Object)((Object)distance) + " hosts");
        }
        this.checkRequestsPerConnectionRange(newValue, "New connection threshold", distance);
        this.newConnectionThreshold[distance.ordinal()] = newValue;
        return this;
    }

    public int getMaxRequestsPerConnection(HostDistance distance) {
        switch (distance) {
            case LOCAL: {
                return this.maxRequestsPerConnectionLocal;
            }
            case REMOTE: {
                return this.maxRequestsPerConnectionRemote;
            }
        }
        return 0;
    }

    public PoolingOptions setMaxRequestsPerConnection(HostDistance distance, int newMaxRequests) {
        this.checkRequestsPerConnectionRange(newMaxRequests, "Max requests per connection", distance);
        switch (distance) {
            case LOCAL: {
                this.maxRequestsPerConnectionLocal = newMaxRequests;
                break;
            }
            case REMOTE: {
                this.maxRequestsPerConnectionRemote = newMaxRequests;
                break;
            }
            default: {
                throw new IllegalArgumentException("Cannot set max requests per host for " + (Object)((Object)distance) + " hosts");
            }
        }
        return this;
    }

    public int getIdleTimeoutSeconds() {
        return this.idleTimeoutSeconds;
    }

    public PoolingOptions setIdleTimeoutSeconds(int idleTimeoutSeconds) {
        if (idleTimeoutSeconds < 0) {
            throw new IllegalArgumentException("Idle timeout must be positive");
        }
        this.idleTimeoutSeconds = idleTimeoutSeconds;
        return this;
    }

    @Deprecated
    public int getPoolTimeoutMillis() {
        return 0;
    }

    @Deprecated
    public PoolingOptions setPoolTimeoutMillis(int poolTimeoutMillis) {
        return this;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public PoolingOptions setMaxQueueSize(int maxQueueSize) {
        if (maxQueueSize < 0) {
            throw new IllegalArgumentException("Max queue size must be positive");
        }
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    public int getHeartbeatIntervalSeconds() {
        return this.heartbeatIntervalSeconds;
    }

    public PoolingOptions setHeartbeatIntervalSeconds(int heartbeatIntervalSeconds) {
        if (heartbeatIntervalSeconds < 0) {
            throw new IllegalArgumentException("Heartbeat interval must be positive");
        }
        this.heartbeatIntervalSeconds = heartbeatIntervalSeconds;
        return this;
    }

    public Executor getInitializationExecutor() {
        return this.initializationExecutor;
    }

    public PoolingOptions setInitializationExecutor(Executor initializationExecutor) {
        Preconditions.checkNotNull(initializationExecutor);
        this.initializationExecutor = initializationExecutor;
        return this;
    }

    synchronized void setProtocolVersion(ProtocolVersion actualVersion) {
        this.protocolVersion = actualVersion;
        ProtocolVersion referenceVersion = null;
        for (ProtocolVersion key : DEFAULTS.keySet()) {
            if (key.compareTo(actualVersion) > 0) break;
            referenceVersion = key;
        }
        assert (referenceVersion != null);
        Map<String, Integer> defaults = DEFAULTS.get((Object)referenceVersion);
        if (this.coreConnections[HostDistance.LOCAL.ordinal()] == Integer.MIN_VALUE) {
            this.coreConnections[HostDistance.LOCAL.ordinal()] = defaults.get(CORE_POOL_LOCAL_KEY);
        }
        if (this.maxConnections[HostDistance.LOCAL.ordinal()] == Integer.MIN_VALUE) {
            this.maxConnections[HostDistance.LOCAL.ordinal()] = defaults.get(MAX_POOL_LOCAL_KEY);
        }
        PoolingOptions.checkConnectionsPerHostOrder(this.coreConnections[HostDistance.LOCAL.ordinal()], this.maxConnections[HostDistance.LOCAL.ordinal()], HostDistance.LOCAL);
        if (this.coreConnections[HostDistance.REMOTE.ordinal()] == Integer.MIN_VALUE) {
            this.coreConnections[HostDistance.REMOTE.ordinal()] = defaults.get(CORE_POOL_REMOTE_KEY);
        }
        if (this.maxConnections[HostDistance.REMOTE.ordinal()] == Integer.MIN_VALUE) {
            this.maxConnections[HostDistance.REMOTE.ordinal()] = defaults.get(MAX_POOL_REMOTE_KEY);
        }
        PoolingOptions.checkConnectionsPerHostOrder(this.coreConnections[HostDistance.REMOTE.ordinal()], this.maxConnections[HostDistance.REMOTE.ordinal()], HostDistance.REMOTE);
        if (this.newConnectionThreshold[HostDistance.LOCAL.ordinal()] == Integer.MIN_VALUE) {
            this.newConnectionThreshold[HostDistance.LOCAL.ordinal()] = defaults.get(NEW_CONNECTION_THRESHOLD_LOCAL_KEY);
        }
        this.checkRequestsPerConnectionRange(this.newConnectionThreshold[HostDistance.LOCAL.ordinal()], "New connection threshold", HostDistance.LOCAL);
        if (this.newConnectionThreshold[HostDistance.REMOTE.ordinal()] == Integer.MIN_VALUE) {
            this.newConnectionThreshold[HostDistance.REMOTE.ordinal()] = defaults.get(NEW_CONNECTION_THRESHOLD_REMOTE_KEY);
        }
        this.checkRequestsPerConnectionRange(this.newConnectionThreshold[HostDistance.REMOTE.ordinal()], "New connection threshold", HostDistance.REMOTE);
        if (this.maxRequestsPerConnectionLocal == Integer.MIN_VALUE) {
            this.maxRequestsPerConnectionLocal = defaults.get(MAX_REQUESTS_PER_CONNECTION_LOCAL_KEY);
        }
        this.checkRequestsPerConnectionRange(this.maxRequestsPerConnectionLocal, "Max requests per connection", HostDistance.LOCAL);
        if (this.maxRequestsPerConnectionRemote == Integer.MIN_VALUE) {
            this.maxRequestsPerConnectionRemote = defaults.get(MAX_REQUESTS_PER_CONNECTION_REMOTE_KEY);
        }
        this.checkRequestsPerConnectionRange(this.maxRequestsPerConnectionRemote, "Max requests per connection", HostDistance.REMOTE);
    }

    public void refreshConnectedHosts() {
        this.manager.refreshConnectedHosts();
    }

    public void refreshConnectedHost(Host host) {
        this.manager.refreshConnectedHost(host);
    }

    private void checkRequestsPerConnectionRange(int value, String description, HostDistance distance) {
        int max;
        int n = max = this.protocolVersion == null || this.protocolVersion.compareTo(ProtocolVersion.V3) >= 0 ? 32768 : 128;
        if (value < 0 || value > max) {
            throw new IllegalArgumentException(String.format("%s for %s hosts must be in the range (0, %d)", new Object[]{description, distance, max}));
        }
    }

    private static void checkConnectionsPerHostOrder(int core, int max, HostDistance distance) {
        if (core > max) {
            throw new IllegalArgumentException(String.format("Core connections for %s hosts must be less than max (%d > %d)", new Object[]{distance, core, max}));
        }
    }
}

