/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.core.exceptions;

import com.datastax.driver.core.exceptions.CoordinatorException;
import com.datastax.driver.core.exceptions.DriverException;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class BusyPoolException
extends DriverException
implements CoordinatorException {
    private static final long serialVersionUID = 0L;
    private final InetSocketAddress address;
    private final int queueSize;

    public BusyPoolException(InetSocketAddress address, int queueSize) {
        this(address, queueSize, null);
    }

    private BusyPoolException(InetSocketAddress address, int queueSize, Throwable cause) {
        super(BusyPoolException.buildMessage(address, queueSize), cause);
        this.address = address;
        this.queueSize = queueSize;
    }

    private static String buildMessage(InetSocketAddress address, int queueSize) {
        return String.format("[%s] Pool is busy (no available connection and the queue has reached its max size %d)", address.getAddress(), queueSize);
    }

    @Override
    public InetAddress getHost() {
        return this.address.getAddress();
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.address;
    }

    @Override
    public BusyPoolException copy() {
        return new BusyPoolException(this.address, this.queueSize, this);
    }
}

