/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.yak.ts.compression.gorilla;

import fi.iki.yak.ts.compression.gorilla.BitOutput;
import java.nio.ByteBuffer;

public class ByteBufferBitOutput
implements BitOutput {
    public static final int DEFAULT_ALLOCATION = 4096;
    private ByteBuffer bb;
    private byte b;
    private int bitsLeft = 8;

    public ByteBufferBitOutput() {
        this(4096);
    }

    public ByteBufferBitOutput(int initialSize) {
        this.bb = ByteBuffer.allocateDirect(initialSize);
        this.b = this.bb.get(this.bb.position());
    }

    private void expandAllocation() {
        ByteBuffer largerBB = ByteBuffer.allocateDirect(this.bb.capacity() * 2);
        this.bb.flip();
        largerBB.put(this.bb);
        largerBB.position(this.bb.capacity());
        this.bb = largerBB;
    }

    private void flipByte() {
        if (this.bitsLeft == 0) {
            this.bb.put(this.b);
            if (!this.bb.hasRemaining()) {
                this.expandAllocation();
            }
            this.b = this.bb.get(this.bb.position());
            this.bitsLeft = 8;
        }
    }

    @Override
    public void writeBit(boolean bit) {
        if (bit) {
            this.b = (byte)(this.b | 1 << this.bitsLeft - 1);
        }
        --this.bitsLeft;
        this.flipByte();
    }

    @Override
    public void writeBits(long value, int bits) {
        while (bits > 0) {
            int shift = bits - this.bitsLeft;
            if (shift >= 0) {
                this.b = (byte)(this.b | (byte)(value >> shift & (long)((1 << this.bitsLeft) - 1)));
            } else {
                int shiftAmount = Math.abs(shift);
                this.b = (byte)(this.b | (byte)(value << shiftAmount));
            }
            if (bits > this.bitsLeft) {
                bits -= this.bitsLeft;
                this.bitsLeft = 0;
            } else {
                this.bitsLeft -= bits;
                bits = 0;
            }
            this.flipByte();
        }
    }

    @Override
    public void flush() {
        this.bitsLeft = 0;
        this.flipByte();
    }

    public ByteBuffer getByteBuffer() {
        return this.bb;
    }
}

