/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.RoleOptions;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.RoleName;
import org.apache.cassandra.cql3.statements.AuthenticationStatement;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.messages.ResultMessage;

public class CreateRoleStatement
extends AuthenticationStatement {
    private final RoleResource role;
    private final RoleOptions opts;
    private final boolean ifNotExists;

    public CreateRoleStatement(RoleName name, RoleOptions options, boolean ifNotExists) {
        this.role = RoleResource.role(name.getName());
        this.opts = options;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException {
        super.checkPermission(state, Permission.CREATE, RoleResource.root());
        if (this.opts.getSuperuser().isPresent() && this.opts.getSuperuser().get().booleanValue() && !state.getUser().isSuper()) {
            throw new UnauthorizedException("Only superusers can create a role with superuser status");
        }
    }

    @Override
    public void validate(ClientState state) throws RequestValidationException {
        this.opts.validate();
        if (this.role.getRoleName().isEmpty()) {
            throw new InvalidRequestException("Role name can't be an empty string");
        }
        state.ensureNotAnonymous();
        if (!this.ifNotExists && DatabaseDescriptor.getRoleManager().isExistingRole(this.role)) {
            throw new InvalidRequestException(String.format("%s already exists", this.role.getRoleName()));
        }
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestExecutionException, RequestValidationException {
        if (this.ifNotExists && DatabaseDescriptor.getRoleManager().isExistingRole(this.role)) {
            return null;
        }
        DatabaseDescriptor.getRoleManager().createRole(state.getUser(), this.role, this.opts);
        this.grantPermissionsToCreator(state);
        return null;
    }

    private void grantPermissionsToCreator(ClientState state) {
        if (!state.getUser().isAnonymous()) {
            try {
                DatabaseDescriptor.getAuthorizer().grant(AuthenticatedUser.SYSTEM_USER, this.role.applicablePermissions(), this.role, RoleResource.role(state.getUser().getName()));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }
}

