/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.IndexName;
import org.apache.cassandra.cql3.QueryOptions;
import org.apache.cassandra.cql3.statements.SchemaAlteringStatement;
import org.apache.cassandra.db.KeyspaceNotDefinedException;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.MigrationManager;
import org.apache.cassandra.service.QueryState;
import org.apache.cassandra.transport.Event;
import org.apache.cassandra.transport.messages.ResultMessage;

public class DropIndexStatement
extends SchemaAlteringStatement {
    public final String indexName;
    public final boolean ifExists;

    public DropIndexStatement(IndexName indexName, boolean ifExists) {
        super(indexName.getCfName());
        this.indexName = indexName.getIdx();
        this.ifExists = ifExists;
    }

    @Override
    public String columnFamily() {
        CFMetaData cfm = this.lookupIndexedTable();
        return cfm == null ? null : cfm.cfName;
    }

    @Override
    public void checkAccess(ClientState state) throws UnauthorizedException, InvalidRequestException {
        CFMetaData cfm = this.lookupIndexedTable();
        if (cfm == null) {
            return;
        }
        state.hasColumnFamilyAccess(cfm.ksName, cfm.cfName, Permission.ALTER);
    }

    @Override
    public void validate(ClientState state) {
    }

    @Override
    public ResultMessage execute(QueryState state, QueryOptions options) throws RequestValidationException {
        Event.SchemaChange ce = this.announceMigration(false);
        return ce == null ? null : new ResultMessage.SchemaChange(ce);
    }

    @Override
    public Event.SchemaChange announceMigration(boolean isLocalOnly) throws InvalidRequestException, ConfigurationException {
        CFMetaData cfm = this.lookupIndexedTable();
        if (cfm == null) {
            return null;
        }
        CFMetaData updatedCfm = cfm.copy();
        updatedCfm.indexes(updatedCfm.getIndexes().without(this.indexName));
        MigrationManager.announceColumnFamilyUpdate(updatedCfm, isLocalOnly);
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, cfm.ksName, cfm.cfName);
    }

    private CFMetaData lookupIndexedTable() {
        KeyspaceMetadata ksm = Schema.instance.getKSMetaData(this.keyspace());
        if (ksm == null) {
            throw new KeyspaceNotDefinedException("Keyspace " + this.keyspace() + " does not exist");
        }
        return ksm.findIndexedTable(this.indexName).orElseGet(() -> {
            if (this.ifExists) {
                return null;
            }
            throw new InvalidRequestException(String.format("Index '%s' could not be found in any of the tables of keyspace '%s'", this.indexName, this.keyspace()));
        });
    }
}

