/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.cassandra.auth.IRoleManager;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.RoleResource;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.ColumnSpecification;
import org.apache.cassandra.cql3.ResultSet;
import org.apache.cassandra.cql3.RoleName;
import org.apache.cassandra.cql3.statements.AuthorizationStatement;
import org.apache.cassandra.db.marshal.BooleanType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.messages.ResultMessage;

public class ListRolesStatement
extends AuthorizationStatement {
    private static final String KS = "system_auth";
    private static final String CF = "roles";
    private static final MapType optionsType = MapType.getInstance(UTF8Type.instance, UTF8Type.instance, false);
    private static final List<ColumnSpecification> metadata = ImmutableList.of(new ColumnSpecification("system_auth", "roles", new ColumnIdentifier("role", true), UTF8Type.instance), new ColumnSpecification("system_auth", "roles", new ColumnIdentifier("super", true), BooleanType.instance), new ColumnSpecification("system_auth", "roles", new ColumnIdentifier("login", true), BooleanType.instance), new ColumnSpecification("system_auth", "roles", new ColumnIdentifier("options", true), optionsType));
    private final RoleResource grantee;
    private final boolean recursive;

    public ListRolesStatement() {
        this(new RoleName(), false);
    }

    public ListRolesStatement(RoleName grantee, boolean recursive) {
        this.grantee = grantee.hasName() ? RoleResource.role(grantee.getName()) : null;
        this.recursive = recursive;
    }

    @Override
    public void validate(ClientState state) throws UnauthorizedException, InvalidRequestException {
        state.ensureNotAnonymous();
        if (this.grantee != null && !DatabaseDescriptor.getRoleManager().isExistingRole(this.grantee)) {
            throw new InvalidRequestException(String.format("%s doesn't exist", this.grantee));
        }
    }

    @Override
    public void checkAccess(ClientState state) throws InvalidRequestException {
    }

    @Override
    public ResultMessage execute(ClientState state) throws RequestValidationException, RequestExecutionException {
        boolean hasRootLevelSelect = DatabaseDescriptor.getAuthorizer().authorize(state.getUser(), RoleResource.root()).contains((Object)Permission.DESCRIBE);
        if (hasRootLevelSelect) {
            if (this.grantee == null) {
                return this.resultMessage(DatabaseDescriptor.getRoleManager().getAllRoles());
            }
            return this.resultMessage(DatabaseDescriptor.getRoleManager().getRoles(this.grantee, this.recursive));
        }
        RoleResource currentUser = RoleResource.role(state.getUser().getName());
        if (this.grantee == null) {
            return this.resultMessage(DatabaseDescriptor.getRoleManager().getRoles(currentUser, this.recursive));
        }
        if (DatabaseDescriptor.getRoleManager().getRoles(currentUser, true).contains(this.grantee)) {
            return this.resultMessage(DatabaseDescriptor.getRoleManager().getRoles(this.grantee, this.recursive));
        }
        throw new UnauthorizedException(String.format("You are not authorized to view roles granted to %s ", this.grantee.getRoleName()));
    }

    private ResultMessage resultMessage(Set<RoleResource> roles) {
        if (roles.isEmpty()) {
            return new ResultMessage.Void();
        }
        ArrayList<RoleResource> sorted = Lists.newArrayList(roles);
        Collections.sort(sorted);
        return this.formatResults(sorted);
    }

    protected ResultMessage formatResults(List<RoleResource> sortedRoles) {
        ResultSet result = new ResultSet(metadata);
        IRoleManager roleManager = DatabaseDescriptor.getRoleManager();
        for (RoleResource role : sortedRoles) {
            result.addColumnValue(UTF8Type.instance.decompose(role.getRoleName()));
            result.addColumnValue(BooleanType.instance.decompose(roleManager.isSuper(role)));
            result.addColumnValue(BooleanType.instance.decompose(roleManager.canLogin(role)));
            result.addColumnValue(optionsType.decompose(roleManager.getCustomOptions(role)));
        }
        return new ResultMessage.Rows(result);
    }
}

