/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import com.google.common.base.Throwables;
import java.io.File;
import java.io.IOException;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.io.sstable.AbstractSSTableSimpleWriter;
import org.apache.cassandra.io.sstable.SSTableTxnWriter;

class SSTableSimpleWriter
extends AbstractSSTableSimpleWriter {
    protected DecoratedKey currentKey;
    protected PartitionUpdate update;
    private SSTableTxnWriter writer;

    protected SSTableSimpleWriter(File directory, CFMetaData metadata, PartitionColumns columns) {
        super(directory, metadata, columns);
    }

    private SSTableTxnWriter getOrCreateWriter() {
        if (this.writer == null) {
            this.writer = this.createWriter();
        }
        return this.writer;
    }

    @Override
    PartitionUpdate getUpdateFor(DecoratedKey key) throws IOException {
        assert (key != null);
        if (!key.equals(this.currentKey)) {
            if (this.update != null) {
                this.writePartition(this.update);
            }
            this.currentKey = key;
            this.update = new PartitionUpdate(this.metadata, this.currentKey, this.columns, 4);
        }
        assert (this.update != null);
        return this.update;
    }

    @Override
    public void close() {
        try {
            if (this.update != null) {
                this.writePartition(this.update);
            }
            if (this.writer != null) {
                this.writer.finish(false);
            }
        }
        catch (Throwable t) {
            throw Throwables.propagate(this.writer == null ? t : this.writer.abort(t));
        }
    }

    private void writePartition(PartitionUpdate update) throws IOException {
        this.getOrCreateWriter().append(update.unfilteredIterator());
    }
}

