/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.cql3.functions.FunctionName;
import org.apache.cassandra.cql3.functions.UDAggregate;
import org.apache.cassandra.cql3.functions.UDFunction;
import org.apache.cassandra.db.marshal.AbstractType;

public final class Functions
implements Iterable<Function> {
    private final ImmutableMultimap<FunctionName, Function> functions;

    private Functions(Builder builder) {
        this.functions = builder.functions.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Functions none() {
        return Functions.builder().build();
    }

    public static Functions of(Function ... funs) {
        return Functions.builder().add(funs).build();
    }

    @Override
    public Iterator<Function> iterator() {
        return ((ImmutableCollection)this.functions.values()).iterator();
    }

    public Stream<Function> stream() {
        return this.functions.values().stream();
    }

    public Stream<UDFunction> udfs() {
        return this.stream().filter(f -> f instanceof UDFunction).map(f -> (UDFunction)f);
    }

    public Stream<UDAggregate> udas() {
        return this.stream().filter(f -> f instanceof UDAggregate).map(f -> (UDAggregate)f);
    }

    public Collection<UDAggregate> aggregatesUsingFunction(Function function) {
        return this.udas().filter(uda -> uda.hasReferenceTo(function)).collect(Collectors.toList());
    }

    public Collection<Function> get(FunctionName name) {
        return this.functions.get((Object)name);
    }

    public Optional<Function> find(FunctionName name, List<AbstractType<?>> argTypes) {
        return this.get(name).stream().filter(fun -> Functions.typesMatch(fun.argTypes(), argTypes)).findAny();
    }

    public static boolean typesMatch(AbstractType<?> t1, AbstractType<?> t2) {
        return t1.asCQL3Type().toString().equals(t2.asCQL3Type().toString());
    }

    public static boolean typesMatch(List<AbstractType<?>> t1, List<AbstractType<?>> t2) {
        if (t1.size() != t2.size()) {
            return false;
        }
        for (int i = 0; i < t1.size(); ++i) {
            if (Functions.typesMatch(t1.get(i), t2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static int typeHashCode(AbstractType<?> t) {
        return t.asCQL3Type().toString().hashCode();
    }

    public static int typeHashCode(List<AbstractType<?>> types) {
        int h = 0;
        for (AbstractType<?> type : types) {
            h = h * 31 + Functions.typeHashCode(type);
        }
        return h;
    }

    public Functions with(Function fun) {
        if (this.find(fun.name(), fun.argTypes()).isPresent()) {
            throw new IllegalStateException(String.format("Function %s already exists", fun.name()));
        }
        return Functions.builder().add(this).add(fun).build();
    }

    public Functions without(FunctionName name, List<AbstractType<?>> argTypes) {
        Function fun = this.find(name, argTypes).orElseThrow(() -> new IllegalStateException(String.format("Function %s doesn't exists", name)));
        return Functions.builder().add(Iterables.filter(this, f -> f != fun)).build();
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Functions && this.functions.equals(((Functions)o).functions);
    }

    public int hashCode() {
        return this.functions.hashCode();
    }

    public String toString() {
        return ((AbstractCollection)this.functions.values()).toString();
    }

    public static final class Builder {
        final ImmutableMultimap.Builder<FunctionName, Function> functions = new ImmutableMultimap.Builder();

        private Builder() {
            this.functions.orderValuesBy((f1, f2) -> Integer.compare(f1.hashCode(), f2.hashCode()));
        }

        public Functions build() {
            return new Functions(this);
        }

        public Builder add(Function fun) {
            this.functions.put(fun.name(), fun);
            return this;
        }

        public Builder add(Function ... funs) {
            for (Function fun : funs) {
                this.add(fun);
            }
            return this;
        }

        public Builder add(Iterable<? extends Function> funs) {
            funs.forEach(this::add);
            return this;
        }
    }
}

