/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.Striped;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.service.paxos.Commit;
import org.apache.cassandra.service.paxos.PrepareResponse;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.UUIDGen;

public class PaxosState {
    private static final Striped<Lock> LOCKS = Striped.lazyWeakLock(DatabaseDescriptor.getConcurrentWriters() * 1024);
    private final Commit promised;
    private final Commit accepted;
    private final Commit mostRecentCommit;

    public PaxosState(DecoratedKey key, CFMetaData metadata) {
        this(Commit.emptyCommit(key, metadata), Commit.emptyCommit(key, metadata), Commit.emptyCommit(key, metadata));
    }

    public PaxosState(Commit promised, Commit accepted, Commit mostRecentCommit) {
        assert (promised.update.partitionKey().equals(accepted.update.partitionKey()) && accepted.update.partitionKey().equals(mostRecentCommit.update.partitionKey()));
        assert (promised.update.metadata() == accepted.update.metadata() && accepted.update.metadata() == mostRecentCommit.update.metadata());
        this.promised = promised;
        this.accepted = accepted;
        this.mostRecentCommit = mostRecentCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PrepareResponse prepare(Commit toPrepare) {
        long start = System.nanoTime();
        try {
            PaxosState state;
            Lock lock;
            block8: {
                lock = LOCKS.get(toPrepare.update.partitionKey());
                lock.lock();
                try {
                    int nowInSec = UUIDGen.unixTimestampInSec(toPrepare.ballot);
                    state = SystemKeyspace.loadPaxosState(toPrepare.update.partitionKey(), toPrepare.update.metadata(), nowInSec);
                    if (!toPrepare.isAfter(state.promised)) break block8;
                    Tracing.trace("Promising ballot {}", (Object)toPrepare.ballot);
                    SystemKeyspace.savePaxosPromise(toPrepare);
                    PrepareResponse prepareResponse = new PrepareResponse(true, state.accepted, state.mostRecentCommit);
                    lock.unlock();
                    return prepareResponse;
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
            }
            Tracing.trace("Promise rejected; {} is not sufficiently newer than {}", (Object)toPrepare, (Object)state.promised);
            PrepareResponse prepareResponse = new PrepareResponse(false, state.promised, state.mostRecentCommit);
            lock.unlock();
            return prepareResponse;
        }
        finally {
            Keyspace.open((String)toPrepare.update.metadata().ksName).getColumnFamilyStore((UUID)toPrepare.update.metadata().cfId).metric.casPrepare.addNano(System.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean propose(Commit proposal) {
        long start = System.nanoTime();
        try {
            PaxosState state;
            Lock lock;
            block8: {
                lock = LOCKS.get(proposal.update.partitionKey());
                lock.lock();
                try {
                    int nowInSec = UUIDGen.unixTimestampInSec(proposal.ballot);
                    state = SystemKeyspace.loadPaxosState(proposal.update.partitionKey(), proposal.update.metadata(), nowInSec);
                    if (!proposal.hasBallot(state.promised.ballot) && !proposal.isAfter(state.promised)) break block8;
                    Tracing.trace("Accepting proposal {}", (Object)proposal);
                    SystemKeyspace.savePaxosProposal(proposal);
                    Boolean bl = true;
                    lock.unlock();
                    return bl;
                }
                catch (Throwable throwable) {
                    lock.unlock();
                    throw throwable;
                }
            }
            Tracing.trace("Rejecting proposal for {} because inProgress is now {}", (Object)proposal, (Object)state.promised);
            Boolean bl = false;
            lock.unlock();
            return bl;
        }
        finally {
            Keyspace.open((String)proposal.update.metadata().ksName).getColumnFamilyStore((UUID)proposal.update.metadata().cfId).metric.casPropose.addNano(System.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void commit(Commit proposal) {
        long start = System.nanoTime();
        try {
            if (UUIDGen.unixTimestamp(proposal.ballot) >= SystemKeyspace.getTruncatedAt(proposal.update.metadata().cfId)) {
                Tracing.trace("Committing proposal {}", (Object)proposal);
                Mutation mutation = proposal.makeMutation();
                try {
                    Uninterruptibles.getUninterruptibly(Keyspace.open(mutation.getKeyspaceName()).apply(mutation, true));
                }
                catch (ExecutionException e) {
                    throw Throwables.propagate(e.getCause());
                }
            } else {
                Tracing.trace("Not committing proposal {} as ballot timestamp predates last truncation time", (Object)proposal);
            }
            SystemKeyspace.savePaxosCommit(proposal);
        }
        finally {
            Keyspace.open((String)proposal.update.metadata().ksName).getColumnFamilyStore((UUID)proposal.update.metadata().cfId).metric.casCommit.addNano(System.nanoTime() - start);
        }
    }
}

