/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.thrift;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.ColumnIdentifier;
import org.apache.cassandra.cql3.Operator;
import org.apache.cassandra.cql3.statements.IndexTarget;
import org.apache.cassandra.db.CompactTables;
import org.apache.cassandra.db.LegacyLayout;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.db.compaction.AbstractCompactionStrategy;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.TypeParser;
import org.apache.cassandra.db.marshal.UTF8Type;
import org.apache.cassandra.exceptions.ConfigurationException;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.exceptions.RequestFailureException;
import org.apache.cassandra.exceptions.RequestTimeoutException;
import org.apache.cassandra.exceptions.RequestValidationException;
import org.apache.cassandra.exceptions.SyntaxException;
import org.apache.cassandra.exceptions.WriteTimeoutException;
import org.apache.cassandra.index.internal.CassandraIndex;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.locator.LocalStrategy;
import org.apache.cassandra.schema.CachingParams;
import org.apache.cassandra.schema.CompactionParams;
import org.apache.cassandra.schema.CompressionParams;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.Indexes;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.KeyspaceParams;
import org.apache.cassandra.schema.SpeculativeRetryParam;
import org.apache.cassandra.schema.Tables;
import org.apache.cassandra.schema.TriggerMetadata;
import org.apache.cassandra.schema.Triggers;
import org.apache.cassandra.serializers.MarshalException;
import org.apache.cassandra.thrift.AuthenticationException;
import org.apache.cassandra.thrift.CfDef;
import org.apache.cassandra.thrift.ColumnDef;
import org.apache.cassandra.thrift.ConsistencyLevel;
import org.apache.cassandra.thrift.IndexExpression;
import org.apache.cassandra.thrift.IndexType;
import org.apache.cassandra.thrift.InvalidRequestException;
import org.apache.cassandra.thrift.KsDef;
import org.apache.cassandra.thrift.TimedOutException;
import org.apache.cassandra.thrift.TriggerDef;
import org.apache.cassandra.thrift.UnavailableException;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.cassandra.utils.UUIDGen;

public class ThriftConversion {
    public static org.apache.cassandra.db.ConsistencyLevel fromThrift(ConsistencyLevel cl) {
        switch (cl) {
            case ANY: {
                return org.apache.cassandra.db.ConsistencyLevel.ANY;
            }
            case ONE: {
                return org.apache.cassandra.db.ConsistencyLevel.ONE;
            }
            case TWO: {
                return org.apache.cassandra.db.ConsistencyLevel.TWO;
            }
            case THREE: {
                return org.apache.cassandra.db.ConsistencyLevel.THREE;
            }
            case QUORUM: {
                return org.apache.cassandra.db.ConsistencyLevel.QUORUM;
            }
            case ALL: {
                return org.apache.cassandra.db.ConsistencyLevel.ALL;
            }
            case LOCAL_QUORUM: {
                return org.apache.cassandra.db.ConsistencyLevel.LOCAL_QUORUM;
            }
            case EACH_QUORUM: {
                return org.apache.cassandra.db.ConsistencyLevel.EACH_QUORUM;
            }
            case SERIAL: {
                return org.apache.cassandra.db.ConsistencyLevel.SERIAL;
            }
            case LOCAL_SERIAL: {
                return org.apache.cassandra.db.ConsistencyLevel.LOCAL_SERIAL;
            }
            case LOCAL_ONE: {
                return org.apache.cassandra.db.ConsistencyLevel.LOCAL_ONE;
            }
        }
        throw new AssertionError();
    }

    public static ConsistencyLevel toThrift(org.apache.cassandra.db.ConsistencyLevel cl) {
        switch (cl) {
            case ANY: {
                return ConsistencyLevel.ANY;
            }
            case ONE: {
                return ConsistencyLevel.ONE;
            }
            case TWO: {
                return ConsistencyLevel.TWO;
            }
            case THREE: {
                return ConsistencyLevel.THREE;
            }
            case QUORUM: {
                return ConsistencyLevel.QUORUM;
            }
            case ALL: {
                return ConsistencyLevel.ALL;
            }
            case LOCAL_QUORUM: {
                return ConsistencyLevel.LOCAL_QUORUM;
            }
            case EACH_QUORUM: {
                return ConsistencyLevel.EACH_QUORUM;
            }
            case SERIAL: {
                return ConsistencyLevel.SERIAL;
            }
            case LOCAL_SERIAL: {
                return ConsistencyLevel.LOCAL_SERIAL;
            }
            case LOCAL_ONE: {
                return ConsistencyLevel.LOCAL_ONE;
            }
        }
        throw new AssertionError();
    }

    public static RuntimeException rethrow(RequestExecutionException e) throws UnavailableException, TimedOutException {
        if (e instanceof RequestFailureException) {
            throw ThriftConversion.toThrift((RequestFailureException)e);
        }
        if (e instanceof RequestTimeoutException) {
            throw ThriftConversion.toThrift((RequestTimeoutException)e);
        }
        throw new UnavailableException();
    }

    public static InvalidRequestException toThrift(RequestValidationException e) {
        return new InvalidRequestException(e.getMessage());
    }

    public static UnavailableException toThrift(org.apache.cassandra.exceptions.UnavailableException e) {
        return new UnavailableException();
    }

    public static AuthenticationException toThrift(org.apache.cassandra.exceptions.AuthenticationException e) {
        return new AuthenticationException(e.getMessage());
    }

    public static TimedOutException toThrift(RequestTimeoutException e) {
        TimedOutException toe = new TimedOutException();
        if (e instanceof WriteTimeoutException) {
            WriteTimeoutException wte = (WriteTimeoutException)e;
            toe.setAcknowledged_by(wte.received);
            if (wte.writeType == WriteType.BATCH_LOG) {
                toe.setAcknowledged_by_batchlog(false);
            } else if (wte.writeType == WriteType.BATCH) {
                toe.setAcknowledged_by_batchlog(true);
            } else if (wte.writeType == WriteType.CAS) {
                toe.setPaxos_in_progress(true);
            }
        }
        return toe;
    }

    public static TimedOutException toThrift(RequestFailureException e) {
        return new TimedOutException();
    }

    public static RowFilter rowFilterFromThrift(CFMetaData metadata, List<IndexExpression> exprs) {
        if (exprs == null || exprs.isEmpty()) {
            return RowFilter.NONE;
        }
        RowFilter converted = RowFilter.forThrift(exprs.size());
        for (IndexExpression expr : exprs) {
            converted.addThriftExpression(metadata, expr.column_name, Operator.valueOf(expr.op.name()), expr.value);
        }
        return converted;
    }

    public static KeyspaceMetadata fromThrift(KsDef ksd, CFMetaData ... cfDefs) throws ConfigurationException {
        Class<AbstractReplicationStrategy> cls = AbstractReplicationStrategy.getClass(ksd.strategy_class);
        if (cls.equals(LocalStrategy.class)) {
            throw new ConfigurationException("Unable to use given strategy class: LocalStrategy is reserved for internal use.");
        }
        HashMap<String, String> replicationMap = new HashMap<String, String>();
        if (ksd.strategy_options != null) {
            replicationMap.putAll(ksd.strategy_options);
        }
        replicationMap.put("class", cls.getName());
        return KeyspaceMetadata.create(ksd.name, KeyspaceParams.create(ksd.durable_writes, replicationMap), Tables.of(cfDefs));
    }

    public static KsDef toThrift(KeyspaceMetadata ksm) {
        ArrayList<CfDef> cfDefs = new ArrayList<CfDef>();
        for (CFMetaData cfm : ksm.tables) {
            if (!cfm.isThriftCompatible()) continue;
            cfDefs.add(ThriftConversion.toThrift(cfm));
        }
        KsDef ksdef = new KsDef(ksm.name, ksm.params.replication.klass.getName(), cfDefs);
        ksdef.setStrategy_options(ksm.params.replication.options);
        ksdef.setDurable_writes(ksm.params.durableWrites);
        return ksdef;
    }

    public static CFMetaData fromThrift(CfDef cf_def) throws org.apache.cassandra.exceptions.InvalidRequestException, ConfigurationException {
        boolean isDense = cf_def.column_metadata == null || cf_def.column_metadata.isEmpty();
        return ThriftConversion.internalFromThrift(cf_def, true, Collections.emptyList(), isDense);
    }

    public static CFMetaData fromThriftForUpdate(CfDef cf_def, CFMetaData toUpdate) throws org.apache.cassandra.exceptions.InvalidRequestException, ConfigurationException {
        return ThriftConversion.internalFromThrift(cf_def, false, toUpdate.allColumns(), toUpdate.isDense());
    }

    private static boolean isSuper(String thriftColumnType) throws org.apache.cassandra.exceptions.InvalidRequestException {
        switch (thriftColumnType.toLowerCase()) {
            case "standard": {
                return false;
            }
            case "super": {
                return true;
            }
        }
        throw new org.apache.cassandra.exceptions.InvalidRequestException("Invalid column type " + thriftColumnType);
    }

    private static CFMetaData internalFromThrift(CfDef cf_def, boolean isCreation, Collection<ColumnDefinition> previousCQLMetadata, boolean isDense) throws org.apache.cassandra.exceptions.InvalidRequestException, ConfigurationException {
        ThriftConversion.applyImplicitDefaults(cf_def);
        try {
            boolean hasKeyAlias;
            boolean isSuper = ThriftConversion.isSuper(cf_def.column_type);
            AbstractType<?> rawComparator = TypeParser.parse(cf_def.comparator_type);
            BytesType subComparator = isSuper ? (cf_def.subcomparator_type == null ? BytesType.instance : TypeParser.parse(cf_def.subcomparator_type)) : null;
            BytesType keyValidator = cf_def.isSetKey_validation_class() ? TypeParser.parse(cf_def.key_validation_class) : BytesType.instance;
            AbstractType<?> defaultValidator = TypeParser.parse(cf_def.default_validation_class);
            List<ColumnDefinition> defs = ThriftConversion.fromThrift(cf_def.keyspace, cf_def.name, rawComparator, subComparator, cf_def.column_metadata);
            boolean bl = hasKeyAlias = cf_def.isSetKey_alias() && keyValidator != null && !(keyValidator instanceof CompositeType);
            if (hasKeyAlias) {
                defs.add(ColumnDefinition.partitionKeyDef(cf_def.keyspace, cf_def.name, UTF8Type.instance.getString(cf_def.key_alias), keyValidator, 0));
            }
            for (ColumnDefinition def : previousCQLMetadata) {
                if (def.isPartOfCellName(false, isSuper) || def.kind == ColumnDefinition.Kind.PARTITION_KEY && hasKeyAlias) continue;
                defs.add(def);
            }
            UUID cfId = Schema.instance.getId(cf_def.keyspace, cf_def.name);
            if (cfId == null) {
                cfId = UUIDGen.getTimeUUID();
            }
            boolean isCompound = !isSuper && rawComparator instanceof CompositeType;
            boolean isCounter = defaultValidator instanceof CounterColumnType;
            if (isCreation) {
                ThriftConversion.addDefaultCQLMetadata(defs, cf_def.keyspace, cf_def.name, hasKeyAlias ? null : keyValidator, rawComparator, subComparator, defaultValidator);
            }
            boolean isView = false;
            CFMetaData newCFMD = CFMetaData.create(cf_def.keyspace, cf_def.name, cfId, isDense, isCompound, isSuper, isCounter, isView, defs, DatabaseDescriptor.getPartitioner());
            newCFMD.indexes(ThriftConversion.indexDefsFromThrift(newCFMD, cf_def.keyspace, cf_def.name, rawComparator, subComparator, cf_def.column_metadata));
            if (cf_def.isSetGc_grace_seconds()) {
                newCFMD.gcGraceSeconds(cf_def.gc_grace_seconds);
            }
            newCFMD.compaction(ThriftConversion.compactionParamsFromThrift(cf_def));
            if (cf_def.isSetBloom_filter_fp_chance()) {
                newCFMD.bloomFilterFpChance(cf_def.bloom_filter_fp_chance);
            }
            if (cf_def.isSetMemtable_flush_period_in_ms()) {
                newCFMD.memtableFlushPeriod(cf_def.memtable_flush_period_in_ms);
            }
            if (cf_def.isSetCaching() || cf_def.isSetCells_per_row_to_cache()) {
                newCFMD.caching(ThriftConversion.cachingFromThrift(cf_def.caching, cf_def.cells_per_row_to_cache));
            }
            if (cf_def.isSetRead_repair_chance()) {
                newCFMD.readRepairChance(cf_def.read_repair_chance);
            }
            if (cf_def.isSetDefault_time_to_live()) {
                newCFMD.defaultTimeToLive(cf_def.default_time_to_live);
            }
            if (cf_def.isSetDclocal_read_repair_chance()) {
                newCFMD.dcLocalReadRepairChance(cf_def.dclocal_read_repair_chance);
            }
            if (cf_def.isSetMin_index_interval()) {
                newCFMD.minIndexInterval(cf_def.min_index_interval);
            }
            if (cf_def.isSetMax_index_interval()) {
                newCFMD.maxIndexInterval(cf_def.max_index_interval);
            }
            if (cf_def.isSetSpeculative_retry()) {
                newCFMD.speculativeRetry(SpeculativeRetryParam.fromString(cf_def.speculative_retry));
            }
            if (cf_def.isSetTriggers()) {
                newCFMD.triggers(ThriftConversion.triggerDefinitionsFromThrift(cf_def.triggers));
            }
            if (cf_def.isSetComment()) {
                newCFMD.comment(cf_def.comment);
            }
            if (cf_def.isSetCompression_options()) {
                newCFMD.compression(ThriftConversion.compressionParametersFromThrift(cf_def.compression_options));
            }
            return newCFMD;
        }
        catch (SyntaxException | MarshalException e) {
            throw new ConfigurationException(e.getMessage());
        }
    }

    private static CompactionParams compactionParamsFromThrift(CfDef cf_def) {
        Class<? extends AbstractCompactionStrategy> klass = CFMetaData.createCompactionStrategy(cf_def.compaction_strategy);
        HashMap<String, String> options = new HashMap<String, String>(cf_def.compaction_strategy_options);
        int minThreshold = cf_def.min_compaction_threshold;
        int maxThreshold = cf_def.max_compaction_threshold;
        if (CompactionParams.supportsThresholdParams(klass)) {
            options.putIfAbsent(CompactionParams.Option.MIN_THRESHOLD.toString(), Integer.toString(minThreshold));
            options.putIfAbsent(CompactionParams.Option.MAX_THRESHOLD.toString(), Integer.toString(maxThreshold));
        }
        return CompactionParams.create(klass, options);
    }

    private static CompressionParams compressionParametersFromThrift(Map<String, String> compression_options) {
        CompressionParams compressionParameter = CompressionParams.fromMap(compression_options);
        compressionParameter.validate();
        return compressionParameter;
    }

    private static void addDefaultCQLMetadata(Collection<ColumnDefinition> defs, String ks, String cf, AbstractType<?> keyValidator, AbstractType<?> comparator, AbstractType<?> subComparator, AbstractType<?> defaultValidator) {
        int i;
        List<AbstractType<?>> subTypes;
        CompactTables.DefaultNames names = CompactTables.defaultNameGenerator(defs);
        if (keyValidator != null) {
            if (keyValidator instanceof CompositeType) {
                subTypes = ((CompositeType)keyValidator).types;
                for (i = 0; i < subTypes.size(); ++i) {
                    defs.add(ColumnDefinition.partitionKeyDef(ks, cf, names.defaultPartitionKeyName(), subTypes.get(i), i));
                }
            } else {
                defs.add(ColumnDefinition.partitionKeyDef(ks, cf, names.defaultPartitionKeyName(), keyValidator, 0));
            }
        }
        if (subComparator != null) {
            defs.add(ColumnDefinition.clusteringDef(ks, cf, names.defaultClusteringName(), comparator, 0));
            defs.add(ColumnDefinition.regularDef(ks, cf, CompactTables.SUPER_COLUMN_MAP_COLUMN_STR, MapType.getInstance(subComparator, defaultValidator, true)));
        } else {
            subTypes = comparator instanceof CompositeType ? ((CompositeType)comparator).types : Collections.singletonList(comparator);
            for (i = 0; i < subTypes.size(); ++i) {
                defs.add(ColumnDefinition.clusteringDef(ks, cf, names.defaultClusteringName(), subTypes.get(i), i));
            }
            defs.add(ColumnDefinition.regularDef(ks, cf, names.defaultCompactValueName(), defaultValidator));
        }
    }

    private static void applyImplicitDefaults(CfDef cf_def) {
        if (!cf_def.isSetComment()) {
            cf_def.setComment("");
        }
        if (!cf_def.isSetMin_compaction_threshold()) {
            cf_def.setMin_compaction_threshold(4);
        }
        if (!cf_def.isSetMax_compaction_threshold()) {
            cf_def.setMax_compaction_threshold(32);
        }
        if (!cf_def.isSetCompaction_strategy()) {
            cf_def.setCompaction_strategy(CompactionParams.DEFAULT.klass().getSimpleName());
        }
        if (!cf_def.isSetCompaction_strategy_options()) {
            cf_def.setCompaction_strategy_options(Collections.emptyMap());
        }
        if (!cf_def.isSetCompression_options()) {
            cf_def.setCompression_options(Collections.singletonMap("sstable_compression", CompressionParams.DEFAULT.klass().getCanonicalName()));
        }
        if (!cf_def.isSetDefault_time_to_live()) {
            cf_def.setDefault_time_to_live(0);
        }
        if (!cf_def.isSetDclocal_read_repair_chance()) {
            cf_def.setDclocal_read_repair_chance(0.1);
        }
        if (!cf_def.isSetMin_index_interval()) {
            if (cf_def.isSetIndex_interval()) {
                cf_def.setMin_index_interval(cf_def.getIndex_interval());
            } else {
                cf_def.setMin_index_interval(128);
            }
        }
        if (!cf_def.isSetMax_index_interval()) {
            cf_def.setMax_index_interval(Math.max(cf_def.min_index_interval, 2048));
        }
    }

    public static CfDef toThrift(CFMetaData cfm) {
        CfDef def = new CfDef(cfm.ksName, cfm.cfName);
        def.setColumn_type(cfm.isSuper() ? "Super" : "Standard");
        if (cfm.isSuper()) {
            def.setComparator_type(cfm.comparator.subtype(0).toString());
            def.setSubcomparator_type(cfm.thriftColumnNameType().toString());
        } else {
            def.setComparator_type(LegacyLayout.makeLegacyComparator(cfm).toString());
        }
        def.setComment(cfm.params.comment);
        def.setRead_repair_chance(cfm.params.readRepairChance);
        def.setDclocal_read_repair_chance(cfm.params.dcLocalReadRepairChance);
        def.setGc_grace_seconds(cfm.params.gcGraceSeconds);
        def.setDefault_validation_class(cfm.makeLegacyDefaultValidator().toString());
        def.setKey_validation_class(cfm.getKeyValidator().toString());
        def.setMin_compaction_threshold(cfm.params.compaction.minCompactionThreshold());
        def.setMax_compaction_threshold(cfm.params.compaction.maxCompactionThreshold());
        if (cfm.partitionKeyColumns().size() == 1) {
            def.setKey_alias(cfm.partitionKeyColumns().get((int)0).name.bytes);
        }
        def.setColumn_metadata(ThriftConversion.columnDefinitionsToThrift(cfm, cfm.allColumns()));
        def.setCompaction_strategy(cfm.params.compaction.klass().getName());
        def.setCompaction_strategy_options(cfm.params.compaction.options());
        def.setCompression_options(ThriftConversion.compressionParametersToThrift(cfm.params.compression));
        def.setBloom_filter_fp_chance(cfm.params.bloomFilterFpChance);
        def.setMin_index_interval(cfm.params.minIndexInterval);
        def.setMax_index_interval(cfm.params.maxIndexInterval);
        def.setMemtable_flush_period_in_ms(cfm.params.memtableFlushPeriodInMs);
        def.setCaching(ThriftConversion.toThrift(cfm.params.caching));
        def.setCells_per_row_to_cache(ThriftConversion.toThriftCellsPerRow(cfm.params.caching));
        def.setDefault_time_to_live(cfm.params.defaultTimeToLive);
        def.setSpeculative_retry(cfm.params.speculativeRetry.toString());
        def.setTriggers(ThriftConversion.triggerDefinitionsToThrift(cfm.getTriggers()));
        return def;
    }

    public static ColumnDefinition fromThrift(String ksName, String cfName, AbstractType<?> thriftComparator, AbstractType<?> thriftSubcomparator, ColumnDef thriftColumnDef) throws SyntaxException, ConfigurationException {
        boolean isSuper = thriftSubcomparator != null;
        AbstractType<?> comparator = thriftSubcomparator == null ? thriftComparator : thriftSubcomparator;
        try {
            comparator.validate(thriftColumnDef.name);
        }
        catch (MarshalException e) {
            throw new ConfigurationException(String.format("Column name %s is not valid for comparator %s", ByteBufferUtil.bytesToHex(thriftColumnDef.name), comparator));
        }
        ColumnDefinition.Kind kind = isSuper ? ColumnDefinition.Kind.REGULAR : ColumnDefinition.Kind.STATIC;
        return new ColumnDefinition(ksName, cfName, ColumnIdentifier.getInterned(ByteBufferUtil.clone(thriftColumnDef.name), comparator), TypeParser.parse(thriftColumnDef.validation_class), -1, kind);
    }

    private static List<ColumnDefinition> fromThrift(String ksName, String cfName, AbstractType<?> thriftComparator, AbstractType<?> thriftSubcomparator, List<ColumnDef> thriftDefs) throws SyntaxException, ConfigurationException {
        if (thriftDefs == null) {
            return new ArrayList<ColumnDefinition>();
        }
        ArrayList<ColumnDefinition> defs = new ArrayList<ColumnDefinition>(thriftDefs.size());
        for (ColumnDef thriftColumnDef : thriftDefs) {
            defs.add(ThriftConversion.fromThrift(ksName, cfName, thriftComparator, thriftSubcomparator, thriftColumnDef));
        }
        return defs;
    }

    private static Indexes indexDefsFromThrift(CFMetaData cfm, String ksName, String cfName, AbstractType<?> thriftComparator, AbstractType<?> thriftSubComparator, List<ColumnDef> thriftDefs) {
        if (thriftDefs == null) {
            return Indexes.none();
        }
        HashSet<String> indexNames = new HashSet<String>();
        Indexes.Builder indexes = Indexes.builder();
        for (ColumnDef def : thriftDefs) {
            if (!def.isSetIndex_type()) continue;
            ColumnDefinition column = ThriftConversion.fromThrift(ksName, cfName, thriftComparator, thriftSubComparator, def);
            String indexName = def.getIndex_name();
            if (Strings.isNullOrEmpty(indexName)) {
                indexName = Indexes.getAvailableIndexName(ksName, cfName, column.name.toString());
            }
            if (indexNames.contains(indexName)) {
                throw new ConfigurationException("Duplicate index name " + indexName);
            }
            indexNames.add(indexName);
            Map indexOptions = def.getIndex_options();
            if (indexOptions != null && indexOptions.containsKey("target")) {
                throw new ConfigurationException("Reserved index option 'target' cannot be used");
            }
            IndexMetadata.Kind kind = IndexMetadata.Kind.valueOf(def.index_type.name());
            indexes.add(IndexMetadata.fromLegacyMetadata(cfm, column, indexName, kind, indexOptions));
        }
        return indexes.build();
    }

    @VisibleForTesting
    public static ColumnDef toThrift(CFMetaData cfMetaData, ColumnDefinition column) {
        ColumnDef cd = new ColumnDef();
        cd.setName(ByteBufferUtil.clone(column.name.bytes));
        cd.setValidation_class(column.type.toString());
        IndexMetadata matchedIndex = null;
        for (IndexMetadata index : cfMetaData.getIndexes()) {
            Pair<ColumnDefinition, IndexTarget.Type> target = CassandraIndex.parseTarget(cfMetaData, index);
            if (!((ColumnDefinition)target.left).equals(column)) continue;
            if (matchedIndex != null) {
                return cd;
            }
            matchedIndex = index;
        }
        if (matchedIndex != null) {
            cd.setIndex_type(IndexType.valueOf((String)matchedIndex.kind.name()));
            cd.setIndex_name(matchedIndex.name);
            Map<String, String> filteredOptions = Maps.filterKeys(matchedIndex.options, s -> !"target".equals(s));
            cd.setIndex_options(filteredOptions.isEmpty() ? null : Maps.newHashMap(filteredOptions));
        }
        return cd;
    }

    private static List<ColumnDef> columnDefinitionsToThrift(CFMetaData metadata, Collection<ColumnDefinition> columns) {
        ArrayList<ColumnDef> thriftDefs = new ArrayList<ColumnDef>(columns.size());
        for (ColumnDefinition def : columns) {
            if (!def.isPartOfCellName(metadata.isCQLTable(), metadata.isSuper())) continue;
            thriftDefs.add(ThriftConversion.toThrift(metadata, def));
        }
        return thriftDefs;
    }

    private static Triggers triggerDefinitionsFromThrift(List<TriggerDef> thriftDefs) {
        Triggers.Builder triggers = Triggers.builder();
        for (TriggerDef thriftDef : thriftDefs) {
            triggers.add(new TriggerMetadata(thriftDef.getName(), (String)thriftDef.getOptions().get("class")));
        }
        return triggers.build();
    }

    private static List<TriggerDef> triggerDefinitionsToThrift(Triggers triggers) {
        ArrayList<TriggerDef> thriftDefs = new ArrayList<TriggerDef>();
        for (TriggerMetadata def : triggers) {
            TriggerDef td = new TriggerDef();
            td.setName(def.name);
            td.setOptions(Collections.singletonMap("class", def.classOption));
            thriftDefs.add(td);
        }
        return thriftDefs;
    }

    public static Map<String, String> compressionParametersToThrift(CompressionParams parameters) {
        if (!parameters.isEnabled()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> options = new HashMap<String, String>(parameters.getOtherOptions());
        Class<?> klass = parameters.getSstableCompressor().getClass();
        options.put("sstable_compression", klass.getName());
        options.put("chunk_length_kb", parameters.chunkLengthInKB());
        return options;
    }

    private static String toThrift(CachingParams caching) {
        if (caching.cacheRows() && caching.cacheKeys()) {
            return "ALL";
        }
        if (caching.cacheRows()) {
            return "ROWS_ONLY";
        }
        if (caching.cacheKeys()) {
            return "KEYS_ONLY";
        }
        return "NONE";
    }

    private static CachingParams cachingFromTrhfit(String caching) {
        switch (caching.toUpperCase()) {
            case "ALL": {
                return CachingParams.CACHE_EVERYTHING;
            }
            case "ROWS_ONLY": {
                return new CachingParams(false, Integer.MAX_VALUE);
            }
            case "KEYS_ONLY": {
                return CachingParams.CACHE_KEYS;
            }
            case "NONE": {
                return CachingParams.CACHE_NOTHING;
            }
        }
        throw new ConfigurationException(String.format("Invalid value %s for caching parameter", caching));
    }

    private static String toThriftCellsPerRow(CachingParams caching) {
        return caching.cacheAllRows() ? "ALL" : String.valueOf(caching.rowsPerPartitionToCache());
    }

    private static int fromThriftCellsPerRow(String value) {
        return "ALL".equals(value) ? Integer.MAX_VALUE : Integer.parseInt(value);
    }

    public static CachingParams cachingFromThrift(String caching, String cellsPerRow) {
        boolean cacheKeys = true;
        int rowsPerPartitionToCache = 0;
        if (caching != null) {
            CachingParams parsed = ThriftConversion.cachingFromTrhfit(caching);
            cacheKeys = parsed.cacheKeys();
            rowsPerPartitionToCache = parsed.rowsPerPartitionToCache();
        }
        if (cellsPerRow != null && rowsPerPartitionToCache > 0) {
            rowsPerPartitionToCache = ThriftConversion.fromThriftCellsPerRow(cellsPerRow);
        }
        return new CachingParams(cacheKeys, rowsPerPartitionToCache);
    }
}

