/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.jobs;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.datetime.DateTimeService;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.metrics.scheduler.api.RepeatingTrigger;
import org.hawkular.metrics.scheduler.api.Trigger;
import org.hawkular.metrics.sysconfig.Configuration;
import org.hawkular.metrics.sysconfig.ConfigurationService;
import org.jboss.logging.Logger;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

public class CompressData
implements Func1<JobDetails, Completable> {
    private static Logger logger = Logger.getLogger(CompressData.class);
    public static final String JOB_NAME = "COMPRESS_DATA";
    public static final String BLOCK_SIZE = "compression.block.size";
    public static final String TARGET_TIME = "compression.time.target";
    public static final String CONFIG_ID = "org.hawkular.metrics.jobs.COMPRESS_DATA";
    public static final Duration DEFAULT_BLOCK_SIZE = Duration.standardHours(2L);
    private static final int DEFAULT_PAGE_SIZE = 1000;
    private MetricsService metricsService;
    private int pageSize;
    private boolean enabled;
    private Duration blockSize;

    public CompressData(MetricsService service, ConfigurationService configurationService) {
        this.metricsService = service;
        Configuration configuration = (Configuration)configurationService.load(CONFIG_ID).toSingle().toBlocking().value();
        this.pageSize = configuration.get("page-size") == null ? 1000 : Integer.parseInt(configuration.get("page-size"));
        if (configuration.get(BLOCK_SIZE) != null) {
            java.time.Duration parsedDuration = java.time.Duration.parse(configuration.get(BLOCK_SIZE));
            this.blockSize = Duration.millis(parsedDuration.toMillis());
        } else {
            this.blockSize = DEFAULT_BLOCK_SIZE;
        }
        String enabledConfig = configuration.get("enabled", "true");
        this.enabled = Boolean.parseBoolean(enabledConfig);
        logger.debugf("Job enabled? %b", (Object)this.enabled);
    }

    public Completable call(JobDetails jobDetails) {
        DateTime timeSliceInclusive;
        Duration runtimeBlockSize = this.blockSize;
        Trigger trigger = jobDetails.getTrigger();
        if (trigger instanceof RepeatingTrigger) {
            if (!this.enabled) {
                return Completable.complete();
            }
            timeSliceInclusive = new DateTime(trigger.getTriggerTime(), DateTimeZone.UTC).minus(runtimeBlockSize);
        } else {
            if (!jobDetails.getParameters().containsKey(TARGET_TIME)) {
                logger.error((Object)"Missing compression.time.target parameter from manual execution of COMPRESS_DATA job");
                return Completable.complete();
            }
            Long parsedMillis = Long.valueOf(jobDetails.getParameters().get(TARGET_TIME));
            timeSliceInclusive = new DateTime((Object)parsedMillis, DateTimeZone.UTC);
            if (jobDetails.getParameters().containsKey(BLOCK_SIZE)) {
                java.time.Duration parsedDuration = java.time.Duration.parse(jobDetails.getParameters().get(BLOCK_SIZE));
                runtimeBlockSize = Duration.millis(parsedDuration.toMillis());
            }
        }
        DateTime timeSliceStart = DateTimeService.getTimeSlice(timeSliceInclusive, runtimeBlockSize);
        long startOfSlice = timeSliceStart.getMillis();
        long endOfSlice = timeSliceStart.plus(runtimeBlockSize).getMillis() - 1L;
        Stopwatch stopwatch = Stopwatch.createStarted();
        logger.info((Object)("Starting compression of timestamps (UTC) between " + startOfSlice + " - " + endOfSlice));
        Observable metricIds = this.metricsService.findAllMetricIdentifiers().filter(m -> m.getType() == MetricType.GAUGE || m.getType() == MetricType.COUNTER || m.getType() == MetricType.AVAILABILITY);
        return this.metricsService.compressBlock(metricIds, startOfSlice, endOfSlice, this.pageSize).doOnError(t -> logger.warn((Object)"Failed to compress data", t)).doOnCompleted(() -> {
            stopwatch.stop();
            logger.info((Object)("Finished compressing data in " + stopwatch.elapsed(TimeUnit.MILLISECONDS) + " ms"));
        });
    }
}

