/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.compress;

import java.util.ArrayList;
import java.util.EnumSet;

public class CompressorHeader {
    public static byte getHeader(Compressor compressor, EnumSet<? extends CompressorSetting> settings) {
        byte b = (byte)(compressor.getByteValue() & 0xF0);
        for (CompressorSetting compressorSetting : settings) {
            b = (byte)(b ^ compressorSetting.getByteValue());
        }
        return b;
    }

    public static Compressor getCompressor(byte b) {
        byte d = (byte)(b & 0xF0);
        for (Compressor compressor : Compressor.values()) {
            if (compressor.value != d) continue;
            return compressor;
        }
        throw new RuntimeException("Invalid compression method " + Integer.toBinaryString((d & 0xFF) + 256).substring(1));
    }

    public static <E extends Enum<E>> EnumSet getSettings(Class<E> e, byte b) {
        ArrayList<Enum> enumList = new ArrayList<Enum>(4);
        EnumSet<Enum> enumSet = EnumSet.allOf(e);
        for (Enum setting : enumSet) {
            if ((b & ((CompressorSetting)((Object)setting)).getByteValue()) != ((CompressorSetting)((Object)setting)).getByteValue()) continue;
            enumList.add(setting);
        }
        return EnumSet.copyOf(enumList);
    }

    public static enum GorillaSettings implements CompressorSetting
    {
        SECOND_PRECISION(1);

        private byte value;

        private GorillaSettings(byte value) {
            this.value = value;
        }

        @Override
        public byte getByteValue() {
            return this.value;
        }
    }

    public static enum Compressor {
        GORILLA(16, GorillaSettings.class);

        private byte value;
        private Class enumClass;

        private Compressor(byte value, Class enumClass) {
            this.value = value;
            this.enumClass = enumClass;
        }

        public byte getByteValue() {
            return this.value;
        }

        public <E extends Enum<E>> Class getSettingsClass() {
            return this.enumClass;
        }
    }

    public static interface CompressorSetting {
        public byte getByteValue();
    }
}

