/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.tags;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.hawkular.metrics.model.param.Tags;

public class TagsConverter {
    public static Tags fromString(String value) {
        if (value == null) {
            return new Tags(Collections.emptyMap());
        }
        return TagsConverter.convert(value);
    }

    private static Tags convert(String value) {
        if (value.isEmpty()) {
            return new Tags(Collections.emptyMap());
        }
        Preconditions.checkArgument(!value.trim().isEmpty(), "Invalid tags: %s", value);
        HashMap<String, String> tags = new HashMap<String, String>();
        String previousToken = null;
        StringTokenizer tokenizer = new StringTokenizer(value, ",", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (previousToken == null) {
                Preconditions.checkArgument(!",".equals(token), "Invalid tags: %s", value);
            } else {
                Preconditions.checkArgument(!",".equals(previousToken));
            }
            if (",".equals(token)) {
                previousToken = null;
                continue;
            }
            int colonIndex = token.indexOf(":");
            Preconditions.checkArgument(TagsConverter.hasExpectedForm(token, colonIndex), "Invalid tags: %s", value);
            try {
                String tagValue = URLDecoder.decode(token.substring(colonIndex + 1), StandardCharsets.UTF_8.name());
                tags.put(token.substring(0, colonIndex), tagValue);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            previousToken = token;
        }
        return new Tags(tags);
    }

    private static boolean hasExpectedForm(String token, int colonIndex) {
        return colonIndex > 0 && colonIndex < token.length();
    }
}

