/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.transformers;

import fi.iki.yak.ts.compression.gorilla.ByteBufferBitOutput;
import fi.iki.yak.ts.compression.gorilla.Compressor;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.hawkular.metrics.core.service.compress.CompressedPointContainer;
import org.hawkular.metrics.core.service.compress.CompressorHeader;
import org.hawkular.metrics.core.service.compress.TagsSerializer;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.MetricType;
import rx.Observable;

public class DataPointCompressTransformer<T>
implements Observable.Transformer<DataPoint<T>, CompressedPointContainer> {
    private ByteBufferBitOutput out = new ByteBufferBitOutput();
    private long sliceTimestamp;
    private MetricType<T> metricType;
    private Compressor compressor;
    private TagsSerializer tagsSerializer;

    public DataPointCompressTransformer(MetricType<T> metricType, long timeslice) {
        this.metricType = metricType;
        byte gorillaHeader = CompressorHeader.getHeader(CompressorHeader.Compressor.GORILLA, EnumSet.noneOf(CompressorHeader.GorillaSettings.class));
        this.out.getByteBuffer().put(gorillaHeader);
        this.sliceTimestamp = timeslice;
        this.compressor = new Compressor(timeslice, this.out);
        this.tagsSerializer = new TagsSerializer(timeslice);
    }

    public Observable<CompressedPointContainer> call(Observable<DataPoint<T>> datapoints) {
        return datapoints.collect(CompressedPointContainer::new, (container, d) -> {
            switch (this.metricType.getCode()) {
                case 0: {
                    this.compressor.addValue(d.getTimestamp(), (Double)d.getValue());
                    break;
                }
                case 1: {
                    this.compressor.addValue(d.getTimestamp(), Byte.valueOf(((AvailabilityType)((Object)((Object)d.getValue()))).getCode()).doubleValue());
                    break;
                }
                case 2: {
                    this.compressor.addValue(d.getTimestamp(), ((Long)d.getValue()).doubleValue());
                    break;
                }
                default: {
                    throw new RuntimeException("Metric of type " + this.metricType.getText() + " is not supported in compression");
                }
            }
            if (d.getTags() != null && !d.getTags().isEmpty()) {
                this.tagsSerializer.addDataPointTags(d.getTimestamp(), d.getTags());
            }
        }).doOnNext(cpc -> {
            this.compressor.close();
            ByteBuffer valueBuffer = (ByteBuffer)this.out.getByteBuffer().flip();
            ByteBuffer tagsBuffer = (ByteBuffer)this.tagsSerializer.getByteBuffer().flip();
            cpc.setValueBuffer(valueBuffer);
            if (tagsBuffer.limit() > 1) {
                cpc.setTagsBuffer(tagsBuffer);
            }
        });
    }
}

