/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicLong;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.Subscription;
import rx.exceptions.CompositeException;
import rx.exceptions.MissingBackpressureException;
import rx.internal.operators.BackpressureUtils;
import rx.internal.operators.NotificationLite;
import rx.internal.util.RxRingBuffer;
import rx.internal.util.unsafe.MpscLinkedQueue;

public final class SortedMerge<T>
implements Observable.OnSubscribe<T> {
    final List<Observable<? extends T>> sources;
    final Comparator<? super T> comparator;
    final boolean delayErrors;
    final boolean removeDuplicates;

    public static <U extends Comparable<? super U>> Observable<U> create(Collection<Observable<? extends U>> sources) {
        return SortedMerge.create(sources, false, false);
    }

    public static <U> Observable<U> create(Collection<Observable<? extends U>> sources, Comparator<? super U> comparator) {
        return SortedMerge.create(sources, comparator, false, false);
    }

    public static <U extends Comparable<? super U>> Observable<U> create(Collection<Observable<? extends U>> sources, boolean delayErrors, boolean removeDuplicates) {
        return Observable.create(new SortedMerge(sources, (o1, o2) -> o1.compareTo(o2), delayErrors, removeDuplicates));
    }

    public static <U> Observable<U> create(Collection<Observable<? extends U>> sources, Comparator<? super U> comparator, boolean delayErrors, boolean removeDuplicates) {
        return Observable.create(new SortedMerge<U>(sources, comparator, delayErrors, removeDuplicates));
    }

    protected SortedMerge(Collection<Observable<? extends T>> sources, Comparator<? super T> comparator, boolean delayErrors, boolean removeDuplicates) {
        this.sources = sources instanceof List ? (List<Object>)sources : new ArrayList<Observable<? extends T>>(sources);
        this.comparator = comparator;
        this.delayErrors = delayErrors;
        this.removeDuplicates = removeDuplicates;
    }

    public void call(Subscriber<? super T> child) {
        int i;
        SourceSubscriber[] sources = new SourceSubscriber[this.sources.size()];
        MergeProducer<T> mp = new MergeProducer<T>(sources, child, this.comparator, this.delayErrors);
        for (i = 0; i < sources.length; ++i) {
            SourceSubscriber<? super T> s;
            if (child.isUnsubscribed()) {
                return;
            }
            sources[i] = s = new SourceSubscriber<T>(mp);
            child.add(s);
        }
        mp.set(0L);
        child.setProducer(mp);
        i = 0;
        for (Observable<? extends T> observable : this.sources) {
            if (child.isUnsubscribed()) {
                return;
            }
            observable.unsafeSubscribe((Subscriber)sources[i]);
            ++i;
        }
    }

    static final class SourceSubscriber<T>
    extends Subscriber<T> {
        final RxRingBuffer queue = RxRingBuffer.getSpscInstance();
        final MergeProducer<T> parent;
        volatile boolean done;

        public SourceSubscriber(MergeProducer<T> parent) {
            this.parent = parent;
        }

        public void onStart() {
            this.add((Subscription)this.queue);
            this.request(RxRingBuffer.SIZE);
        }

        public void requestMore(long n) {
            this.request(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onNext(T t) {
            try {
                this.queue.onNext(NotificationLite.next(t));
            }
            catch (MissingBackpressureException mbe) {
                try {
                    this.onError(mbe);
                }
                finally {
                    this.unsubscribe();
                }
                return;
            }
            catch (IllegalStateException ex) {
                if (!this.isUnsubscribed()) {
                    try {
                        this.onError(ex);
                    }
                    finally {
                        this.unsubscribe();
                    }
                }
                return;
            }
            this.parent.emit();
        }

        public void onError(Throwable e) {
            this.done = true;
            this.parent.error(e);
        }

        public void onCompleted() {
            this.done = true;
            this.parent.emit();
        }
    }

    static final class MergeProducer<T>
    extends AtomicLong
    implements Producer {
        private static final long serialVersionUID = -812969080497027108L;
        final boolean delayErrors;
        final Comparator<? super T> comparator;
        final SourceSubscriber[] sources;
        final Subscriber<? super T> child;
        final Queue<Throwable> errors;
        boolean emitting;
        boolean missed;

        public MergeProducer(SourceSubscriber[] sources, Subscriber<? super T> child, Comparator<? super T> comparator, boolean delayErrors) {
            this.sources = sources;
            this.delayErrors = delayErrors;
            this.errors = new MpscLinkedQueue();
            this.child = child;
            this.comparator = comparator;
        }

        public void request(long n) {
            BackpressureUtils.getAndAddRequest((AtomicLong)this, (long)n);
            this.emit();
        }

        public void error(Throwable ex) {
            this.errors.offer(ex);
            this.emit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void emit() {
            MergeProducer mergeProducer = this;
            synchronized (mergeProducer) {
                if (this.emitting) {
                    this.missed = true;
                    return;
                }
                this.emitting = true;
            }
            SourceSubscriber[] sources = this.sources;
            int n = sources.length;
            Subscriber<? super T> child = this.child;
            while (!child.isUnsubscribed()) {
                if (!this.delayErrors && !this.errors.isEmpty()) {
                    child.onError(this.errors.poll());
                    return;
                }
                long r = this.get();
                long e = 0L;
                if (r == 0L) {
                    int doneCount = 0;
                    for (SourceSubscriber s : sources) {
                        if (s == null) {
                            ++doneCount;
                            continue;
                        }
                        if (!s.done || !s.queue.isEmpty()) continue;
                        ++doneCount;
                    }
                    if (doneCount == n) {
                        this.reportErrorOrComplete(child);
                        return;
                    }
                }
                while (r != 0L) {
                    if (child.isUnsubscribed()) {
                        return;
                    }
                    if (!this.delayErrors && !this.errors.isEmpty()) {
                        child.onError(this.errors.poll());
                        return;
                    }
                    boolean fullRow = true;
                    boolean hasAtLeastOne = false;
                    boolean hasDuplicate = false;
                    Object minimum = null;
                    int toPoll = -1;
                    int doneCount = 0;
                    for (int i = 0; i < n; ++i) {
                        SourceSubscriber s = sources[i];
                        if (s == null) {
                            ++doneCount;
                            continue;
                        }
                        boolean d = s.done;
                        Object o = s.queue.peek();
                        if (o == null) {
                            if (d) {
                                sources[i] = null;
                                ++doneCount;
                                continue;
                            }
                            fullRow = false;
                            break;
                        }
                        if (hasAtLeastOne) {
                            Object v = NotificationLite.getValue((Object)o);
                            int c = this.comparator.compare(minimum, v);
                            if (c > 0) {
                                minimum = v;
                                toPoll = i;
                                continue;
                            }
                            if (c != 0) continue;
                            hasDuplicate = true;
                            toPoll = i;
                            continue;
                        }
                        minimum = NotificationLite.getValue((Object)o);
                        hasAtLeastOne = true;
                        toPoll = i;
                    }
                    if (doneCount == n) {
                        this.reportErrorOrComplete(child);
                        return;
                    }
                    if (!fullRow) break;
                    if (toPoll >= 0) {
                        SourceSubscriber s = sources[toPoll];
                        s.queue.poll();
                        s.requestMore(1L);
                    }
                    if (!hasDuplicate) {
                        child.onNext(minimum);
                    }
                    if (r == Long.MAX_VALUE) continue;
                    --r;
                    ++e;
                }
                if (e != 0L) {
                    this.addAndGet(-e);
                }
                MergeProducer mergeProducer2 = this;
                synchronized (mergeProducer2) {
                    if (!this.missed) {
                        this.emitting = false;
                        return;
                    }
                    this.missed = false;
                }
            }
            return;
        }

        protected void reportErrorOrComplete(Subscriber<? super T> child) {
            if (this.delayErrors && !this.errors.isEmpty()) {
                if (this.errors.size() == 1) {
                    child.onError(this.errors.poll());
                } else {
                    child.onError((Throwable)new CompositeException(this.errors));
                }
            } else {
                child.onCompleted();
            }
        }
    }
}

