/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.scheduler.api;

import com.datastax.driver.core.Session;
import com.google.common.collect.ImmutableMap;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.datetime.DateTimeService;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.metrics.scheduler.api.RepeatingTrigger;
import org.hawkular.metrics.scheduler.api.Scheduler;
import org.hawkular.metrics.scheduler.impl.SchedulerImpl;
import org.hawkular.metrics.sysconfig.Configuration;
import org.hawkular.metrics.sysconfig.ConfigurationService;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.hawkular.rx.cassandra.driver.RxSessionImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Completable;

public class JobsManager {
    private static Logger logger = LoggerFactory.getLogger(JobsManager.class);
    public static final String COMPRESS_DATA_JOB = "COMPRESS_DATA";
    private ConfigurationService configurationService;
    private Scheduler scheduler;

    public JobsManager(Session session) {
        RxSessionImpl rxSession = new RxSessionImpl(session);
        this.configurationService = new ConfigurationService();
        this.configurationService.init((RxSession)rxSession);
        this.scheduler = new SchedulerImpl((RxSession)rxSession, "localhost");
    }

    public List<JobDetails> installJobs() {
        logger.info("Installing scheduled jobs");
        this.unscheduleDeleteExpiredMetrics();
        ArrayList<JobDetails> backgroundJobs = new ArrayList<JobDetails>();
        this.maybeScheduleCompressData(backgroundJobs);
        return backgroundJobs;
    }

    private void unscheduleDeleteExpiredMetrics() {
        String jobName = "DELETE_EXPIRED_METRICS";
        String configId = "org.hawkular.metrics.jobs.DELETE_EXPIRED_METRICS";
        Completable deleteConfig = this.configurationService.load(configId).map(config -> this.configurationService.delete(configId)).toCompletable();
        Completable unscheduleJob = this.scheduler.unscheduleJobByTypeAndName(jobName, jobName);
        Completable.merge((Completable[])new Completable[]{deleteConfig, unscheduleJob}).await();
    }

    private void maybeScheduleCompressData(List<JobDetails> backgroundJobs) {
        String configId = "org.hawkular.metrics.jobs.COMPRESS_DATA";
        Configuration config = (Configuration)this.configurationService.load(configId).toBlocking().firstOrDefault((Object)new Configuration(configId, new HashMap<String, String>()));
        if (config.get("jobId") == null) {
            logger.info("Preparing to create and schedule COMPRESS_DATA job");
            long nextStart = LocalDateTime.now(ZoneOffset.UTC).with(DateTimeService.startOfNextOddHour()).toInstant(ZoneOffset.UTC).toEpochMilli();
            JobDetails jobDetails = (JobDetails)this.scheduler.scheduleJob(COMPRESS_DATA_JOB, COMPRESS_DATA_JOB, ImmutableMap.of(), new RepeatingTrigger.Builder().withTriggerTime(nextStart).withInterval(2, TimeUnit.HOURS).build()).toBlocking().value();
            backgroundJobs.add(jobDetails);
            this.configurationService.save(configId, "jobId", jobDetails.getJobId().toString()).toBlocking();
            logger.info("Created and scheduled " + jobDetails);
        }
    }
}

