/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerOptionFormatter;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.BenchmarkResultMetaData;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.HashMultimap;
import org.openjdk.jmh.util.HashMultiset;
import org.openjdk.jmh.util.Interval;
import org.openjdk.jmh.util.IntervalMap;
import org.openjdk.jmh.util.Multiset;
import org.openjdk.jmh.util.Multisets;

public abstract class AbstractPerfAsmProfiler
implements ExternalProfiler {
    protected final List<String> events;
    private final double regionRateThreshold;
    private final int regionShowTop;
    private final int regionTooBigThreshold;
    private final int printMargin;
    private final int mergeMargin;
    private final int delayMsec;
    private final boolean skipAssembly;
    private final boolean skipInterpreter;
    private final boolean skipVMStubs;
    private final boolean savePerfOutput;
    private final String savePerfOutputTo;
    private final String savePerfOutputToFile;
    private final boolean savePerfBin;
    private final String savePerfBinTo;
    private final String savePerfBinFile;
    private final boolean saveLog;
    private final String saveLogTo;
    private final String saveLogToFile;
    private final boolean printCompilationInfo;
    private final boolean intelSyntax;
    protected final String hsLog;
    protected final String perfBinData;
    protected final String perfParsedData;
    protected final OptionSet set;
    private final boolean drawIntraJumps;
    private final boolean drawInterJumps;

    protected AbstractPerfAsmProfiler(String initLine, String ... events) throws ProfilerException {
        try {
            this.hsLog = FileUtils.tempFile("hslog").getAbsolutePath();
            this.perfBinData = FileUtils.tempFile("perfbin").getAbsolutePath();
            this.perfParsedData = FileUtils.tempFile("perfparsed").getAbsolutePath();
        }
        catch (IOException e) {
            throw new ProfilerException(e);
        }
        OptionParser parser = new OptionParser();
        parser.formatHelpWith(new ProfilerOptionFormatter("perfasm"));
        ArgumentAcceptingOptionSpec<String> optEvents = parser.accepts("events", "Events to gather.").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",").describedAs("event").defaultsTo((String[])events);
        ArgumentAcceptingOptionSpec<Double> optThresholdRate = parser.accepts("hotThreshold", "Cutoff threshold for hot regions. The regions with event count over threshold would be expanded with detailed disassembly.").withRequiredArg().ofType(Double.class).describedAs("rate").defaultsTo(0.1, (Double[])new Double[0]);
        ArgumentAcceptingOptionSpec<Integer> optShowTop = parser.accepts("top", "Show this number of top hottest code regions.").withRequiredArg().ofType(Integer.class).describedAs("#").defaultsTo(20, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> optThreshold = parser.accepts("tooBigThreshold", "Cutoff threshold for large region. The region containing more than this number of lines would be truncated.").withRequiredArg().ofType(Integer.class).describedAs("lines").defaultsTo(1000, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> optPrintMargin = parser.accepts("printMargin", "Print margin. How many \"context\" lines without counters to show in each region.").withRequiredArg().ofType(Integer.class).describedAs("lines").defaultsTo(10, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> optMergeMargin = parser.accepts("mergeMargin", "Merge margin. The regions separated by less than the margin are merged.").withRequiredArg().ofType(Integer.class).describedAs("lines").defaultsTo(32, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Integer> optDelay = parser.accepts("delay", "Delay collection for a given time, in milliseconds; -1 to detect automatically.").withRequiredArg().ofType(Integer.class).describedAs("ms").defaultsTo(-1, (Integer[])new Integer[0]);
        ArgumentAcceptingOptionSpec<Boolean> optSkipAsm = parser.accepts("skipAsm", "Skip -XX:+PrintAssembly instrumentation.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> optSkipInterpreter = parser.accepts("skipInterpreter", "Skip printing out interpreter stubs. This may improve the parser performance at the expense of missing the resolution and disassembly of interpreter regions.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> optSkipVMStubs = parser.accepts("skipVMStubs", "Skip printing out VM stubs. This may improve the parser performance at the expense of missing the resolution and disassembly of VM stub regions.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> optPerfOut = parser.accepts("savePerf", "Save parsed perf output to file. Use this for debugging.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<String> optPerfOutTo = parser.accepts("savePerfTo", "Override the parsed perf output log location. This will use the unique file name per test. Use this for debugging.").withRequiredArg().ofType(String.class).describedAs("dir").defaultsTo(".", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> optPerfOutToFile = parser.accepts("savePerfToFile", "Override the perf output log filename. Use this for debugging.").withRequiredArg().ofType(String.class).describedAs("file");
        ArgumentAcceptingOptionSpec<Boolean> optPerfBin = parser.accepts("savePerfBin", "Save binary perf data to file. Use this for debugging.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<String> optPerfBinTo = parser.accepts("savePerfBinTo", "Override the binary perf data location. This will use the unique file name per test. Use this for debugging.").withRequiredArg().ofType(String.class).describedAs("dir").defaultsTo(".", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> optPerfBinToFile = parser.accepts("savePerfBinToFile", "Override the perf binary data filename. Use this for debugging.").withRequiredArg().ofType(String.class).describedAs("file");
        ArgumentAcceptingOptionSpec<Boolean> optSaveLog = parser.accepts("saveLog", "Save annotated Hotspot log to file.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<String> optSaveLogTo = parser.accepts("saveLogTo", "Override the annotated Hotspot log location. This will use the unique file name per test.").withRequiredArg().ofType(String.class).describedAs("dir").defaultsTo(".", (String[])new String[0]);
        ArgumentAcceptingOptionSpec<String> optSaveLogToFile = parser.accepts("saveLogToFile", "Override the annotated Hotspot log filename.").withRequiredArg().ofType(String.class).describedAs("file");
        ArgumentAcceptingOptionSpec<Boolean> optPrintCompilationInfo = parser.accepts("printCompilationInfo", "Print the collateral compilation information. Enabling this might corrupt the assembly output, see https://bugs.openjdk.java.net/browse/CODETOOLS-7901102.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> optIntelSyntax = parser.accepts("intelSyntax", "Should perfasm use intel syntax?").withRequiredArg().ofType(Boolean.class).describedAs("boolean").defaultsTo(false, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> optDrawIntraJumps = parser.accepts("drawIntraJumps", "Should perfasm draw jump arrows with the region?").withRequiredArg().ofType(Boolean.class).describedAs("boolean").defaultsTo(true, (Boolean[])new Boolean[0]);
        ArgumentAcceptingOptionSpec<Boolean> optDrawInterJumps = parser.accepts("drawInterJumps", "Should perfasm draw jump arrows out of the region?").withRequiredArg().ofType(Boolean.class).describedAs("boolean").defaultsTo(false, (Boolean[])new Boolean[0]);
        this.addMyOptions(parser);
        this.set = ProfilerUtils.parseInitLine(initLine, parser);
        try {
            this.events = this.set.valuesOf(optEvents);
            this.regionRateThreshold = this.set.valueOf(optThresholdRate);
            this.regionShowTop = this.set.valueOf(optShowTop);
            this.regionTooBigThreshold = this.set.valueOf(optThreshold);
            this.printMargin = this.set.valueOf(optPrintMargin);
            this.mergeMargin = this.set.valueOf(optMergeMargin);
            this.delayMsec = this.set.valueOf(optDelay);
            this.skipAssembly = this.set.valueOf(optSkipAsm);
            this.skipInterpreter = this.set.valueOf(optSkipInterpreter);
            this.skipVMStubs = this.set.valueOf(optSkipVMStubs);
            this.savePerfOutput = this.set.valueOf(optPerfOut);
            this.savePerfOutputTo = this.set.valueOf(optPerfOutTo);
            this.savePerfOutputToFile = this.set.valueOf(optPerfOutToFile);
            this.savePerfBin = this.set.valueOf(optPerfBin);
            this.savePerfBinTo = this.set.valueOf(optPerfBinTo);
            this.savePerfBinFile = this.set.valueOf(optPerfBinToFile);
            this.saveLog = this.set.valueOf(optSaveLog);
            this.saveLogTo = this.set.valueOf(optSaveLogTo);
            this.saveLogToFile = this.set.valueOf(optSaveLogToFile);
            this.intelSyntax = this.set.valueOf(optIntelSyntax);
            this.printCompilationInfo = this.set.valueOf(optPrintCompilationInfo);
            this.drawIntraJumps = this.set.valueOf(optDrawInterJumps);
            this.drawInterJumps = this.set.valueOf(optDrawIntraJumps);
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
    }

    protected abstract void addMyOptions(OptionParser var1);

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        if (!this.skipAssembly) {
            ArrayList<String> opts = new ArrayList<String>();
            opts.addAll(Arrays.asList("-XX:+UnlockDiagnosticVMOptions", "-XX:+LogCompilation", "-XX:LogFile=" + this.hsLog, "-XX:+PrintAssembly"));
            if (!this.skipInterpreter) {
                opts.add("-XX:+PrintInterpreter");
            }
            if (!this.skipVMStubs) {
                opts.add("-XX:+PrintNMethods");
                opts.add("-XX:+PrintNativeNMethods");
                opts.add("-XX:+PrintSignatureHandlers");
                opts.add("-XX:+PrintAdapterHandlers");
                opts.add("-XX:+PrintStubCode");
            }
            if (this.printCompilationInfo) {
                opts.add("-XX:+PrintCompilation");
                opts.add("-XX:+PrintInlining");
                opts.add("-XX:+TraceClassLoading");
            }
            if (this.intelSyntax) {
                opts.add("-XX:PrintAssemblyOptions=intel");
            }
            return opts;
        }
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        PerfResult result = this.processAssembly(br, stdOut, stdErr);
        return Collections.singleton(result);
    }

    @Override
    public boolean allowPrintOut() {
        return false;
    }

    @Override
    public boolean allowPrintErr() {
        return false;
    }

    protected abstract void parseEvents();

    protected abstract PerfEvents readEvents(double var1);

    protected abstract String perfBinaryExtension();

    /*
     * WARNING - void declaration
     */
    private PerfResult processAssembly(BenchmarkResult br, File stdOut, File stdErr) {
        long delayNs;
        this.parseEvents();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        Assembly assembly = this.readAssembly(new File(this.hsLog));
        if (assembly.size() > 0) {
            pw.printf("PrintAssembly processed: %d total address lines.%n", assembly.size());
        } else if (this.skipAssembly) {
            pw.println();
            pw.println("PrintAssembly skipped, Java methods are not resolved.");
            pw.println();
        } else {
            pw.println();
            pw.println("ERROR: No address lines detected in assembly capture, make sure your JDK is PrintAssembly-enabled:\n    https://wiki.openjdk.java.net/display/HotSpot/PrintAssembly");
            pw.println();
        }
        if (this.delayMsec == -1) {
            BenchmarkResultMetaData md = br.getMetadata();
            if (md != null) {
                delayNs = TimeUnit.MILLISECONDS.toNanos(md.getMeasurementTime() - md.getStartTime());
            } else {
                IterationParams wp = br.getParams().getWarmup();
                delayNs = (long)wp.getCount() * wp.getTime().convertTo(TimeUnit.NANOSECONDS) + TimeUnit.SECONDS.toNanos(1L);
            }
        } else {
            delayNs = TimeUnit.MILLISECONDS.toNanos(this.delayMsec);
        }
        double skipSec = 1.0 * (double)delayNs / (double)TimeUnit.SECONDS.toNanos(1L);
        final PerfEvents events = this.readEvents(skipSec);
        if (!events.isEmpty()) {
            pw.printf("Perf output processed (skipped %.3f seconds):%n", skipSec);
            int cnt = 1;
            for (String event : this.events) {
                pw.printf(" Column %d: %s (%d events)%n", cnt, event, events.get(event).size());
                ++cnt;
            }
            pw.println();
        } else {
            pw.println();
            pw.println("ERROR: No perf data, make sure \"perf stat echo 1\" is indeed working;\n or the collection delay is not running past the benchmark time.");
            pw.println();
        }
        List<Region> regions = this.makeRegions(assembly, events);
        final String mainEvent = this.events.get(0);
        Collections.sort(regions, new Comparator<Region>(){

            @Override
            public int compare(Region o1, Region o2) {
                return Long.valueOf(o2.getEventCount(events, mainEvent)).compareTo(o1.getEventCount(events, mainEvent));
            }
        });
        long threshold = (long)(this.regionRateThreshold * (double)events.getTotalEvents(mainEvent).longValue());
        boolean headerPrinted = false;
        int cnt = 1;
        for (Region region : regions) {
            if (region.getEventCount(events, mainEvent) <= threshold) continue;
            if (!headerPrinted) {
                pw.printf("Hottest code regions (>%.2f%% \"%s\" events):%n%n", this.regionRateThreshold * 100.0, mainEvent);
                headerPrinted = true;
            }
            this.printDottedLine(pw, "Hottest Region " + cnt);
            pw.printf("%s, %s (%d bytes) %n%n", region.desc().source(), region.desc().name(), region.end - region.begin);
            region.printCode(pw, events);
            this.printDottedLine(pw);
            for (String event : this.events) {
                AbstractPerfAsmProfiler.printLine(pw, events, event, region.getEventCount(events, event));
            }
            pw.println("<total for region " + cnt + ">");
            pw.println();
            ++cnt;
        }
        if (!headerPrinted) {
            pw.printf("WARNING: No hottest code region above the threshold (%.2f%%) for disassembly.%n", this.regionRateThreshold * 100.0);
            pw.println("Use \"hotThreshold\" profiler option to lower the filter threshold.");
            pw.println();
        }
        int lenSource = 0;
        for (Region r : regions) {
            lenSource = Math.max(lenSource, r.desc().source().length());
        }
        HashMultiset<String> hashMultiset = new HashMultiset<String>();
        HashMultiset<String> other = new HashMultiset<String>();
        this.printDottedLine(pw, "Hottest Regions");
        int shown = 0;
        for (Region region : regions) {
            if (shown++ < this.regionShowTop) {
                for (String event : this.events) {
                    AbstractPerfAsmProfiler.printLine(pw, events, event, region.getEventCount(events, event));
                }
                pw.printf("%" + lenSource + "s  %s (%d bytes) %n", region.desc().source(), region.desc().name(), region.end - region.begin);
            } else {
                for (String event : this.events) {
                    other.add(event, region.getEventCount(events, event));
                }
            }
            for (String event : this.events) {
                hashMultiset.add(event, region.getEventCount(events, event));
            }
        }
        if (regions.size() - this.regionShowTop > 0) {
            for (String string : this.events) {
                AbstractPerfAsmProfiler.printLine(pw, events, string, other.count(string));
            }
            pw.println("<...other " + (regions.size() - this.regionShowTop) + " warm regions...>");
        }
        this.printDottedLine(pw);
        for (String string : this.events) {
            AbstractPerfAsmProfiler.printLine(pw, events, string, hashMultiset.count(string));
        }
        pw.println("<totals>");
        pw.println();
        HashMap hashMap = new HashMap();
        HashMap methods = new HashMap();
        for (String string : this.events) {
            hashMap.put(string, new HashMultiset());
            methods.put(string, new HashMultiset());
        }
        for (Region region : regions) {
            for (String event : this.events) {
                long count = region.getEventCount(events, event);
                ((Multiset)methods.get(event)).add(region.desc(), count);
                ((Multiset)hashMap.get(event)).add(region.desc().source(), count);
            }
        }
        this.printDottedLine(pw, "Hottest Methods (after inlining)");
        Iterator<String> total2 = new HashMultiset<String>();
        HashMultiset<String> hashMultiset2 = new HashMultiset<String>();
        boolean bl = false;
        List<MethodDesc> top = Multisets.sortedDesc((Multiset)methods.get(mainEvent));
        for (MethodDesc m : top) {
            void var23_61;
            if (++var23_61 < this.regionShowTop) {
                for (String event : this.events) {
                    AbstractPerfAsmProfiler.printLine(pw, events, event, ((Multiset)methods.get(event)).count(m));
                }
                pw.printf("%" + lenSource + "s  %s %n", m.source(), m.name());
            } else {
                for (String event : this.events) {
                    hashMultiset2.add(event, ((Multiset)methods.get(event)).count(m));
                }
            }
            for (String event : this.events) {
                total2.add(event, ((Multiset)methods.get(event)).count(m));
            }
        }
        if (top.size() - this.regionShowTop > 0) {
            for (String event : this.events) {
                AbstractPerfAsmProfiler.printLine(pw, events, event, hashMultiset2.count(event));
            }
            pw.println("<...other " + (top.size() - this.regionShowTop) + " warm methods...>");
        }
        this.printDottedLine(pw);
        for (String event : this.events) {
            AbstractPerfAsmProfiler.printLine(pw, events, event, total2.count(event));
        }
        pw.println("<totals>");
        pw.println();
        this.printDottedLine(pw, "Distribution by Source");
        for (String string : Multisets.sortedDesc((Multiset)hashMap.get(mainEvent))) {
            for (String event : this.events) {
                AbstractPerfAsmProfiler.printLine(pw, events, event, ((Multiset)hashMap.get(event)).count(string));
            }
            pw.printf("%" + lenSource + "s%n", string);
        }
        this.printDottedLine(pw);
        for (String string : this.events) {
            AbstractPerfAsmProfiler.printLine(pw, events, string, ((Multiset)hashMap.get(string)).size());
        }
        pw.println("<totals>");
        pw.println();
        HashSet<Long> addrHistory = new HashSet<Long>();
        for (Long l : assembly.addressMap.keySet()) {
            if (addrHistory.add(l)) continue;
            pw.println("WARNING: Duplicate instruction addresses detected. This is probably due to compiler reusing\n the code arena for the new generated code. We can not differentiate between methods sharing\nthe same addresses, and therefore the profile might be wrong. Increasing generated code\nstorage might help.");
        }
        int sum = 0;
        for (Long l : events.totalCounts.values()) {
            sum = (int)((long)sum + l);
        }
        if (sum < 1000) {
            pw.println("WARNING: The perf event count is suspiciously low (" + sum + "). The performance data might be\ninaccurate or misleading. Try to do the profiling again, or tune up the sampling frequency.");
        }
        if (this.savePerfOutput) {
            String target = this.savePerfOutputToFile == null ? this.savePerfOutputTo + "/" + br.getParams().id() + ".perf" : this.savePerfOutputToFile;
            try {
                FileUtils.copy(this.perfParsedData, target);
                pw.println("Perf output saved to " + target);
            }
            catch (IOException iOException) {
                pw.println("Unable to save perf output to " + target);
            }
        }
        if (this.savePerfBin) {
            String target = this.savePerfBinFile == null ? this.savePerfBinTo + "/" + br.getParams().id() + this.perfBinaryExtension() : this.savePerfBinFile;
            try {
                FileUtils.copy(this.perfBinData, target);
                pw.println("Perf binary output saved to " + target);
            }
            catch (IOException iOException) {
                pw.println("Unable to save perf binary output to " + target);
            }
        }
        if (this.saveLog) {
            String target = this.saveLogToFile == null ? this.saveLogTo + "/" + br.getParams().id() + ".log" : this.saveLogToFile;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(target);
                PrintWriter printWriter = new PrintWriter(fileOutputStream);
                for (ASMLine line : assembly.lines) {
                    for (String event : this.events) {
                        long count = line.addr != null ? events.get(event).count(line.addr) : 0L;
                        AbstractPerfAsmProfiler.printLine(printWriter, events, event, count);
                    }
                    printWriter.println(line.code);
                }
                printWriter.flush();
                FileUtils.safelyClose(fileOutputStream);
                pw.println("Perf-annotated Hotspot log is saved to " + target);
            }
            catch (IOException iOException) {
                pw.println("Unable to save Hotspot log to " + target);
            }
        }
        pw.flush();
        pw.close();
        return new PerfResult(sw.toString());
    }

    private static void printLine(PrintWriter pw, PerfEvents events, String event, long count) {
        if (count > 0L) {
            pw.printf("%6.2f%%  ", 100.0 * (double)count / (double)events.getTotalEvents(event).longValue());
        } else {
            pw.printf("%9s", "");
        }
    }

    void printDottedLine(PrintWriter pw) {
        this.printDottedLine(pw, null);
    }

    void printDottedLine(PrintWriter pw, String header) {
        int HEADER_WIDTH = 100;
        pw.print("....");
        if (header != null) {
            header = "[" + header + "]";
            pw.print(header);
        } else {
            header = "";
        }
        for (int c = 0; c < 96 - header.length(); ++c) {
            pw.print(".");
        }
        pw.println();
    }

    List<Region> makeRegions(Assembly asms, PerfEvents events) {
        ArrayList<Region> regions = new ArrayList<Region>();
        SortedSet<Long> allAddrs = events.getAllAddresses();
        for (Interval intv : this.figureHotIntervals(allAddrs, allAddrs.first(), allAddrs.last())) {
            MethodDesc desc;
            SortedSet<Long> eventfulAddrs = allAddrs.subSet(intv.src, intv.dst + 1L);
            List<ASMLine> regionLines = asms.getLines(intv.src, intv.dst, this.printMargin);
            if (!regionLines.isEmpty()) {
                desc = asms.getMethod(intv.src);
                if (desc == null) {
                    desc = MethodDesc.unknown();
                }
                regions.add(new GeneratedRegion(this.events, asms, desc, intv.src, intv.dst, regionLines, eventfulAddrs, this.regionTooBigThreshold, this.drawIntraJumps, this.drawInterJumps));
                continue;
            }
            desc = events.getMethod(intv.src);
            if (desc == null) {
                desc = MethodDesc.unknown();
            }
            regions.add(new NativeRegion(desc, intv.src, intv.dst, eventfulAddrs));
        }
        return regions;
    }

    private List<Interval> figureHotIntervals(SortedSet<Long> allAddrs, long from, long to) {
        ArrayList<Interval> intervals = new ArrayList<Interval>();
        SortedSet<Long> addrs = allAddrs.subSet(from, to);
        long begAddr = addrs.first();
        long lastAddr = addrs.first();
        Iterator iterator = addrs.iterator();
        while (iterator.hasNext()) {
            long addr = (Long)iterator.next();
            if (addr - lastAddr > (long)this.mergeMargin) {
                intervals.add(new Interval(begAddr, lastAddr));
                begAddr = addr;
            }
            lastAddr = addr;
        }
        if (begAddr != lastAddr) {
            intervals.add(new Interval(begAddr, lastAddr));
        }
        return intervals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection<Collection<String>> splitAssembly(File stdOut) {
        FileReader in = null;
        try {
            String line;
            HashMultimap<Long, String> writerToLines = new HashMultimap<Long, String>();
            Long writerId = -1L;
            Pattern pWriterThread = Pattern.compile("(.*)<writer thread='(.*)'>(.*)");
            in = new FileReader(stdOut);
            BufferedReader br = new BufferedReader(in);
            while ((line = br.readLine()) != null) {
                if (line.contains("<writer thread=")) {
                    Matcher m = pWriterThread.matcher(line);
                    if (!m.matches()) continue;
                    try {
                        writerId = Long.valueOf(m.group(2));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                writerToLines.put(writerId, line);
            }
            ArrayList r = new ArrayList();
            Object object = writerToLines.keys().iterator();
            while (object.hasNext()) {
                long id = (Long)object.next();
                r.add(writerToLines.get(id));
            }
            object = r;
            return object;
        }
        catch (IOException e) {
            List<Collection<String>> list = Collections.emptyList();
            return list;
        }
        finally {
            FileUtils.safelyClose(in);
        }
    }

    Assembly readAssembly(File stdOut) {
        ArrayList<ASMLine> lines = new ArrayList<ASMLine>();
        TreeMap<Long, Integer> addressMap = new TreeMap<Long, Integer>();
        IntervalMap<MethodDesc> stubs = new IntervalMap<MethodDesc>();
        IntervalMap<MethodDesc> javaMethods = new IntervalMap<MethodDesc>();
        HashSet<Interval> intervals = new HashSet<Interval>();
        for (Collection<String> cs : this.splitAssembly(stdOut)) {
            String prevLine = "";
            for (String line : cs) {
                Matcher matcher;
                Pattern pattern;
                Matcher matcher2;
                String trim = line.trim();
                if (trim.isEmpty()) continue;
                String[] elements = trim.split(" ");
                ASMLine asmLine = new ASMLine(line);
                if (trim.startsWith("0x")) {
                    try {
                        Long addr = this.parseAddress(elements[0]);
                        int idx = lines.size();
                        addressMap.put(addr, idx);
                        asmLine = new ASMLine(addr, line);
                        if (elements.length > 1 && (this.drawInterJumps || this.drawIntraJumps)) {
                            for (int c = 1; c < elements.length; ++c) {
                                if (!elements[c].startsWith("0x")) continue;
                                try {
                                    Long target = this.parseAddress(elements[c]);
                                    intervals.add(new Interval(addr, target));
                                    continue;
                                }
                                catch (NumberFormatException target) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    catch (NumberFormatException addr) {
                        // empty catch block
                    }
                }
                if ((prevLine.contains("--------") || line.contains("StubRoutines::")) && (matcher2 = (pattern = Pattern.compile("(.+)( +)\\[(.+), (.+)[\\]\\[](.*)")).matcher(line)).matches()) {
                    Long startAddr = this.parseAddress(matcher2.group(3));
                    Long endAddr = this.parseAddress(matcher2.group(4));
                    if (line.contains("StubRoutines::")) {
                        stubs.add(MethodDesc.runtimeStub(matcher2.group(1)), startAddr, endAddr);
                    } else {
                        stubs.add(MethodDesc.interpreter(matcher2.group(1)), startAddr, endAddr);
                    }
                }
                if (line.contains("<nmethod") && (matcher = Pattern.compile("(.*?)<nmethod (.*?)/>(.*?)").matcher(line)).matches()) {
                    String body = matcher.group(2);
                    body = body.replaceAll("='", "=");
                    String[] kvs = body.split("' ");
                    HashMap<String, String> map = new HashMap<String, String>();
                    for (String kv : kvs) {
                        String[] pair = kv.split("=");
                        map.put(pair[0], pair[1]);
                    }
                    Long addr = this.parseAddress((String)map.get("entry"));
                    javaMethods.add(MethodDesc.javaMethod((String)map.get("method"), (String)map.get("compiler"), (String)map.get("level"), (String)map.get("compile_id")), addr, addr + Long.valueOf((String)map.get("size")));
                }
                lines.add(asmLine);
                prevLine = line;
            }
        }
        IntervalMap<MethodDesc> methodMap = new IntervalMap<MethodDesc>();
        methodMap.merge(stubs);
        methodMap.merge(javaMethods);
        return new Assembly(lines, addressMap, methodMap, intervals);
    }

    private Long parseAddress(String address) {
        return Long.valueOf(address.replace("0x", "").replace(":", ""), 16);
    }

    static class MethodDesc {
        private final String name;
        private final String source;

        protected MethodDesc(String name, String source) {
            this.name = name;
            this.source = source;
        }

        public static MethodDesc unresolved() {
            return new MethodDesc("<unresolved>", "");
        }

        public static MethodDesc unknown() {
            return new MethodDesc("<unknown>", "");
        }

        public static MethodDesc kernel() {
            return new MethodDesc("<kernel>", "kernel");
        }

        public static MethodDesc interpreter(String name) {
            return new MethodDesc(name, "interpreter");
        }

        public static MethodDesc runtimeStub(String name) {
            return new MethodDesc(name, "runtime stub");
        }

        public static MethodDesc javaMethod(String name, String compiler, String level, String ver) {
            String methodName = name.replace("/", ".").replaceFirst(" ", "::").split(" ")[0];
            return new MethodDesc(methodName + ", version " + ver, (compiler != null ? compiler : "Unknown") + (level != null ? ", level " + level : ""));
        }

        public static MethodDesc nativeMethod(String symbol, String lib) {
            return new MethodDesc(symbol, lib);
        }

        public String name() {
            return this.name;
        }

        public String source() {
            return this.source;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodDesc that = (MethodDesc)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.source.equals(that.source);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.source.hashCode();
            return result;
        }

        public String toString() {
            return "MethodDesc{name='" + this.name + '\'' + ", source='" + this.source + '\'' + '}';
        }
    }

    static class UnknownRegion
    extends Region {
        UnknownRegion() {
            super(MethodDesc.unknown(), 0L, 0L, Collections.singleton(0L));
        }

        @Override
        public void printCode(PrintWriter pw, PerfEvents events) {
            pw.println(" <no assembly is recorded, unknown region>");
        }
    }

    static class NativeRegion
    extends Region {
        NativeRegion(MethodDesc desc, long begin, long end, Set<Long> eventfulAddrs) {
            super(desc, begin, end, eventfulAddrs);
        }

        @Override
        public void printCode(PrintWriter pw, PerfEvents events) {
            pw.println(" <no assembly is recorded, native region>");
        }
    }

    static class GeneratedRegion
    extends Region {
        final Collection<String> tracedEvents;
        final Assembly asms;
        final Collection<ASMLine> code;
        final int threshold;
        final boolean drawIntraJumps;
        final boolean drawInterJumps;

        GeneratedRegion(Collection<String> tracedEvents, Assembly asms, MethodDesc desc, long begin, long end, Collection<ASMLine> code, Set<Long> eventfulAddrs, int threshold, boolean drawIntraJumps, boolean drawInterJumps) {
            super(desc, begin, end, eventfulAddrs);
            this.tracedEvents = tracedEvents;
            this.asms = asms;
            this.code = code;
            this.threshold = threshold;
            this.drawIntraJumps = drawIntraJumps;
            this.drawInterJumps = drawInterJumps;
        }

        @Override
        public void printCode(PrintWriter pw, PerfEvents events) {
            if (this.code.size() > this.threshold) {
                pw.printf(" <region is too big to display, has %d lines, but threshold is %d>%n", this.code.size(), this.threshold);
            } else {
                long beginLine = this.begin;
                long endLine = this.end;
                for (ASMLine line : this.code) {
                    Long addr = line.addr;
                    if (addr == null) continue;
                    beginLine = Math.min(beginLine, addr);
                    endLine = Math.max(endLine, addr);
                }
                TreeSet<Interval> interIvs = new TreeSet<Interval>();
                TreeSet<Interval> intraIvs = new TreeSet<Interval>();
                for (Interval it : this.asms.intervals) {
                    boolean dstInline;
                    boolean srcInline = beginLine < it.src && it.src < endLine;
                    boolean bl = dstInline = beginLine < it.dst && it.dst < endLine;
                    if (srcInline && dstInline) {
                        if (!this.drawInterJumps) continue;
                        interIvs.add(it);
                        continue;
                    }
                    if (!srcInline && !dstInline || !this.drawIntraJumps) continue;
                    intraIvs.add(it);
                }
                long prevAddr = 0L;
                for (ASMLine line : this.code) {
                    long evAddr;
                    long addr;
                    for (String event : this.tracedEvents) {
                        long count = line.addr != null ? events.get(event).count(line.addr) : 0L;
                        AbstractPerfAsmProfiler.printLine(pw, events, event, count);
                    }
                    if (line.addr == null) {
                        addr = prevAddr;
                        evAddr = -1L;
                    } else {
                        evAddr = addr = line.addr.longValue();
                        prevAddr = addr;
                    }
                    for (Interval it : intraIvs) {
                        this.printInterval(pw, it, addr, evAddr, false);
                    }
                    for (Interval it : interIvs) {
                        this.printInterval(pw, it, addr, evAddr, true);
                    }
                    pw.println(line.code);
                }
            }
        }

        private void printInterval(PrintWriter pw, Interval it, long addr, long evAddr, boolean inline) {
            if (it.src < it.dst) {
                if (it.src == evAddr) {
                    pw.print("\u256d");
                } else if (it.dst == evAddr) {
                    pw.print("\u2198");
                } else if (it.src <= addr && addr < it.dst) {
                    if (inline) {
                        pw.print("\u2502");
                    } else {
                        pw.print("\u2575");
                    }
                } else {
                    pw.print(" ");
                }
            } else if (it.src == evAddr) {
                pw.print("\u2570");
            } else if (it.dst == evAddr) {
                pw.print("\u2197");
            } else if (it.dst <= addr && addr < it.src) {
                if (inline) {
                    pw.print("\u2502");
                } else {
                    pw.print("\u2575");
                }
            } else {
                pw.print(" ");
            }
        }
    }

    static class Region {
        final MethodDesc method;
        final long begin;
        final long end;
        final Set<Long> eventfulAddrs;
        final Map<String, Long> eventCountCache;

        Region(MethodDesc method, long begin, long end, Set<Long> eventfulAddrs) {
            this.method = method;
            this.begin = begin;
            this.end = end;
            this.eventfulAddrs = eventfulAddrs;
            this.eventCountCache = new HashMap<String, Long>();
        }

        long getEventCount(PerfEvents events, String event) {
            if (!this.eventCountCache.containsKey(event)) {
                Multiset<Long> evs = events.get(event);
                long count = 0L;
                for (Long addr : this.eventfulAddrs) {
                    count += evs.count(addr);
                }
                this.eventCountCache.put(event, count);
            }
            return this.eventCountCache.get(event);
        }

        public void printCode(PrintWriter pw, PerfEvents events) {
            pw.println("<no code>");
        }

        public MethodDesc desc() {
            return this.method;
        }
    }

    static class ASMLine {
        final Long addr;
        final String code;

        ASMLine(String code) {
            this(null, code);
        }

        ASMLine(Long addr, String code) {
            this.addr = addr;
            this.code = code;
        }
    }

    static class Assembly {
        final List<ASMLine> lines;
        final SortedMap<Long, Integer> addressMap;
        final IntervalMap<MethodDesc> methodMap;
        final Set<Interval> intervals;

        public Assembly(List<ASMLine> lines, SortedMap<Long, Integer> addressMap, IntervalMap<MethodDesc> methodMap, Set<Interval> intervals) {
            this.lines = lines;
            this.addressMap = addressMap;
            this.methodMap = methodMap;
            this.intervals = intervals;
        }

        public int size() {
            return this.addressMap.size();
        }

        public List<ASMLine> getLines(long begin, long end, int window) {
            SortedMap<Long, Integer> tailMap = this.addressMap.tailMap(begin);
            if (tailMap.isEmpty()) {
                return Collections.emptyList();
            }
            Long beginAddr = tailMap.firstKey();
            Integer beginIdx = (Integer)this.addressMap.get(beginAddr);
            SortedMap<Long, Integer> headMap = this.addressMap.headMap(end);
            if (headMap.isEmpty()) {
                return Collections.emptyList();
            }
            Long endAddr = headMap.lastKey();
            Integer endIdx = (Integer)this.addressMap.get(endAddr);
            beginIdx = Math.max(0, beginIdx - window);
            endIdx = Math.min(this.lines.size(), endIdx + 2 + window);
            if (beginIdx < endIdx) {
                return this.lines.subList(beginIdx, endIdx);
            }
            return Collections.emptyList();
        }

        public MethodDesc getMethod(long addr) {
            return this.methodMap.get(addr);
        }
    }

    protected static class PerfEvents {
        final Map<String, Multiset<Long>> events;
        final IntervalMap<MethodDesc> methods;
        final Map<String, Long> totalCounts;

        PerfEvents(Collection<String> tracedEvents, Map<String, Multiset<Long>> events, IntervalMap<MethodDesc> methods) {
            this.events = events;
            this.methods = methods;
            this.totalCounts = new HashMap<String, Long>();
            for (String event : tracedEvents) {
                this.totalCounts.put(event, events.get(event).size());
            }
        }

        public PerfEvents(Collection<String> tracedEvents) {
            this(tracedEvents, Collections.emptyMap(), new IntervalMap<MethodDesc>());
        }

        public boolean isEmpty() {
            return this.events.isEmpty();
        }

        public Multiset<Long> get(String event) {
            return this.events.get(event);
        }

        public SortedSet<Long> getAllAddresses() {
            TreeSet<Long> addrs = new TreeSet<Long>();
            for (Multiset<Long> e : this.events.values()) {
                addrs.addAll(e.keys());
            }
            return addrs;
        }

        public Long getTotalEvents(String event) {
            return this.totalCounts.get(event);
        }

        public MethodDesc getMethod(long addr) {
            return this.methods.get(addr);
        }
    }

    static class PerfResultAggregator
    implements Aggregator<PerfResult> {
        PerfResultAggregator() {
        }

        @Override
        public PerfResult aggregate(Collection<PerfResult> results) {
            String output = "";
            for (PerfResult r : results) {
                output = output + r.output;
            }
            return new PerfResult(output);
        }
    }

    static class PerfResult
    extends Result<PerfResult> {
        private static final long serialVersionUID = 6871141606856800453L;
        private final String output;

        public PerfResult(String output) {
            super(ResultRole.SECONDARY, "\u00b7asm", PerfResult.of(Double.NaN), "---", AggregationPolicy.AVG);
            this.output = output;
        }

        @Override
        protected Aggregator<PerfResult> getThreadAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        protected Aggregator<PerfResult> getIterationAggregator() {
            return new PerfResultAggregator();
        }

        @Override
        public String toString() {
            return "(text only)";
        }

        @Override
        public String extendedInfo() {
            return this.output;
        }
    }
}

