/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hadoop.cql3;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TupleValue;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.UDTValue;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.dht.IPartitioner;
import org.apache.cassandra.hadoop.ColumnFamilySplit;
import org.apache.cassandra.hadoop.ConfigHelper;
import org.apache.cassandra.hadoop.HadoopCompat;
import org.apache.cassandra.hadoop.cql3.CqlConfigHelper;
import org.apache.cassandra.utils.AbstractIterator;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.cassandra.utils.Pair;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CqlRecordReader
extends RecordReader<Long, Row>
implements org.apache.hadoop.mapred.RecordReader<Long, Row>,
AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(CqlRecordReader.class);
    private ColumnFamilySplit split;
    private RowIterator rowIterator;
    private Pair<Long, Row> currentRow;
    private int totalRowCount;
    private String keyspace;
    private String cfName;
    private String cqlQuery;
    private Cluster cluster;
    private Session session;
    private IPartitioner partitioner;
    private String inputColumns;
    private String userDefinedWhereClauses;
    private List<String> partitionKeys = new ArrayList<String>();
    private LinkedHashMap<String, Boolean> partitionBoundColumns = Maps.newLinkedHashMap();
    protected int nativeProtocolVersion = 1;

    public void initialize(InputSplit split, TaskAttemptContext context) throws IOException {
        this.split = (ColumnFamilySplit)split;
        Configuration conf = HadoopCompat.getConfiguration((JobContext)context);
        this.totalRowCount = this.split.getLength() < Long.MAX_VALUE ? (int)this.split.getLength() : ConfigHelper.getInputSplitSize(conf);
        this.cfName = ConfigHelper.getInputColumnFamily(conf);
        this.keyspace = ConfigHelper.getInputKeyspace(conf);
        this.partitioner = ConfigHelper.getInputPartitioner(conf);
        this.inputColumns = CqlConfigHelper.getInputcolumns(conf);
        this.userDefinedWhereClauses = CqlConfigHelper.getInputWhereClauses(conf);
        try {
            if (this.cluster != null) {
                return;
            }
            String[] locations = split.getLocations();
            this.cluster = CqlConfigHelper.getInputCluster(locations, conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.cluster != null) {
            this.session = this.cluster.connect(this.quote(this.keyspace));
        }
        if (this.session == null) {
            throw new RuntimeException("Can't create connection session");
        }
        this.nativeProtocolVersion = this.cluster.getConfiguration().getProtocolOptions().getProtocolVersion().toInt();
        this.cqlQuery = CqlConfigHelper.getInputCql(conf);
        if (StringUtils.isNotEmpty(this.cqlQuery) && (StringUtils.isNotEmpty(this.inputColumns) || StringUtils.isNotEmpty(this.userDefinedWhereClauses))) {
            throw new AssertionError((Object)"Cannot define a custom query with input columns and / or where clauses");
        }
        if (StringUtils.isEmpty(this.cqlQuery)) {
            this.cqlQuery = this.buildQuery();
        }
        logger.trace("cqlQuery {}", (Object)this.cqlQuery);
        this.rowIterator = new RowIterator();
        logger.trace("created {}", (Object)this.rowIterator);
    }

    @Override
    public void close() {
        if (this.session != null) {
            this.session.close();
        }
        if (this.cluster != null) {
            this.cluster.close();
        }
    }

    public Long getCurrentKey() {
        return (Long)this.currentRow.left;
    }

    public Row getCurrentValue() {
        return (Row)this.currentRow.right;
    }

    public float getProgress() {
        if (!this.rowIterator.hasNext()) {
            return 1.0f;
        }
        float progress = (float)this.rowIterator.totalRead / (float)this.totalRowCount;
        return progress > 1.0f ? 1.0f : progress;
    }

    public boolean nextKeyValue() throws IOException {
        if (!this.rowIterator.hasNext()) {
            logger.trace("Finished scanning {} rows (estimate was: {})", (Object)this.rowIterator.totalRead, (Object)this.totalRowCount);
            return false;
        }
        try {
            this.currentRow = (Pair)this.rowIterator.next();
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(ioe.getCause());
            throw ioe;
        }
        return true;
    }

    public boolean next(Long key, Row value) throws IOException {
        if (this.nextKeyValue()) {
            ((WrappedRow)value).setRow(this.getCurrentValue());
            return true;
        }
        return false;
    }

    public long getPos() throws IOException {
        return this.rowIterator.totalRead;
    }

    public Long createKey() {
        return 0L;
    }

    public Row createValue() {
        return new WrappedRow();
    }

    public int getNativeProtocolVersion() {
        return this.nativeProtocolVersion;
    }

    private String buildQuery() {
        this.fetchKeys();
        List<String> columns = this.getSelectColumns();
        String selectColumnList = columns.size() == 0 ? "*" : this.makeColumnList(columns);
        String partitionKeyList = this.makeColumnList(this.partitionKeys);
        return String.format("SELECT %s FROM %s.%s WHERE token(%s)>? AND token(%s)<=?" + this.getAdditionalWhereClauses(), selectColumnList, this.quote(this.keyspace), this.quote(this.cfName), partitionKeyList, partitionKeyList);
    }

    private String getAdditionalWhereClauses() {
        String whereClause = "";
        if (StringUtils.isNotEmpty(this.userDefinedWhereClauses)) {
            whereClause = whereClause + " AND " + this.userDefinedWhereClauses;
        }
        if (StringUtils.isNotEmpty(this.userDefinedWhereClauses)) {
            whereClause = whereClause + " ALLOW FILTERING";
        }
        return whereClause;
    }

    private List<String> getSelectColumns() {
        ArrayList<String> selectColumns = new ArrayList<String>();
        if (StringUtils.isNotEmpty(this.inputColumns)) {
            selectColumns.addAll(this.partitionKeys);
            for (String column : Splitter.on(',').split(this.inputColumns)) {
                if (this.partitionKeys.contains(column)) continue;
                selectColumns.add(column);
            }
        }
        return selectColumns;
    }

    private String makeColumnList(Collection<String> columns) {
        return Joiner.on(',').join(Iterables.transform(columns, new Function<String, String>(){

            @Override
            public String apply(String column) {
                return CqlRecordReader.this.quote(column);
            }
        }));
    }

    private void fetchKeys() {
        TableMetadata tableMetadata = this.session.getCluster().getMetadata().getKeyspace(Metadata.quote(this.keyspace)).getTable(Metadata.quote(this.cfName));
        if (tableMetadata == null) {
            throw new RuntimeException("No table metadata found for " + this.keyspace + "." + this.cfName);
        }
        for (ColumnMetadata partitionKey : tableMetadata.getPartitionKey()) {
            this.partitionKeys.add(partitionKey.getName());
        }
    }

    private String quote(String identifier) {
        return "\"" + identifier.replaceAll("\"", "\"\"") + "\"";
    }

    private static class WrappedRow
    implements Row {
        private Row row;

        private WrappedRow() {
        }

        public void setRow(Row row) {
            this.row = row;
        }

        @Override
        public ColumnDefinitions getColumnDefinitions() {
            return this.row.getColumnDefinitions();
        }

        @Override
        public boolean isNull(int i) {
            return this.row.isNull(i);
        }

        @Override
        public boolean isNull(String name) {
            return this.row.isNull(name);
        }

        @Override
        public Object getObject(int i) {
            return this.row.getObject(i);
        }

        @Override
        public <T> T get(int i, Class<T> aClass) {
            return this.row.get(i, aClass);
        }

        @Override
        public <T> T get(int i, TypeToken<T> typeToken) {
            return this.row.get(i, typeToken);
        }

        @Override
        public <T> T get(int i, TypeCodec<T> typeCodec) {
            return this.row.get(i, typeCodec);
        }

        @Override
        public Object getObject(String s) {
            return this.row.getObject(s);
        }

        @Override
        public <T> T get(String s, Class<T> aClass) {
            return this.row.get(s, aClass);
        }

        @Override
        public <T> T get(String s, TypeToken<T> typeToken) {
            return this.row.get(s, typeToken);
        }

        @Override
        public <T> T get(String s, TypeCodec<T> typeCodec) {
            return this.row.get(s, typeCodec);
        }

        @Override
        public boolean getBool(int i) {
            return this.row.getBool(i);
        }

        @Override
        public boolean getBool(String name) {
            return this.row.getBool(name);
        }

        @Override
        public short getShort(int i) {
            return this.row.getShort(i);
        }

        @Override
        public short getShort(String s) {
            return this.row.getShort(s);
        }

        @Override
        public byte getByte(int i) {
            return this.row.getByte(i);
        }

        @Override
        public byte getByte(String s) {
            return this.row.getByte(s);
        }

        @Override
        public int getInt(int i) {
            return this.row.getInt(i);
        }

        @Override
        public int getInt(String name) {
            return this.row.getInt(name);
        }

        @Override
        public long getLong(int i) {
            return this.row.getLong(i);
        }

        @Override
        public long getLong(String name) {
            return this.row.getLong(name);
        }

        @Override
        public Date getTimestamp(int i) {
            return this.row.getTimestamp(i);
        }

        @Override
        public Date getTimestamp(String s) {
            return this.row.getTimestamp(s);
        }

        @Override
        public LocalDate getDate(int i) {
            return this.row.getDate(i);
        }

        @Override
        public LocalDate getDate(String s) {
            return this.row.getDate(s);
        }

        @Override
        public long getTime(int i) {
            return this.row.getTime(i);
        }

        @Override
        public long getTime(String s) {
            return this.row.getTime(s);
        }

        @Override
        public float getFloat(int i) {
            return this.row.getFloat(i);
        }

        @Override
        public float getFloat(String name) {
            return this.row.getFloat(name);
        }

        @Override
        public double getDouble(int i) {
            return this.row.getDouble(i);
        }

        @Override
        public double getDouble(String name) {
            return this.row.getDouble(name);
        }

        @Override
        public ByteBuffer getBytesUnsafe(int i) {
            return this.row.getBytesUnsafe(i);
        }

        @Override
        public ByteBuffer getBytesUnsafe(String name) {
            return this.row.getBytesUnsafe(name);
        }

        @Override
        public ByteBuffer getBytes(int i) {
            return this.row.getBytes(i);
        }

        @Override
        public ByteBuffer getBytes(String name) {
            return this.row.getBytes(name);
        }

        @Override
        public String getString(int i) {
            return this.row.getString(i);
        }

        @Override
        public String getString(String name) {
            return this.row.getString(name);
        }

        @Override
        public BigInteger getVarint(int i) {
            return this.row.getVarint(i);
        }

        @Override
        public BigInteger getVarint(String name) {
            return this.row.getVarint(name);
        }

        @Override
        public BigDecimal getDecimal(int i) {
            return this.row.getDecimal(i);
        }

        @Override
        public BigDecimal getDecimal(String name) {
            return this.row.getDecimal(name);
        }

        @Override
        public UUID getUUID(int i) {
            return this.row.getUUID(i);
        }

        @Override
        public UUID getUUID(String name) {
            return this.row.getUUID(name);
        }

        @Override
        public InetAddress getInet(int i) {
            return this.row.getInet(i);
        }

        @Override
        public InetAddress getInet(String name) {
            return this.row.getInet(name);
        }

        @Override
        public <T> List<T> getList(int i, Class<T> elementsClass) {
            return this.row.getList(i, elementsClass);
        }

        @Override
        public <T> List<T> getList(int i, TypeToken<T> typeToken) {
            return this.row.getList(i, typeToken);
        }

        @Override
        public <T> List<T> getList(String name, Class<T> elementsClass) {
            return this.row.getList(name, elementsClass);
        }

        @Override
        public <T> List<T> getList(String s, TypeToken<T> typeToken) {
            return this.row.getList(s, typeToken);
        }

        @Override
        public <T> Set<T> getSet(int i, Class<T> elementsClass) {
            return this.row.getSet(i, elementsClass);
        }

        @Override
        public <T> Set<T> getSet(int i, TypeToken<T> typeToken) {
            return this.row.getSet(i, typeToken);
        }

        @Override
        public <T> Set<T> getSet(String name, Class<T> elementsClass) {
            return this.row.getSet(name, elementsClass);
        }

        @Override
        public <T> Set<T> getSet(String s, TypeToken<T> typeToken) {
            return this.row.getSet(s, typeToken);
        }

        @Override
        public <K, V> Map<K, V> getMap(int i, Class<K> keysClass, Class<V> valuesClass) {
            return this.row.getMap(i, keysClass, valuesClass);
        }

        @Override
        public <K, V> Map<K, V> getMap(int i, TypeToken<K> typeToken, TypeToken<V> typeToken1) {
            return this.row.getMap(i, typeToken, typeToken1);
        }

        @Override
        public <K, V> Map<K, V> getMap(String name, Class<K> keysClass, Class<V> valuesClass) {
            return this.row.getMap(name, keysClass, valuesClass);
        }

        @Override
        public <K, V> Map<K, V> getMap(String s, TypeToken<K> typeToken, TypeToken<V> typeToken1) {
            return this.row.getMap(s, typeToken, typeToken1);
        }

        @Override
        public UDTValue getUDTValue(int i) {
            return this.row.getUDTValue(i);
        }

        @Override
        public UDTValue getUDTValue(String name) {
            return this.row.getUDTValue(name);
        }

        @Override
        public TupleValue getTupleValue(int i) {
            return this.row.getTupleValue(i);
        }

        @Override
        public TupleValue getTupleValue(String name) {
            return this.row.getTupleValue(name);
        }

        @Override
        public Token getToken(int i) {
            return this.row.getToken(i);
        }

        @Override
        public Token getToken(String name) {
            return this.row.getToken(name);
        }

        @Override
        public Token getPartitionKeyToken() {
            return this.row.getPartitionKeyToken();
        }
    }

    private class RowIterator
    extends AbstractIterator<Pair<Long, Row>> {
        private long keyId = 0L;
        protected int totalRead = 0;
        protected Iterator<Row> rows;
        private Map<String, ByteBuffer> previousRowKey = new HashMap<String, ByteBuffer>();

        public RowIterator() {
            AbstractType<?> type = CqlRecordReader.this.partitioner.getTokenValidator();
            ResultSet rs = CqlRecordReader.this.session.execute(CqlRecordReader.this.cqlQuery, type.compose(type.fromString(CqlRecordReader.this.split.getStartToken())), type.compose(type.fromString(CqlRecordReader.this.split.getEndToken())));
            for (ColumnMetadata meta : CqlRecordReader.this.cluster.getMetadata().getKeyspace(CqlRecordReader.this.quote(CqlRecordReader.this.keyspace)).getTable(CqlRecordReader.this.quote(CqlRecordReader.this.cfName)).getPartitionKey()) {
                CqlRecordReader.this.partitionBoundColumns.put(meta.getName(), Boolean.TRUE);
            }
            this.rows = rs.iterator();
        }

        @Override
        protected Pair<Long, Row> computeNext() {
            if (this.rows == null || !this.rows.hasNext()) {
                return (Pair)this.endOfData();
            }
            Row row = this.rows.next();
            HashMap<String, ByteBuffer> keyColumns = new HashMap<String, ByteBuffer>(CqlRecordReader.this.partitionBoundColumns.size());
            for (String column : CqlRecordReader.this.partitionBoundColumns.keySet()) {
                keyColumns.put(column, row.getBytesUnsafe(column));
            }
            if (this.previousRowKey.isEmpty() && !keyColumns.isEmpty()) {
                this.previousRowKey = keyColumns;
                ++this.totalRead;
            } else {
                for (String column : CqlRecordReader.this.partitionBoundColumns.keySet()) {
                    if (ByteBufferUtil.compareUnsigned((ByteBuffer)keyColumns.get(column), this.previousRowKey.get(column)) == 0) continue;
                    this.previousRowKey = keyColumns;
                    ++this.totalRead;
                    break;
                }
            }
            ++this.keyId;
            return Pair.create(this.keyId, row);
        }
    }
}

