/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.hints;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.SystemKeyspace;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;

public final class Hint {
    public static final Serializer serializer = new Serializer();
    final Mutation mutation;
    final long creationTime;
    final int gcgs;

    private Hint(Mutation mutation, long creationTime, int gcgs) {
        this.mutation = mutation;
        this.creationTime = creationTime;
        this.gcgs = gcgs;
    }

    public static Hint create(Mutation mutation, long creationTime) {
        return new Hint(mutation, creationTime, mutation.smallestGCGS());
    }

    public static Hint create(Mutation mutation, long creationTime, int gcgs) {
        return new Hint(mutation, creationTime, gcgs);
    }

    CompletableFuture<?> applyFuture() {
        if (this.isLive()) {
            Mutation filtered = this.mutation;
            for (UUID id : this.mutation.getColumnFamilyIds()) {
                if (this.creationTime > SystemKeyspace.getTruncatedAt(id)) continue;
                filtered = filtered.without(id);
            }
            if (!filtered.isEmpty()) {
                return filtered.applyFuture();
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    void apply() {
        try {
            this.applyFuture().get();
        }
        catch (Exception e) {
            throw Throwables.propagate(e.getCause());
        }
    }

    boolean isLive() {
        int smallestGCGS = Math.min(this.gcgs, this.mutation.smallestGCGS());
        long expirationTime = this.creationTime + TimeUnit.SECONDS.toMillis(smallestGCGS);
        return expirationTime > System.currentTimeMillis();
    }

    static final class Serializer
    implements IVersionedSerializer<Hint> {
        Serializer() {
        }

        @Override
        public long serializedSize(Hint hint, int version) {
            long size = TypeSizes.sizeof(hint.creationTime);
            size += (long)TypeSizes.sizeofUnsignedVInt(hint.gcgs);
            return size += Mutation.serializer.serializedSize(hint.mutation, version);
        }

        @Override
        public void serialize(Hint hint, DataOutputPlus out, int version) throws IOException {
            out.writeLong(hint.creationTime);
            out.writeUnsignedVInt(hint.gcgs);
            Mutation.serializer.serialize(hint.mutation, out, version);
        }

        @Override
        public Hint deserialize(DataInputPlus in, int version) throws IOException {
            long creationTime = in.readLong();
            int gcgs = (int)in.readUnsignedVInt();
            return new Hint(Mutation.serializer.deserialize(in, version), creationTime, gcgs);
        }
    }
}

