/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.cassandra.auth.AllowAllAuthorizer;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.auth.DataResource;
import org.apache.cassandra.auth.FunctionResource;
import org.apache.cassandra.auth.IResource;
import org.apache.cassandra.auth.Permission;
import org.apache.cassandra.auth.Resources;
import org.apache.cassandra.config.Config;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.cql3.QueryHandler;
import org.apache.cassandra.cql3.QueryProcessor;
import org.apache.cassandra.cql3.functions.Function;
import org.apache.cassandra.exceptions.AuthenticationException;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.exceptions.UnauthorizedException;
import org.apache.cassandra.schema.SchemaKeyspace;
import org.apache.cassandra.thrift.ThriftValidation;
import org.apache.cassandra.utils.CassandraVersion;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.JVMStabilityInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientState {
    private static final Logger logger = LoggerFactory.getLogger(ClientState.class);
    public static final CassandraVersion DEFAULT_CQL_VERSION = QueryProcessor.CQL_VERSION;
    private static final Set<IResource> READABLE_SYSTEM_RESOURCES = new HashSet<IResource>();
    private static final Set<IResource> PROTECTED_AUTH_RESOURCES = new HashSet<IResource>();
    private static final Set<String> ALTERABLE_SYSTEM_KEYSPACES = new HashSet<String>();
    private static final Set<IResource> DROPPABLE_SYSTEM_TABLES = new HashSet<IResource>();
    private volatile AuthenticatedUser user;
    private volatile String keyspace;
    private static final QueryHandler cqlQueryHandler;
    public final boolean isInternal;
    private final InetSocketAddress remoteAddress;
    private static final AtomicLong lastTimestampMicros;

    private ClientState() {
        this.isInternal = true;
        this.remoteAddress = null;
    }

    protected ClientState(InetSocketAddress remoteAddress) {
        this.isInternal = false;
        this.remoteAddress = remoteAddress;
        if (!DatabaseDescriptor.getAuthenticator().requireAuthentication()) {
            this.user = AuthenticatedUser.ANONYMOUS_USER;
        }
    }

    public static ClientState forInternalCalls() {
        return new ClientState();
    }

    public static ClientState forExternalCalls(SocketAddress remoteAddress) {
        return new ClientState((InetSocketAddress)remoteAddress);
    }

    public long getTimestamp() {
        long current;
        long tstamp;
        long last;
        do {
            current = System.currentTimeMillis() * 1000L;
        } while (!lastTimestampMicros.compareAndSet(last, tstamp = (last = lastTimestampMicros.get()) >= current ? last + 1L : current));
        return tstamp;
    }

    public long getTimestampForPaxos(long minTimestampToUse) {
        long last;
        long tstamp;
        do {
            long current = Math.max(System.currentTimeMillis() * 1000L, minTimestampToUse);
            last = lastTimestampMicros.get();
            long l = tstamp = last >= current ? last + 1L : current;
        } while (tstamp != minTimestampToUse && !lastTimestampMicros.compareAndSet(last, tstamp));
        return tstamp;
    }

    public static QueryHandler getCQLQueryHandler() {
        return cqlQueryHandler;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getRawKeyspace() {
        return this.keyspace;
    }

    public String getKeyspace() throws InvalidRequestException {
        if (this.keyspace == null) {
            throw new InvalidRequestException("No keyspace has been specified. USE a keyspace, or explicitly specify keyspace.tablename");
        }
        return this.keyspace;
    }

    public void setKeyspace(String ks) throws InvalidRequestException {
        if (this.user != null && Schema.instance.getKSMetaData(ks) == null) {
            throw new InvalidRequestException("Keyspace '" + ks + "' does not exist");
        }
        this.keyspace = ks;
    }

    public void login(AuthenticatedUser user) throws AuthenticationException {
        if (!user.isAnonymous() && !DatabaseDescriptor.getRoleManager().canLogin(user.getPrimaryRole())) {
            throw new AuthenticationException(String.format("%s is not permitted to log in", user.getName()));
        }
        this.user = user;
    }

    public void hasAllKeyspacesAccess(Permission perm) throws UnauthorizedException {
        if (this.isInternal) {
            return;
        }
        this.validateLogin();
        this.ensureHasPermission(perm, DataResource.root());
    }

    public void hasKeyspaceAccess(String keyspace, Permission perm) throws UnauthorizedException, InvalidRequestException {
        this.hasAccess(keyspace, perm, DataResource.keyspace(keyspace));
    }

    public void hasColumnFamilyAccess(String keyspace, String columnFamily, Permission perm) throws UnauthorizedException, InvalidRequestException {
        ThriftValidation.validateColumnFamily(keyspace, columnFamily);
        this.hasAccess(keyspace, perm, DataResource.table(keyspace, columnFamily));
    }

    private void hasAccess(String keyspace, Permission perm, DataResource resource) throws UnauthorizedException, InvalidRequestException {
        ClientState.validateKeyspace(keyspace);
        if (this.isInternal) {
            return;
        }
        this.validateLogin();
        this.preventSystemKSSchemaModification(keyspace, resource, perm);
        if (perm == Permission.SELECT && READABLE_SYSTEM_RESOURCES.contains(resource)) {
            return;
        }
        if (PROTECTED_AUTH_RESOURCES.contains(resource) && (perm == Permission.CREATE || perm == Permission.ALTER || perm == Permission.DROP)) {
            throw new UnauthorizedException(String.format("%s schema is protected", resource));
        }
        this.ensureHasPermission(perm, resource);
    }

    public void ensureHasPermission(Permission perm, IResource resource) throws UnauthorizedException {
        if (DatabaseDescriptor.getAuthorizer() instanceof AllowAllAuthorizer) {
            return;
        }
        if (resource instanceof FunctionResource && resource.hasParent() && ((FunctionResource)resource).getKeyspace().equals("system")) {
            return;
        }
        this.checkPermissionOnResourceChain(perm, resource);
    }

    public void ensureHasPermission(Permission permission, Function function) {
        if (DatabaseDescriptor.getAuthorizer() instanceof AllowAllAuthorizer) {
            return;
        }
        if (function.isNative()) {
            return;
        }
        this.checkPermissionOnResourceChain(permission, FunctionResource.function(function.name().keyspace, function.name().name, function.argTypes()));
    }

    private void checkPermissionOnResourceChain(Permission perm, IResource resource) {
        for (IResource iResource : Resources.chain(resource)) {
            if (!this.authorize(iResource).contains((Object)perm)) continue;
            return;
        }
        throw new UnauthorizedException(String.format("User %s has no %s permission on %s or any of its parents", new Object[]{this.user.getName(), perm, resource}));
    }

    private void preventSystemKSSchemaModification(String keyspace, DataResource resource, Permission perm) throws UnauthorizedException {
        if (perm != Permission.ALTER && perm != Permission.DROP && perm != Permission.CREATE) {
            return;
        }
        if (Schema.isSystemKeyspace(keyspace)) {
            throw new UnauthorizedException(keyspace + " keyspace is not user-modifiable.");
        }
        if (ALTERABLE_SYSTEM_KEYSPACES.contains(resource.getKeyspace().toLowerCase()) && (perm == Permission.ALTER && !resource.isKeyspaceLevel() || perm == Permission.DROP && !DROPPABLE_SYSTEM_TABLES.contains(resource))) {
            throw new UnauthorizedException(String.format("Cannot %s %s", new Object[]{perm, resource}));
        }
    }

    public void validateLogin() throws UnauthorizedException {
        if (this.user == null) {
            throw new UnauthorizedException("You have not logged in");
        }
    }

    public void ensureNotAnonymous() throws UnauthorizedException {
        this.validateLogin();
        if (this.user.isAnonymous()) {
            throw new UnauthorizedException("You have to be logged in and not anonymous to perform this request");
        }
    }

    public void ensureIsSuper(String message) throws UnauthorizedException {
        if (DatabaseDescriptor.getAuthenticator().requireAuthentication() && (this.user == null || !this.user.isSuper())) {
            throw new UnauthorizedException(message);
        }
    }

    private static void validateKeyspace(String keyspace) throws InvalidRequestException {
        if (keyspace == null) {
            throw new InvalidRequestException("You have not set a keyspace for this session");
        }
    }

    public AuthenticatedUser getUser() {
        return this.user;
    }

    public static CassandraVersion[] getCQLSupportedVersion() {
        return new CassandraVersion[]{QueryProcessor.CQL_VERSION};
    }

    private Set<Permission> authorize(IResource resource) {
        return this.user.getPermissions(resource);
    }

    static {
        for (String cf : Arrays.asList("local", "peers")) {
            READABLE_SYSTEM_RESOURCES.add(DataResource.table("system", cf));
        }
        SchemaKeyspace.ALL.forEach(table -> READABLE_SYSTEM_RESOURCES.add(DataResource.table("system_schema", table)));
        if (!Config.isClientMode()) {
            PROTECTED_AUTH_RESOURCES.addAll(DatabaseDescriptor.getAuthenticator().protectedResources());
            PROTECTED_AUTH_RESOURCES.addAll(DatabaseDescriptor.getAuthorizer().protectedResources());
            PROTECTED_AUTH_RESOURCES.addAll(DatabaseDescriptor.getRoleManager().protectedResources());
        }
        ALTERABLE_SYSTEM_KEYSPACES.add("system_auth");
        ALTERABLE_SYSTEM_KEYSPACES.add("system_traces");
        DROPPABLE_SYSTEM_TABLES.add(DataResource.table("system_auth", "credentials"));
        DROPPABLE_SYSTEM_TABLES.add(DataResource.table("system_auth", "users"));
        DROPPABLE_SYSTEM_TABLES.add(DataResource.table("system_auth", "permissions"));
        QueryHandler handler = QueryProcessor.instance;
        String customHandlerClass = System.getProperty("cassandra.custom_query_handler_class");
        if (customHandlerClass != null) {
            try {
                handler = (QueryHandler)FBUtilities.construct(customHandlerClass, "QueryHandler");
                logger.info("Using {} as query handler for native protocol queries (as requested with -Dcassandra.custom_query_handler_class)", (Object)customHandlerClass);
            }
            catch (Exception e) {
                JVMStabilityInspector.inspectThrowable(e);
                logger.info("Cannot use class {} as query handler ({}), ignoring by defaulting on normal query handling", (Object)customHandlerClass, (Object)e.getMessage());
            }
        }
        cqlQueryHandler = handler;
        lastTimestampMicros = new AtomicLong(0L);
    }
}

