/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.jobs;

import com.google.common.collect.ImmutableMap;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.core.jobs.DeleteExpiredMetrics;
import org.hawkular.metrics.core.jobs.DeleteTenant;
import org.hawkular.metrics.core.jobs.JobsService;
import org.hawkular.metrics.core.jobs.JobsServiceImplMBean;
import org.hawkular.metrics.core.jobs.TempDataCompressor;
import org.hawkular.metrics.core.jobs.TempTableCreator;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.datetime.DateTimeService;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.metrics.scheduler.api.RepeatingTrigger;
import org.hawkular.metrics.scheduler.api.RetryPolicy;
import org.hawkular.metrics.scheduler.api.Scheduler;
import org.hawkular.metrics.scheduler.api.SingleExecutionTrigger;
import org.hawkular.metrics.sysconfig.Configuration;
import org.hawkular.metrics.sysconfig.ConfigurationService;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.jboss.logging.Logger;
import org.joda.time.Minutes;
import rx.Single;
import rx.functions.Func2;

public class JobsServiceImpl
implements JobsService,
JobsServiceImplMBean {
    public static final String CONFIG_PREFIX = "org.hawkular.metrics.jobs.";
    private static Logger logger = Logger.getLogger(JobsServiceImpl.class);
    private Scheduler scheduler;
    private RxSession session;
    private MetricsService metricsService;
    private DeleteTenant deleteTenant;
    private DeleteExpiredMetrics deleteExpiredMetrics;
    private int metricExpirationJobFrequencyInDays;
    private int metricExpirationDelay;
    private boolean metricExpirationJobEnabled;
    private ConfigurationService configurationService;

    public JobsServiceImpl() {
        this(1, 7, true);
    }

    public JobsServiceImpl(int metricExpirationDelay, int metricExpirationJobFrequencyInDays, boolean metricExpirationJobEnabled) {
        this.metricExpirationJobFrequencyInDays = metricExpirationJobFrequencyInDays;
        this.metricExpirationDelay = metricExpirationDelay;
        this.metricExpirationJobEnabled = metricExpirationJobEnabled;
    }

    public void setMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public void setSession(RxSession session) {
        this.session = session;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public List<JobDetails> start() {
        ArrayList<JobDetails> backgroundJobs = new ArrayList<JobDetails>();
        this.deleteTenant = new DeleteTenant(this.session, this.metricsService);
        Func2 deleteTenantRetryPolicy = (details, throwable) -> () -> {
            logger.warn((Object)("Execution of " + details + " failed"), throwable);
            logger.info((Object)(details + " will be retried in 5 minutes"));
            return Minutes.minutes(5).toStandardDuration().getMillis();
        };
        this.scheduler.register("DELETE_TENANT", this.deleteTenant, (Func2<JobDetails, Throwable, RetryPolicy>)deleteTenantRetryPolicy);
        TempTableCreator tempCreator = new TempTableCreator(this.metricsService, this.configurationService);
        this.scheduler.register("TEMP_TABLE_CREATOR", tempCreator);
        this.maybeScheduleTableCreator(backgroundJobs);
        TempDataCompressor tempJob = new TempDataCompressor(this.metricsService, this.configurationService);
        this.scheduler.register("TEMP_DATA_COMPRESSOR", tempJob);
        this.maybeScheduleCompressData(backgroundJobs);
        this.deleteExpiredMetrics = new DeleteExpiredMetrics(this.metricsService, this.session, this.configurationService, this.metricExpirationDelay);
        this.scheduler.register("DELETE_EXPIRED_METRICS", this.deleteExpiredMetrics);
        this.maybeScheduleMetricExpirationJob(backgroundJobs);
        this.scheduler.start();
        return backgroundJobs;
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdown();
    }

    @Override
    public Single<? extends JobDetails> submitDeleteTenantJob(String tenantId, String jobName) {
        return this.scheduler.scheduleJob("DELETE_TENANT", jobName, ImmutableMap.of("tenantId", tenantId), new SingleExecutionTrigger.Builder().withDelay(1L, TimeUnit.MINUTES).build());
    }

    @Override
    public Single<? extends JobDetails> submitDeleteExpiredMetricsJob(long expiration, String jobName) {
        return this.scheduler.scheduleJob("DELETE_EXPIRED_METRICS", jobName, ImmutableMap.of("expirationTimestamp", expiration + ""), new SingleExecutionTrigger.Builder().withDelay(1L, TimeUnit.MINUTES).build());
    }

    private void maybeScheduleTableCreator(List<JobDetails> backgroundJobs) {
        String configId = "org.hawkular.metrics.jobs.TEMP_TABLE_CREATOR";
        Configuration config = (Configuration)this.configurationService.load(configId).toBlocking().firstOrDefault((Object)new Configuration(configId, new HashMap<String, String>()));
        if (config.get("jobId") == null) {
            long nextTrigger = LocalDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.MINUTES).plusMinutes(2L).toInstant(ZoneOffset.UTC).toEpochMilli();
            JobDetails jobDetails = (JobDetails)this.scheduler.scheduleJob("TEMP_TABLE_CREATOR", "TEMP_TABLE_CREATOR", ImmutableMap.of(), new RepeatingTrigger.Builder().withTriggerTime(nextTrigger).withInterval(2, TimeUnit.HOURS).build()).toBlocking().value();
            backgroundJobs.add(jobDetails);
            this.configurationService.save(configId, "jobId", jobDetails.getJobId().toString()).toBlocking();
            logger.info((Object)("Scheduled temporary table creator " + jobDetails));
        }
    }

    private void maybeScheduleCompressData(List<JobDetails> backgroundJobs) {
        String configId = "org.hawkular.metrics.jobs.TEMP_DATA_COMPRESSOR";
        Configuration config = (Configuration)this.configurationService.load(configId).toBlocking().firstOrDefault((Object)new Configuration(configId, new HashMap<String, String>()));
        if (config.get("jobId") == null) {
            logger.info((Object)"Preparing to create and schedule TEMP_DATA_COMPRESSOR job");
            long nextStart = LocalDateTime.now(ZoneOffset.UTC).with(DateTimeService.startOfNextOddHour()).toInstant(ZoneOffset.UTC).toEpochMilli();
            JobDetails jobDetails = (JobDetails)this.scheduler.scheduleJob("TEMP_DATA_COMPRESSOR", "TEMP_DATA_COMPRESSOR", ImmutableMap.of(), new RepeatingTrigger.Builder().withTriggerTime(nextStart).withInterval(2, TimeUnit.HOURS).build()).toBlocking().value();
            backgroundJobs.add(jobDetails);
            this.configurationService.save(configId, "jobId", jobDetails.getJobId().toString()).toBlocking();
            logger.info((Object)("Created and scheduled " + jobDetails));
        }
    }

    private void maybeScheduleMetricExpirationJob(List<JobDetails> backgroundJobs) {
        String jobIdConfigKey = "jobId";
        String jobFrequencyKey = "jobFrequency";
        String configId = "org.hawkular.metrics.jobs.DELETE_EXPIRED_METRICS";
        Configuration config = (Configuration)this.configurationService.load(configId).toBlocking().firstOrDefault((Object)new Configuration(configId, new HashMap<String, String>()));
        if (config.get(jobIdConfigKey) != null) {
            Integer configuredJobFrequency = null;
            try {
                configuredJobFrequency = Integer.parseInt(config.get(jobFrequencyKey));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (configuredJobFrequency == null || configuredJobFrequency != this.metricExpirationJobFrequencyInDays || this.metricExpirationJobFrequencyInDays <= 0 || configuredJobFrequency <= 0 || !this.metricExpirationJobEnabled) {
                this.scheduler.unscheduleJob(config.get(jobIdConfigKey)).await();
                this.configurationService.delete(configId, jobIdConfigKey).toBlocking();
                config.delete(jobIdConfigKey);
                this.configurationService.delete(configId, jobFrequencyKey).toBlocking();
                config.delete(jobFrequencyKey);
            }
        }
        if (config.get(jobIdConfigKey) == null && this.metricExpirationJobFrequencyInDays > 0 && this.metricExpirationJobEnabled) {
            logger.info((Object)"Preparing to create and schedule DELETE_EXPIRED_METRICS job");
            long nextStart = DateTimeService.current24HourTimeSlice().plusDays(1).getMillis();
            JobDetails jobDetails = (JobDetails)this.scheduler.scheduleJob("DELETE_EXPIRED_METRICS", "DELETE_EXPIRED_METRICS", ImmutableMap.of(), new RepeatingTrigger.Builder().withTriggerTime(nextStart).withInterval(this.metricExpirationJobFrequencyInDays, TimeUnit.DAYS).build()).toBlocking().value();
            backgroundJobs.add(jobDetails);
            this.configurationService.save(configId, jobIdConfigKey, jobDetails.getJobId().toString()).toBlocking();
            this.configurationService.save(configId, jobFrequencyKey, this.metricExpirationJobFrequencyInDays + "").toBlocking();
            logger.info((Object)("Created and scheduled " + jobDetails));
        }
    }

    private void submitCompressJob(Map<String, String> parameters) {
        String jobName = String.format("%s_single_%s", "COMPRESS_DATA", parameters.get("compression.time.target"));
        this.scheduler.scheduleJob("COMPRESS_DATA", jobName, parameters, new SingleExecutionTrigger.Builder().withDelay(1L, TimeUnit.MINUTES).build()).toBlocking().value();
    }

    @Override
    public void submitCompressJob(long timestamp) {
        logger.debugf("Scheduling manual submitCompressJob with default blocksize, timestamp->%d", timestamp);
        this.submitCompressJob(ImmutableMap.of("compression.time.target", Long.valueOf(timestamp).toString()));
    }

    @Override
    public void submitCompressJob(long timestamp, String blockSize) {
        logger.debugf("Scheduling manual submitCompressJob with defined blocksize, timestamp->%d, blockSize->%s", timestamp, (Object)blockSize);
        this.submitCompressJob(ImmutableMap.of("compression.time.target", Long.valueOf(timestamp).toString(), "compression.block.size", blockSize));
    }

    @Override
    public void submitDeleteExpiredMetrics() {
        long time = System.currentTimeMillis();
        logger.debugf("Scheduling manual deleteExpiredMetrics job with timestamp->%d", time);
        this.submitDeleteExpiredMetricsJob(time, "delete_expired_" + time);
    }
}

