/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CassandraVersion
implements Comparable<CassandraVersion> {
    private static final String VERSION_REGEXP = "(\\d+)\\.(\\d+)\\.(\\d+)(\\-[.\\w]+)?([.+][.\\w]+)?";
    private static final Pattern pattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(\\-[.\\w]+)?([.+][.\\w]+)?");
    private static final Pattern SNAPSHOT = Pattern.compile("-SNAPSHOT");
    public final int major;
    public final int minor;
    public final int patch;
    private final String[] preRelease;
    private final String[] build;

    private CassandraVersion(int major, int minor, int patch, String[] preRelease, String[] build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.build = build;
    }

    public CassandraVersion(String version) {
        String stripped = SNAPSHOT.matcher(version).replaceFirst("");
        Matcher matcher = pattern.matcher(stripped);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid version value: " + version);
        }
        try {
            this.major = Integer.parseInt(matcher.group(1));
            this.minor = Integer.parseInt(matcher.group(2));
            this.patch = Integer.parseInt(matcher.group(3));
            String pr = matcher.group(4);
            String bld = matcher.group(5);
            this.preRelease = pr == null || pr.isEmpty() ? null : CassandraVersion.parseIdentifiers(stripped, pr);
            this.build = bld == null || bld.isEmpty() ? null : CassandraVersion.parseIdentifiers(stripped, bld);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid version value: " + version);
        }
    }

    private static String[] parseIdentifiers(String version, String str) {
        String[] parts;
        str = str.substring(1);
        for (String part : parts = str.split("\\.")) {
            if (part.matches("\\w+")) continue;
            throw new IllegalArgumentException("Invalid version value: " + version);
        }
        return parts;
    }

    @Override
    public int compareTo(CassandraVersion other) {
        if (this.major < other.major) {
            return -1;
        }
        if (this.major > other.major) {
            return 1;
        }
        if (this.minor < other.minor) {
            return -1;
        }
        if (this.minor > other.minor) {
            return 1;
        }
        if (this.patch < other.patch) {
            return -1;
        }
        if (this.patch > other.patch) {
            return 1;
        }
        int c = CassandraVersion.compareIdentifiers(this.preRelease, other.preRelease, 1);
        if (c != 0) {
            return c;
        }
        return CassandraVersion.compareIdentifiers(this.build, other.build, -1);
    }

    public CassandraVersion findSupportingVersion(CassandraVersion ... versions) {
        for (CassandraVersion version : versions) {
            if (!this.isSupportedBy(version)) continue;
            return version;
        }
        return null;
    }

    public boolean isSupportedBy(CassandraVersion version) {
        return this.major == version.major && this.compareTo(version) <= 0;
    }

    private static int compareIdentifiers(String[] ids1, String[] ids2, int defaultPred) {
        if (ids1 == null) {
            return ids2 == null ? 0 : defaultPred;
        }
        if (ids2 == null) {
            return -defaultPred;
        }
        int min = Math.min(ids1.length, ids2.length);
        for (int i = 0; i < min; ++i) {
            Integer i1 = CassandraVersion.tryParseInt(ids1[i]);
            Integer i2 = CassandraVersion.tryParseInt(ids2[i]);
            if (i1 != null) {
                if (i2 == null || i1 < i2) {
                    return -1;
                }
                if (i1 <= i2) continue;
                return 1;
            }
            if (i2 != null) {
                return 1;
            }
            int c = ids1[i].compareTo(ids2[i]);
            if (c == 0) continue;
            return c;
        }
        if (ids1.length < ids2.length) {
            return -1;
        }
        if (ids1.length > ids2.length) {
            return 1;
        }
        return 0;
    }

    private static Integer tryParseInt(String str) {
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean equals(Object o) {
        if (!(o instanceof CassandraVersion)) {
            return false;
        }
        CassandraVersion that = (CassandraVersion)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && Arrays.equals(this.preRelease, that.preRelease) && Arrays.equals(this.build, that.build);
    }

    public int hashCode() {
        return Objects.hashCode(this.major, this.minor, this.patch, this.preRelease, this.build);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        if (this.preRelease != null) {
            sb.append('-').append(StringUtils.join((Object[])this.preRelease, "."));
        }
        if (this.build != null) {
            sb.append('+').append(StringUtils.join((Object[])this.build, "."));
        }
        return sb.toString();
    }
}

