/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.jobs;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Statement;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.jboss.logging.Logger;
import rx.Completable;
import rx.Observable;
import rx.functions.Func1;

public class DeleteTenant
implements Func1<JobDetails, Completable> {
    private static Logger logger = Logger.getLogger(DeleteTenant.class);
    public static final String JOB_NAME = "DELETE_TENANT";
    private RxSession session;
    private PreparedStatement deleteTenant;
    private PreparedStatement deleteFromMetricsIndex;
    private PreparedStatement findTags;
    private PreparedStatement deleteTag;
    private PreparedStatement deleteRetentions;
    private MetricsService metricsService;

    public DeleteTenant(RxSession session, MetricsService metricsService) {
        this.session = session;
        this.metricsService = metricsService;
        this.deleteTenant = session.getSession().prepare("DELETE FROM tenants WHERE id = ?");
        this.deleteFromMetricsIndex = session.getSession().prepare("DELETE FROM metrics_idx WHERE tenant_id = ? AND type = ?");
        this.findTags = session.getSession().prepare("SELECT DISTINCT tenant_id, tname FROM metrics_tags_idx");
        this.deleteTag = session.getSession().prepare("DELETE FROM metrics_tags_idx WHERE tenant_id = ? AND tname = ?");
        this.deleteRetentions = session.getSession().prepare("DELETE FROM retentions_idx WHERE tenant_id = ? AND type = ?");
    }

    public Completable call(JobDetails details) {
        String tenantId = details.getParameters().get("tenantId");
        return this.deleteMetricData(tenantId).concatWith(this.deleteTenant(tenantId)).concatWith(this.deleteRetentions(tenantId)).concatWith(this.deleteMetricsIndex(tenantId)).concatWith(this.deleteTags(tenantId)).toCompletable().doOnCompleted(() -> logger.infof("Finished deleting " + tenantId, new Object[0]));
    }

    private Observable<Void> deleteMetricData(String tenantId) {
        return Observable.from(MetricType.all()).flatMap(type -> this.metricsService.findMetrics(tenantId, type)).flatMap(metric -> this.metricsService.deleteMetric(metric.getMetricId()));
    }

    private Observable<Void> deleteMetricsIndex(String tenantId) {
        return Observable.from(MetricType.all()).flatMap(type -> this.session.execute((Statement)this.deleteFromMetricsIndex.bind(tenantId, type.getCode()))).map(r -> null);
    }

    private Observable<Void> deleteTags(String tenantId) {
        return this.session.execute((Statement)this.findTags.bind()).flatMap(Observable::from).filter(row -> row.getString(0).equals(tenantId)).flatMap(row -> this.session.execute((Statement)this.deleteTag.bind(row.getString(0), row.getString(1)))).map(r -> null);
    }

    private Observable<Void> deleteRetentions(String tenantId) {
        return Observable.from(MetricType.all()).flatMap(type -> this.session.execute((Statement)this.deleteRetentions.bind(tenantId, type.getCode()))).map(r -> null);
    }

    private Observable<Void> deleteTenant(String tenantId) {
        return this.session.execute((Statement)this.deleteTenant.bind(tenantId)).map(r -> null);
    }
}

