/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.schema;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.cassalog.core.Cassalog;
import org.cassalog.core.CassalogBuilder;
import org.cassalog.core.ChangeSet;
import org.hawkular.metrics.schema.VersionUpdateException;
import org.hawkular.metrics.schema.VersionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaService {
    private static Logger logger = LoggerFactory.getLogger(SchemaService.class);
    private PreparedStatement versionUpdateQuery;
    private Session session;
    private String keyspace;
    private Cassalog cassalog;

    public SchemaService(Session session, String keyspace) {
        this.keyspace = keyspace;
        this.session = session;
        CassalogBuilder builder = new CassalogBuilder();
        this.cassalog = builder.withKeyspace(keyspace).withSession(session).build();
    }

    public void run(boolean resetDB) {
        this.run(resetDB, 1);
    }

    public void run(boolean resetDB, int replicationFactor) {
        this.run(resetDB, replicationFactor, false);
    }

    public void run(boolean resetDB, int replicationFactor, boolean updateVersion) {
        URI script = this.getScript();
        Map<String, ?> vars = this.getVars(resetDB, replicationFactor);
        this.cassalog.execute(script, this.getTags(), vars);
        if (updateVersion) {
            this.updateVersion(0L, 0);
        }
    }

    private PreparedStatement prepareUpdateStatementIfNeeded() {
        if (this.versionUpdateQuery == null) {
            this.versionUpdateQuery = this.session.prepare("INSERT INTO sys_config (config_id, name, value) VALUES (?, ?, ?)");
        }
        return this.versionUpdateQuery;
    }

    private Map<String, ?> getVars(boolean resetDB, int replicationFactor) {
        ImmutableMap<String, Logger> vars = ImmutableMap.of("keyspace", this.keyspace, "reset", resetDB, "session", this.session, "replicationFactor", replicationFactor, "logger", logger);
        return vars;
    }

    private List<String> getTags() {
        List<String> tags = Arrays.asList("0.15.x", "0.18.x", "0.19.x", "0.20.x", "0.21.x", "0.23.x", "0.26.x", "0.27.x", "0.28.x");
        return tags;
    }

    public void updateVersion(long delay, int maxRetries) {
        this.doVersionUpdate(delay, maxRetries);
    }

    public void updateSchemaVersionSession(long delay, int maxRetries) {
        this.doSchemaVersionUpdate(delay, maxRetries);
    }

    public String getSchemaVersion() {
        URI script = this.getScript();
        Map<String, ?> vars = this.getVars(false, 1);
        List<ChangeSet> changeSets = this.cassalog.load(script, this.getTags(), vars);
        if (changeSets.size() == 0) {
            throw new RuntimeException("Failed get schema version, there is no changes available.");
        }
        return changeSets.get(changeSets.size() - 1).getVersion();
    }

    private void doVersionUpdate(long delay, int maxRetries) {
        String version = VersionUtil.getVersion();
        this.writeVersion("version", version, delay, maxRetries);
    }

    private void doSchemaVersionUpdate(long delay, int maxRetries) {
        String version = this.getSchemaVersion();
        this.writeVersion("schema-version", version, delay, maxRetries);
    }

    private void writeVersion(String versionType, String version, long delay, int maxRetries) {
        String configId = "org.hawkular.metrics";
        BoundStatement boundStatement = this.prepareUpdateStatementIfNeeded().bind(configId, versionType, version);
        int retries = 0;
        this.session.execute("USE " + this.keyspace);
        while (true) {
            try {
                this.session.execute(boundStatement);
                logger.info("Updated system configuration to {} {}", (Object)versionType, (Object)version);
                break;
            }
            catch (Exception e) {
                if (++retries > maxRetries) {
                    throw new VersionUpdateException("Failed to update" + versionType + "in system configuration after " + maxRetries + " attempts.", e);
                }
                logger.warn("Failed to update " + versionType + " in system configuration. Retrying in " + delay + " ms", e);
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException e1) {
                    throw new VersionUpdateException("Aborting " + versionType + " update due to interrupt", e1);
                }
            }
        }
    }

    private URI getScript() {
        try {
            return this.getClass().getResource("/org/hawkular/schema/cassalog.groovy").toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Failed to load schema change script", e);
        }
    }
}

