/*
 * Decompiled with CFR 0.152.
 */
package fi.iki.yak.ts.compression.gorilla;

import fi.iki.yak.ts.compression.gorilla.BitOutput;

public class Compressor {
    private int storedLeadingZeros = Integer.MAX_VALUE;
    private int storedTrailingZeros = 0;
    private long storedVal = 0L;
    private long storedTimestamp = 0L;
    private long storedDelta = 0L;
    private long blockTimestamp = 0L;
    public static final short FIRST_DELTA_BITS = 27;
    private BitOutput out;

    public Compressor(long timestamp, BitOutput output) {
        this.blockTimestamp = timestamp;
        this.out = output;
        this.addHeader(timestamp);
    }

    private void addHeader(long timestamp) {
        this.out.writeBits(timestamp, 64);
    }

    public void addValue(long timestamp, long value) {
        if (this.storedTimestamp == 0L) {
            this.writeFirst(timestamp, value);
        } else {
            this.compressTimestamp(timestamp);
            this.compressValue(value);
        }
    }

    public void addValue(long timestamp, double value) {
        if (this.storedTimestamp == 0L) {
            this.writeFirst(timestamp, Double.doubleToRawLongBits(value));
        } else {
            this.compressTimestamp(timestamp);
            this.compressValue(Double.doubleToRawLongBits(value));
        }
    }

    private void writeFirst(long timestamp, long value) {
        this.storedDelta = timestamp - this.blockTimestamp;
        this.storedTimestamp = timestamp;
        this.storedVal = value;
        this.out.writeBits(this.storedDelta, 27);
        this.out.writeBits(this.storedVal, 64);
    }

    public void close() {
        this.out.writeBits(15L, 4);
        this.out.writeBits(-1L, 32);
        this.out.skipBit();
        this.out.flush();
    }

    private void compressTimestamp(long timestamp) {
        long newDelta = timestamp - this.storedTimestamp;
        long deltaD = newDelta - this.storedDelta;
        if (deltaD == 0L) {
            this.out.skipBit();
        } else if (deltaD >= -63L && deltaD <= 64L) {
            this.out.writeBits(2L, 2);
            this.out.writeBits(deltaD, 7);
        } else if (deltaD >= -255L && deltaD <= 256L) {
            this.out.writeBits(6L, 3);
            this.out.writeBits(deltaD, 9);
        } else if (deltaD >= -2047L && deltaD <= 2048L) {
            this.out.writeBits(14L, 4);
            this.out.writeBits(deltaD, 12);
        } else {
            this.out.writeBits(15L, 4);
            this.out.writeBits(deltaD, 32);
        }
        this.storedDelta = newDelta;
        this.storedTimestamp = timestamp;
    }

    private void compressValue(long value) {
        long xor = this.storedVal ^ value;
        if (xor == 0L) {
            this.out.skipBit();
        } else {
            int leadingZeros = Long.numberOfLeadingZeros(xor);
            int trailingZeros = Long.numberOfTrailingZeros(xor);
            if (leadingZeros >= 32) {
                leadingZeros = 31;
            }
            this.out.writeBit();
            if (leadingZeros >= this.storedLeadingZeros && trailingZeros >= this.storedTrailingZeros) {
                this.writeExistingLeading(xor);
            } else {
                this.writeNewLeading(xor, leadingZeros, trailingZeros);
            }
        }
        this.storedVal = value;
    }

    private void writeExistingLeading(long xor) {
        this.out.skipBit();
        int significantBits = 64 - this.storedLeadingZeros - this.storedTrailingZeros;
        this.out.writeBits(xor >>> this.storedTrailingZeros, significantBits);
    }

    private void writeNewLeading(long xor, int leadingZeros, int trailingZeros) {
        this.out.writeBit();
        this.out.writeBits(leadingZeros, 5);
        int significantBits = 64 - leadingZeros - trailingZeros;
        this.out.writeBits(significantBits, 6);
        this.out.writeBits(xor >>> trailingZeros, significantBits);
        this.storedLeadingZeros = leadingZeros;
        this.storedTrailingZeros = trailingZeros;
    }
}

