/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.concurrent.JMXEnabledThreadPoolExecutor;
import org.apache.cassandra.concurrent.NamedThreadFactory;
import org.apache.cassandra.config.Schema;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.locator.AbstractReplicationStrategy;
import org.apache.cassandra.service.StorageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingRangeCalculatorService {
    public static final PendingRangeCalculatorService instance = new PendingRangeCalculatorService();
    private static Logger logger = LoggerFactory.getLogger(PendingRangeCalculatorService.class);
    private final JMXEnabledThreadPoolExecutor executor = new JMXEnabledThreadPoolExecutor(1, Integer.MAX_VALUE, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1), new NamedThreadFactory("PendingRangeCalculator"), "internal");
    private AtomicInteger updateJobs = new AtomicInteger(0);

    public PendingRangeCalculatorService() {
        this.executor.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
                instance.finishUpdate();
            }
        });
    }

    private void finishUpdate() {
        this.updateJobs.decrementAndGet();
    }

    public void update() {
        this.updateJobs.incrementAndGet();
        this.executor.submit(new PendingRangeTask());
    }

    public void blockUntilFinished() {
        while (this.updateJobs.get() > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void calculatePendingRanges(AbstractReplicationStrategy strategy, String keyspaceName) {
        StorageService.instance.getTokenMetadata().calculatePendingRanges(strategy, keyspaceName);
    }

    private static class PendingRangeTask
    implements Runnable {
        private PendingRangeTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long start = System.currentTimeMillis();
                List<String> keyspaces = Schema.instance.getNonLocalStrategyKeyspaces();
                for (String keyspaceName : keyspaces) {
                    PendingRangeCalculatorService.calculatePendingRanges(Keyspace.open(keyspaceName).getReplicationStrategy(), keyspaceName);
                }
                if (logger.isTraceEnabled()) {
                    logger.trace("Finished PendingRangeTask for {} keyspaces in {}ms", (Object)keyspaces.size(), (Object)(System.currentTimeMillis() - start));
                }
            }
            finally {
                instance.finishUpdate();
            }
        }
    }
}

