/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import com.datastax.driver.core.AbstractTableMetadata;
import com.datastax.driver.core.AggregateMetadata;
import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.CodecRegistry;
import com.datastax.driver.core.FunctionMetadata;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.MaterializedViewMetadata;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TableMetadata;
import com.datastax.driver.core.Token;
import com.datastax.driver.core.TokenRange;
import com.datastax.driver.core.UserType;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hawkular.metrics.core.service.DataAccess;
import org.hawkular.metrics.core.service.Order;
import org.hawkular.metrics.core.service.TimeUUIDUtils;
import org.hawkular.metrics.core.service.compress.CompressedPointContainer;
import org.hawkular.metrics.core.service.log.CoreLogger;
import org.hawkular.metrics.core.service.log.CoreLogging;
import org.hawkular.metrics.core.service.transformers.BatchStatementTransformer;
import org.hawkular.metrics.core.service.transformers.BoundBatchStatementTransformer;
import org.hawkular.metrics.datetime.DateTimeService;
import org.hawkular.metrics.model.AvailabilityType;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.Metric;
import org.hawkular.metrics.model.MetricId;
import org.hawkular.metrics.model.MetricType;
import org.hawkular.metrics.model.Tenant;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.hawkular.rx.cassandra.driver.RxSessionImpl;
import rx.Observable;
import rx.exceptions.Exceptions;
import rx.schedulers.Schedulers;

public class DataAccessImpl
implements DataAccess {
    private static final CoreLogger log = CoreLogging.getCoreLogger(DataAccessImpl.class);
    public static final String OUT_OF_ORDER_TABLE_NAME = "data_0";
    public static final String TEMP_TABLE_NAME_PROTOTYPE = "data_temp_";
    public static final String TEMP_TABLE_NAME_FORMAT_STRING = "data_temp_%s";
    public static final long DPART = 0L;
    private Session session;
    private RxSession rxSession;
    private LoadBalancingPolicy loadBalancingPolicy;
    private NavigableMap<Long, Map<Integer, PreparedStatement>> prepMap;
    private TemporaryTableStatementCreator tableCreator = null;
    private static String byDateRangeExclusiveBase = "SELECT time, %s, tags FROM %s WHERE tenant_id = ? AND type = ? AND metric = ? AND time >= ? AND time < ?";
    private static String dateRangeExclusiveWithLimitBase = "SELECT time, %s, tags FROM %s  WHERE tenant_id = ? AND type = ? AND metric = ? AND time >= ? AND time < ? LIMIT ?";
    private static String dataByDateRangeExclusiveASCBase = "SELECT time, %s, tags FROM %s WHERE tenant_id = ? AND type = ? AND metric = ? AND time >= ? AND time < ? ORDER BY time ASC";
    private static String dataByDateRangeExclusiveWithLimitASCBase = "SELECT time, %s, tags FROM %s WHERE tenant_id = ? AND type = ? AND metric = ? AND time >= ? AND time < ? ORDER BY time ASC LIMIT ?";
    private static String scanTableBase = "SELECT tenant_id, type, metric, time, n_value, availability, l_value, tags, token(tenant_id, type, metric) FROM %s WHERE token(tenant_id, type, metric) > ? AND token(tenant_id, type, metric) <= ?";
    private static String TEMP_TABLE_BASE_CREATE = "CREATE TABLE %s ( tenant_id text, type tinyint, metric text, time timestamp, n_value double, availability blob, l_value bigint, tags map<text,text>, PRIMARY KEY ((tenant_id, type, metric), time)) WITH CLUSTERING ORDER BY (time DESC)";
    private static String data = "UPDATE %s SET %s = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND time = ? ";
    private static String dataWithTags = "UPDATE %s SET %s = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND time = ? ";
    private static String findMetricInDataBase = "SELECT DISTINCT tenant_id, type, metric FROM %s WHERE tenant_id = ? AND type = ? AND metric = ?";
    private static String findAllMetricsInDataBases = "SELECT DISTINCT tenant_id, type, metric FROM %s";
    private static String DELETE_FROM_DATA_BASE = "DELETE FROM %s WHERE tenant_id = ? AND type = ? AND metric = ?";
    private PreparedStatement insertTenant;
    private PreparedStatement insertTenantOverwrite;
    private PreparedStatement findAllTenantIds;
    private PreparedStatement findAllTenantIdsFromMetricsIdx;
    private PreparedStatement findTenant;
    private PreparedStatement insertIntoMetricsIndex;
    private PreparedStatement insertIntoMetricsIndexOverwrite;
    private PreparedStatement findMetricInData;
    private PreparedStatement findMetricInDataCompressed;
    private PreparedStatement scanMetricInMetricsIndex;
    private PreparedStatement findAllMetricsInData;
    private PreparedStatement findAllMetricsInDataCompressed;
    private PreparedStatement findMetricInMetricsIndex;
    private PreparedStatement findAllMetricsFromTagsIndex;
    private PreparedStatement getMetricTags;
    private PreparedStatement getTagNames;
    private PreparedStatement getTagNamesWithType;
    private PreparedStatement insertCompressedData;
    private PreparedStatement insertCompressedDataWithTags;
    private PreparedStatement insertStringData;
    private PreparedStatement insertStringDataUsingTTL;
    private PreparedStatement insertStringDataWithTags;
    private PreparedStatement insertStringDataWithTagsUsingTTL;
    private PreparedStatement findCompressedDataByDateRangeExclusive;
    private PreparedStatement findCompressedDataByDateRangeExclusiveWithLimit;
    private PreparedStatement findCompressedDataByDateRangeExclusiveASC;
    private PreparedStatement findCompressedDataByDateRangeExclusiveWithLimitASC;
    private PreparedStatement findStringDataByDateRangeExclusive;
    private PreparedStatement findStringDataByDateRangeExclusiveWithLimit;
    private PreparedStatement findStringDataByDateRangeExclusiveASC;
    private PreparedStatement findStringDataByDateRangeExclusiveWithLimitASC;
    private PreparedStatement deleteMetricData;
    private PreparedStatement deleteFromMetricRetentionIndex;
    private PreparedStatement deleteMetricFromMetricsIndex;
    private PreparedStatement deleteMetricDataWithLimit;
    private PreparedStatement updateMetricsIndex;
    private PreparedStatement addTagsToMetricsIndex;
    private PreparedStatement deleteTagsFromMetricsIndex;
    private PreparedStatement readMetricsIndex;
    private PreparedStatement updateRetentionsIndex;
    private PreparedStatement findDataRetentions;
    private PreparedStatement insertMetricsTagsIndex;
    private PreparedStatement deleteMetricsTagsIndex;
    private PreparedStatement findMetricsByTagName;
    private PreparedStatement findMetricsByTagNameValue;
    private static DateTimeFormatter TEMP_TABLE_DATEFORMATTER = new DateTimeFormatterBuilder().appendValue(ChronoField.YEAR, 4).appendValue(ChronoField.MONTH_OF_YEAR, 2).appendValue(ChronoField.DAY_OF_MONTH, 2).appendValue(ChronoField.HOUR_OF_DAY, 2).toFormatter();
    private CodecRegistry codecRegistry;
    private Metadata metadata;

    public DataAccessImpl(Session session) {
        this.session = session;
        this.rxSession = new RxSessionImpl(session);
        this.loadBalancingPolicy = session.getCluster().getConfiguration().getPolicies().getLoadBalancingPolicy();
        this.codecRegistry = session.getCluster().getConfiguration().getCodecRegistry();
        this.metadata = session.getCluster().getMetadata();
        this.initPreparedStatements();
        this.initializeTemporaryTableStatements();
    }

    private Integer getMapKey(byte code, int ordinal) {
        int key = ordinal;
        return key |= code << 24;
    }

    private Integer getMapKey(MetricType type, TempStatement ts) {
        return this.getMapKey(type.getCode(), ts.ordinal());
    }

    void prepareTempStatements(String tableName, Long mapKey) {
        HashMap<Integer, PreparedStatement> statementMap = new HashMap<Integer, PreparedStatement>();
        for (MetricType<?> metricType : MetricType.userTypes()) {
            if (metricType == MetricType.STRING) continue;
            block8: for (TempStatement st : TempStatement.values()) {
                String formatSt;
                Integer key = this.getMapKey(metricType, st);
                switch (st.getType()) {
                    case READ: {
                        formatSt = String.format(st.getStatement(), this.metricTypeToColumnName(metricType), tableName);
                        break;
                    }
                    case WRITE: {
                        formatSt = String.format(st.getStatement(), tableName, this.metricTypeToColumnName(metricType));
                        break;
                    }
                    default: {
                        continue block8;
                    }
                }
                PreparedStatement prepared = this.session.prepare(formatSt);
                statementMap.put(key, prepared);
            }
        }
        block9: for (TempStatement st : TempStatement.values()) {
            String formatSt;
            Integer key = this.getMapKey(MetricType.UNDEFINED, st);
            switch (st.getType()) {
                case SCAN: 
                case CREATE: 
                case DELETE: {
                    formatSt = String.format(st.getStatement(), tableName);
                    break;
                }
                default: {
                    continue block9;
                }
            }
            PreparedStatement prepared = this.session.prepare(formatSt);
            statementMap.put(key, prepared);
        }
        this.prepMap.put(mapKey, statementMap);
    }

    @Override
    public Observable<ResultSet> createTempTablesIfNotExists(Set<Long> timestamps) {
        return Observable.fromCallable(() -> {
            Set tables = timestamps.stream().map(this::getTempTableName).collect(Collectors.toSet());
            this.metadata.getKeyspace(this.session.getLoggedKeyspace()).getTables().stream().map(AbstractTableMetadata::getName).filter(t -> t.startsWith(TEMP_TABLE_NAME_PROTOTYPE)).forEach(tables::remove);
            return tables;
        }).flatMapIterable(s -> s).zipWith(Observable.interval((long)300L, (TimeUnit)TimeUnit.MILLISECONDS), (st, l) -> st).concatMap(this::createTemporaryTable);
    }

    Observable<ResultSet> createTemporaryTable(String tempTableName) {
        return Observable.just((Object)tempTableName).map(t -> new SimpleStatement(String.format(TempStatement.CREATE_TABLE.getStatement(), t))).flatMap(st -> this.rxSession.execute((Statement)st));
    }

    private void initializeTemporaryTableStatements() {
        this.prepMap = new ConcurrentSkipListMap<Long, Map<Integer, PreparedStatement>>();
        this.setTempTableCreator(new TemporaryTableStatementCreator());
        boolean zeroTableExists = false;
        for (TableMetadata table : this.metadata.getKeyspace(this.session.getLoggedKeyspace()).getTables()) {
            if (table.getName().startsWith(TEMP_TABLE_NAME_PROTOTYPE)) {
                Long mapKey = this.tableToMapKey(table.getName());
                this.prepareTempStatements(table.getName(), mapKey);
                continue;
            }
            if (!table.getName().equals(OUT_OF_ORDER_TABLE_NAME)) continue;
            zeroTableExists = true;
        }
        if (!zeroTableExists) {
            this.createTemporaryTable(OUT_OF_ORDER_TABLE_NAME).toBlocking().subscribe();
            this.session.execute(String.format("ALTER TABLE %s WITH default_time_to_live = %d", OUT_OF_ORDER_TABLE_NAME, TimeUnit.DAYS.toSeconds(7L)));
            this.session.execute(String.format("ALTER TABLE %s WITH compaction = {'compaction_window_size': '1', 'compaction_window_unit': 'DAYS', 'class': 'org.apache.cassandra.db.compaction.TimeWindowCompactionStrategy'}", OUT_OF_ORDER_TABLE_NAME));
        }
        this.prepareTempStatements(OUT_OF_ORDER_TABLE_NAME, 0L);
    }

    private String metricTypeToColumnName(MetricType<?> type) {
        switch (type.getCode()) {
            case 0: {
                return "n_value";
            }
            case 1: {
                return "availability";
            }
            case 2: {
                return "l_value";
            }
            case 3: {
                return "l_value";
            }
            case 4: {
                return "s_value";
            }
            case 5: {
                return "n_value";
            }
        }
        throw new RuntimeException("Unsupported metricType");
    }

    protected void initPreparedStatements() {
        this.insertTenant = this.session.prepare("INSERT INTO tenants (id, retentions) VALUES (?, ?) IF NOT EXISTS");
        this.insertTenantOverwrite = this.session.prepare("INSERT INTO tenants (id, retentions) VALUES (?, ?)");
        this.findAllTenantIds = this.session.prepare("SELECT DISTINCT id FROM tenants");
        this.findAllTenantIdsFromMetricsIdx = this.session.prepare("SELECT DISTINCT tenant_id, type FROM metrics_idx");
        this.findTenant = this.session.prepare("SELECT id, retentions FROM tenants WHERE id = ?");
        this.findMetricInData = this.session.prepare("SELECT DISTINCT tenant_id, type, metric, dpart FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? ");
        this.findMetricInDataCompressed = this.session.prepare("SELECT DISTINCT tenant_id, type, metric, dpart FROM data_compressed WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? ");
        this.findMetricInMetricsIndex = this.session.prepare("SELECT metric, tags, data_retention FROM metrics_idx WHERE tenant_id = ? AND type = ? AND metric = ?");
        this.scanMetricInMetricsIndex = this.session.prepare("SELECT tenant_id, type, metric, tags, token(tenant_id, type) FROM metrics_idx WHERE token(tenant_id, type) > ? AND token(tenant_id, type) <= ?");
        this.getMetricTags = this.session.prepare("SELECT tags FROM metrics_idx WHERE tenant_id = ? AND type = ? AND metric = ?");
        this.getTagNames = this.session.prepare("SELECT DISTINCT tenant_id, tname FROM metrics_tags_idx");
        this.getTagNamesWithType = this.session.prepare("SELECT tenant_id, tname, type FROM metrics_tags_idx");
        this.insertIntoMetricsIndex = this.session.prepare("INSERT INTO metrics_idx (tenant_id, type, metric, data_retention, tags) VALUES (?, ?, ?, ?, ?) IF NOT EXISTS");
        this.insertIntoMetricsIndexOverwrite = this.session.prepare("INSERT INTO metrics_idx (tenant_id, type, metric, data_retention, tags) VALUES (?, ?, ?, ?, ?) ");
        this.updateMetricsIndex = this.session.prepare("INSERT INTO metrics_idx (tenant_id, type, metric) VALUES (?, ?, ?)");
        this.addTagsToMetricsIndex = this.session.prepare("UPDATE metrics_idx SET tags = tags + ? WHERE tenant_id = ? AND type = ? AND metric = ?");
        this.deleteTagsFromMetricsIndex = this.session.prepare("UPDATE metrics_idx SET tags = tags - ?WHERE tenant_id = ? AND type = ? AND metric = ?");
        this.readMetricsIndex = this.session.prepare("SELECT metric, tags, data_retention FROM metrics_idx WHERE tenant_id = ? AND type = ? ORDER BY metric ASC");
        this.findAllMetricsInData = this.session.prepare("SELECT DISTINCT tenant_id, type, metric, dpart FROM data");
        this.findAllMetricsInDataCompressed = this.session.prepare("SELECT DISTINCT tenant_id, type, metric, dpart FROM data_compressed");
        this.findAllMetricsFromTagsIndex = this.session.prepare("SELECT tenant_id, type, metric FROM metrics_tags_idx");
        this.insertCompressedData = this.session.prepare("UPDATE data_compressed USING TTL ? SET c_value = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertCompressedDataWithTags = this.session.prepare("UPDATE data_compressed USING TTL ? SET c_value = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertStringData = this.session.prepare("UPDATE data SET s_value = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ?");
        this.insertStringDataUsingTTL = this.session.prepare("UPDATE data USING TTL ? SET s_value = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ?");
        this.insertStringDataWithTags = this.session.prepare("UPDATE data SET s_value = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.insertStringDataWithTagsUsingTTL = this.session.prepare("UPDATE data USING TTL ? SET s_value = ?, tags = ? WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time = ? ");
        this.findCompressedDataByDateRangeExclusive = this.session.prepare("SELECT time, c_value, tags FROM data_compressed WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?");
        this.findCompressedDataByDateRangeExclusiveWithLimit = this.session.prepare("SELECT time, c_value, tags FROM data_compressed  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? LIMIT ?");
        this.findCompressedDataByDateRangeExclusiveASC = this.session.prepare("SELECT time, c_value, tags FROM data_compressed WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC");
        this.findCompressedDataByDateRangeExclusiveWithLimitASC = this.session.prepare("SELECT time, c_value, tags FROM data_compressed WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC LIMIT ?");
        this.findStringDataByDateRangeExclusive = this.session.prepare("SELECT time, s_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?");
        this.findStringDataByDateRangeExclusiveWithLimit = this.session.prepare("SELECT time, s_value, tags FROM data  WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? LIMIT ?");
        this.findStringDataByDateRangeExclusiveASC = this.session.prepare("SELECT time, s_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC");
        this.findStringDataByDateRangeExclusiveWithLimitASC = this.session.prepare("SELECT time, s_value, tags FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ? ORDER BY time ASC LIMIT ?");
        this.deleteMetricData = this.session.prepare("DELETE FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ?");
        this.deleteMetricDataWithLimit = this.session.prepare("DELETE FROM data WHERE tenant_id = ? AND type = ? AND metric = ? AND dpart = ? AND time >= ? AND time < ?");
        this.deleteFromMetricRetentionIndex = this.session.prepare("DELETE FROM retentions_idx WHERE tenant_id = ? AND type = ? AND metric = ?");
        this.deleteMetricFromMetricsIndex = this.session.prepare("DELETE FROM metrics_idx WHERE tenant_id = ? AND type = ? AND metric = ?");
        this.updateRetentionsIndex = this.session.prepare("INSERT INTO retentions_idx (tenant_id, type, metric, retention) VALUES (?, ?, ?, ?)");
        this.findDataRetentions = this.session.prepare("SELECT tenant_id, type, metric, retention FROM retentions_idx WHERE tenant_id = ? AND type = ?");
        this.insertMetricsTagsIndex = this.session.prepare("INSERT INTO metrics_tags_idx (tenant_id, tname, tvalue, type, metric) VALUES (?, ?, ?, ?, ?)");
        this.deleteMetricsTagsIndex = this.session.prepare("DELETE FROM metrics_tags_idx WHERE tenant_id = ? AND tname = ? AND tvalue = ? AND type = ? AND metric = ?");
        this.findMetricsByTagName = this.session.prepare("SELECT tenant_id, type, metric, tvalue FROM metrics_tags_idx WHERE tenant_id = ? AND tname = ?");
        this.findMetricsByTagNameValue = this.session.prepare("SELECT tenant_id, type, metric, tvalue FROM metrics_tags_idx WHERE tenant_id = ? AND tname = ? AND tvalue IN ?");
    }

    @Override
    public Observable<ResultSet> insertTenant(Tenant tenant, boolean overwrite) {
        Map<String, Integer> retentions = tenant.getRetentionSettings().entrySet().stream().collect(Collectors.toMap(entry -> ((MetricType)entry.getKey()).getText(), Map.Entry::getValue));
        if (overwrite) {
            return this.rxSession.execute((Statement)this.insertTenantOverwrite.bind(tenant.getId(), retentions));
        }
        return this.rxSession.execute((Statement)this.insertTenant.bind(tenant.getId(), retentions));
    }

    @Override
    public Observable<Row> findAllTenantIds() {
        return this.rxSession.executeAndFetch((Statement)this.findAllTenantIds.bind()).concatWith(this.rxSession.executeAndFetch((Statement)this.findAllTenantIdsFromMetricsIdx.bind()));
    }

    @Override
    public Observable<Row> findTenant(String id) {
        return this.rxSession.executeAndFetch((Statement)this.findTenant.bind(id));
    }

    @Override
    public <T> ResultSetFuture insertMetricInMetricsIndex(Metric<T> metric, boolean overwrite) {
        MetricId<T> metricId = metric.getMetricId();
        if (overwrite) {
            return this.session.executeAsync(this.insertIntoMetricsIndexOverwrite.bind(metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), metric.getDataRetention(), metric.getTags()));
        }
        return this.session.executeAsync(this.insertIntoMetricsIndex.bind(metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), metric.getDataRetention(), metric.getTags()));
    }

    @Override
    public <T> Observable<Row> findMetricInData(MetricId<T> id) {
        return this.getPrepForAllTempTables(TempStatement.CHECK_EXISTENCE_OF_METRIC_IN_TABLE).map(b -> b.bind(id.getTenantId(), id.getType().getCode(), id.getName())).flatMap(b -> this.rxSession.executeAndFetch((Statement)b)).concatWith(this.rxSession.executeAndFetch((Statement)this.findMetricInData.bind(id.getTenantId(), id.getType().getCode(), id.getName(), 0L)).concatWith(this.rxSession.executeAndFetch((Statement)this.findMetricInDataCompressed.bind(id.getTenantId(), id.getType().getCode(), id.getName(), 0L)))).take(1);
    }

    @Override
    public <T> Observable<Observable<Row>> scanMetricsInMetricsIndex() {
        return Observable.from(this.getTokenRanges()).map(tr -> this.rxSession.executeAndFetch((Statement)this.scanMetricInMetricsIndex.bind().setToken(0, tr.getStart()).setToken(1, tr.getEnd())));
    }

    @Override
    public <T> Observable<Row> findMetricInMetricsIndex(MetricId<T> id) {
        return this.rxSession.executeAndFetch((Statement)this.findMetricInMetricsIndex.bind(id.getTenantId(), id.getType().getCode(), id.getName()));
    }

    @Override
    public <T> Observable<Row> getMetricTags(MetricId<T> id) {
        return this.rxSession.executeAndFetch((Statement)this.getMetricTags.bind(id.getTenantId(), id.getType().getCode(), id.getName()));
    }

    @Override
    public Observable<Row> getTagNames() {
        return this.rxSession.executeAndFetch((Statement)this.getTagNames.bind());
    }

    @Override
    public Observable<Row> getTagNamesWithType() {
        return this.rxSession.executeAndFetch((Statement)this.getTagNamesWithType.bind());
    }

    @Override
    public <T> Observable<ResultSet> addTags(Metric<T> metric, Map<String, String> tags) {
        MetricId<T> metricId = metric.getMetricId();
        BoundStatement stmt = this.addTagsToMetricsIndex.bind(tags, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName());
        return this.rxSession.execute((Statement)stmt);
    }

    @Override
    public <T> Observable<ResultSet> deleteTags(Metric<T> metric, Set<String> tags) {
        MetricId<T> metricId = metric.getMetricId();
        BoundStatement stmt = this.deleteTagsFromMetricsIndex.bind(tags, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName());
        return this.rxSession.execute((Statement)stmt);
    }

    @Override
    public <T> Observable<Integer> updateMetricsIndex(Observable<Metric<T>> metrics) {
        return metrics.map(Metric::getMetricId).map(id -> this.updateMetricsIndex.bind(id.getTenantId(), id.getType().getCode(), id.getName())).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(batch -> this.rxSession.execute((Statement)batch).map(resultSet -> batch.size()));
    }

    @Override
    public <T> Observable<Row> findMetricsInMetricsIndex(String tenantId, MetricType<T> type) {
        return this.rxSession.executeAndFetch((Statement)this.readMetricsIndex.bind(tenantId, type.getCode()));
    }

    @Override
    public Observable<Observable<Row>> findAllDataFromBucket(long timestamp, int pageSize, int maxConcurrency) {
        PreparedStatement ts = this.getTempStatement(MetricType.UNDEFINED, TempStatement.SCAN_WITH_TOKEN_RANGES, timestamp);
        if (ts == null || this.prepMap.floorKey(timestamp) == 0L) {
            return Observable.empty();
        }
        return Observable.from(this.getTokenRanges()).map(tr -> this.rxSession.executeAndFetch(this.getTempStatement(MetricType.UNDEFINED, TempStatement.SCAN_WITH_TOKEN_RANGES, timestamp).bind().setToken(0, tr.getStart()).setToken(1, tr.getEnd()).setFetchSize(pageSize)));
    }

    private Set<TokenRange> getTokenRanges() {
        HashSet<TokenRange> tokenRanges = new HashSet<TokenRange>();
        for (TokenRange tokenRange : this.metadata.getTokenRanges()) {
            tokenRanges.addAll(tokenRange.unwrap());
        }
        return tokenRanges;
    }

    @Override
    public Observable<ResultSet> dropTempTable(long timestamp) {
        String fullTableName = this.getTempTableName(timestamp);
        String dropCQL = String.format("DROP TABLE IF EXISTS %s", fullTableName);
        return this.rxSession.execute(dropCQL);
    }

    private Observable<PreparedStatement> getPrepForAllTempTables(TempStatement ts) {
        return Observable.from(this.prepMap.entrySet()).map(Map.Entry::getValue).map(pMap -> (PreparedStatement)pMap.get(this.getMapKey(MetricType.UNDEFINED, ts)));
    }

    @Override
    public Observable<Row> findAllMetricIdentifiersInData() {
        return this.getPrepForAllTempTables(TempStatement.LIST_ALL_METRICS_FROM_TABLE).flatMap(b -> this.rxSession.executeAndFetch((Statement)b.bind())).mergeWith(this.rxSession.executeAndFetch((Statement)this.findAllMetricsInData.bind())).mergeWith(this.rxSession.executeAndFetch((Statement)this.findAllMetricsInDataCompressed.bind()));
    }

    private Observable.Transformer<BoundStatement, Integer> applyMicroBatching() {
        return tObservable -> tObservable.groupBy(b -> {
            ByteBuffer routingKey = b.getRoutingKey(ProtocolVersion.NEWEST_SUPPORTED, this.codecRegistry);
            Token token = this.metadata.newToken(routingKey);
            for (TokenRange tokenRange : this.session.getCluster().getMetadata().getTokenRanges()) {
                if (!tokenRange.contains(token)) continue;
                return tokenRange;
            }
            log.warn("Unable to find any Cassandra node to insert token " + token.toString());
            return this.session.getCluster().getMetadata().getTokenRanges().iterator().next();
        }).flatMap(g -> g.compose((Observable.Transformer)new BoundBatchStatementTransformer())).flatMap(batch -> this.rxSession.execute((Statement)batch).compose(this.applyInsertRetryPolicy()).map(resultSet -> batch.size()));
    }

    private <T> Observable.Transformer<T, T> applyInsertRetryPolicy() {
        return tObservable -> tObservable.retryWhen(errors -> {
            Observable range = Observable.range((int)1, (int)2);
            return errors.zipWith(range, (t, i) -> {
                if (t instanceof DriverException) {
                    return i;
                }
                throw Exceptions.propagate((Throwable)t);
            }).flatMap(retryCount -> {
                long delay = (long)Math.min(Math.pow(2.0, retryCount.intValue()) * 1000.0, 3000.0);
                log.debug("Retrying batch insert in " + delay + " ms");
                return Observable.timer((long)delay, (TimeUnit)TimeUnit.MILLISECONDS);
            });
        });
    }

    Long tableToMapKey(String tableName) {
        LocalDateTime parsed = LocalDateTime.parse(tableName.substring(TEMP_TABLE_NAME_PROTOTYPE.length()), TEMP_TABLE_DATEFORMATTER);
        return parsed.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    String getTempTableName(long timestamp) {
        return String.format(TEMP_TABLE_NAME_FORMAT_STRING, ZonedDateTime.ofInstant(Instant.ofEpochMilli(timestamp), ZoneOffset.UTC).with(DateTimeService.startOfPreviousEvenHour()).format(TEMP_TABLE_DATEFORMATTER));
    }

    PreparedStatement getTempStatement(MetricType type, TempStatement ts, long timestamp) {
        Map.Entry<Long, Map<Integer, PreparedStatement>> floorEntry = this.prepMap.floorEntry(timestamp);
        if (floorEntry != null) {
            return floorEntry.getValue().get(this.getMapKey(type, ts));
        }
        return null;
    }

    @Override
    public <T> Observable<Integer> insertData(Observable<Metric<T>> metrics) {
        return metrics.flatMap(m -> Observable.from(m.getDataPoints()).compose(this.mapTempInsertStatement((Metric)m))).compose(this.applyMicroBatching());
    }

    private <T> Observable.Transformer<DataPoint<T>, BoundStatement> mapTempInsertStatement(Metric<T> metric) {
        MetricType type = metric.getMetricId().getType();
        MetricId metricId = metric.getMetricId();
        return tO -> tO.map(dataPoint -> {
            BoundStatement bs;
            int i = 1;
            if (dataPoint.getTags().isEmpty()) {
                PreparedStatement st = this.getTempStatement(type, TempStatement.INSERT_DATA, dataPoint.getTimestamp());
                if (st == null) {
                    return null;
                }
                bs = st.bind();
            } else {
                PreparedStatement st = this.getTempStatement(type, TempStatement.INSERT_DATA_WITH_TAGS, dataPoint.getTimestamp());
                if (st == null) {
                    return null;
                }
                bs = st.bind();
                bs.setMap(1, (Map)dataPoint.getTags());
                ++i;
            }
            this.bindValue(bs, type, (DataPoint)dataPoint);
            return bs.setString(i, metricId.getTenantId()).setByte(++i, metricId.getType().getCode()).setString(++i, metricId.getName()).setTimestamp(++i, new Date(dataPoint.getTimestamp()));
        }).filter(Objects::nonNull);
    }

    private <T> void bindValue(BoundStatement bs, MetricType<T> type, DataPoint<T> dataPoint) {
        switch (type.getCode()) {
            case 0: {
                bs.setDouble(0, (double)((Double)dataPoint.getValue()));
                break;
            }
            case 1: {
                bs.setBytes(0, this.getBytes(dataPoint));
                break;
            }
            case 2: {
                bs.setLong(0, (long)((Long)dataPoint.getValue()));
                break;
            }
            case 3: {
                bs.setLong(0, (long)((Long)dataPoint.getValue()));
                break;
            }
            case 4: {
                throw new IllegalArgumentException("Not implemented yet");
            }
            case 5: {
                bs.setDouble(0, (double)((Double)dataPoint.getValue()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported metricType");
            }
        }
    }

    private Observable.Transformer<DataPoint<String>, BoundStatement> mapStringDatapoint(Metric<String> metric, int ttl, int maxSize) {
        return tObservable -> tObservable.map(dataPoint -> {
            if (maxSize != -1 && ((String)dataPoint.getValue()).length() > maxSize) {
                throw new IllegalArgumentException(dataPoint + " exceeds max string length of " + maxSize + " characters");
            }
            if (dataPoint.getTags().isEmpty()) {
                if (ttl >= 0) {
                    return this.bindDataPoint(this.insertStringDataUsingTTL, metric, dataPoint.getValue(), dataPoint.getTimestamp(), ttl);
                }
                return this.bindDataPoint(this.insertStringData, metric, dataPoint.getValue(), dataPoint.getTimestamp());
            }
            if (ttl >= 0) {
                return this.bindDataPoint(this.insertStringDataWithTagsUsingTTL, metric, dataPoint.getValue(), dataPoint.getTags(), dataPoint.getTimestamp(), ttl);
            }
            return this.bindDataPoint(this.insertStringDataWithTags, metric, dataPoint.getValue(), dataPoint.getTags(), dataPoint.getTimestamp());
        });
    }

    @Override
    public Observable<Integer> insertStringDatas(Observable<Metric<String>> strings, Function<MetricId<String>, Integer> ttlFetcher, int maxSize) {
        return strings.flatMap(string -> {
            int ttl = (Integer)ttlFetcher.apply(string.getMetricId());
            return Observable.from(string.getDataPoints()).compose(this.mapStringDatapoint((Metric<String>)string, ttl, maxSize));
        }).compose(this.applyMicroBatching());
    }

    @Override
    public Observable<Integer> insertStringData(Metric<String> metric, int maxSize) {
        return this.insertStringData(metric, -1, maxSize);
    }

    @Override
    public Observable<Integer> insertStringData(Metric<String> metric, int ttl, int maxSize) {
        return Observable.from(metric.getDataPoints()).compose(this.mapStringDatapoint(metric, ttl, maxSize)).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(batch -> this.rxSession.execute((Statement)batch).map(resultSet -> batch.size()));
    }

    private BoundStatement bindDataPoint(PreparedStatement statement, Metric<?> metric, Object value, long timestamp) {
        MetricId<?> metricId = metric.getMetricId();
        return statement.bind(value, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), 0L, TimeUUIDUtils.getTimeUUID(timestamp));
    }

    private BoundStatement bindDataPoint(PreparedStatement statement, Metric<?> metric, Object value, long timestamp, int ttl) {
        MetricId<?> metricId = metric.getMetricId();
        return statement.bind(ttl, value, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), 0L, TimeUUIDUtils.getTimeUUID(timestamp));
    }

    private BoundStatement bindDataPoint(PreparedStatement statement, Metric<?> metric, Object value, Map<String, String> tags, long timestamp) {
        MetricId<?> metricId = metric.getMetricId();
        return statement.bind(value, tags, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), 0L, TimeUUIDUtils.getTimeUUID(timestamp));
    }

    private BoundStatement bindDataPoint(PreparedStatement statement, Metric<?> metric, Object value, Map<String, String> tags, long timestamp, int ttl) {
        MetricId<?> metricId = metric.getMetricId();
        return statement.bind(ttl, value, tags, metricId.getTenantId(), metricId.getType().getCode(), metricId.getName(), 0L, TimeUUIDUtils.getTimeUUID(timestamp));
    }

    @Override
    public Observable<Row> findCompressedData(MetricId<?> id, long startTime, long endTime, int limit, Order order) {
        if (order == Order.ASC) {
            if (limit <= 0) {
                return this.rxSession.executeAndFetch((Statement)this.findCompressedDataByDateRangeExclusiveASC.bind(id.getTenantId(), id.getType().getCode(), id.getName(), 0L, new Date(startTime), new Date(endTime)));
            }
            return this.rxSession.executeAndFetch((Statement)this.findCompressedDataByDateRangeExclusiveWithLimitASC.bind(id.getTenantId(), id.getType().getCode(), id.getName(), 0L, new Date(startTime), new Date(endTime), limit));
        }
        if (limit <= 0) {
            return this.rxSession.executeAndFetch((Statement)this.findCompressedDataByDateRangeExclusive.bind(id.getTenantId(), id.getType().getCode(), id.getName(), 0L, new Date(startTime), new Date(endTime)));
        }
        return this.rxSession.executeAndFetch((Statement)this.findCompressedDataByDateRangeExclusiveWithLimit.bind(id.getTenantId(), id.getType().getCode(), id.getName(), 0L, new Date(startTime), new Date(endTime), limit));
    }

    private SortedMap<Long, Map<Integer, PreparedStatement>> subSetMap(long startTime, long endTime, Order order) {
        ConcurrentSkipListMap<Long, Map<Integer, PreparedStatement>> statementMap;
        Long startKey = this.prepMap.floorKey(startTime);
        Long endKey = this.prepMap.floorKey(endTime);
        if (startKey == null) {
            startKey = this.prepMap.ceilingKey(startTime);
        }
        if (endKey == null) {
            endKey = startKey;
        }
        if (order == Order.ASC) {
            statementMap = this.prepMap.subMap(startKey, true, endKey, true);
        } else {
            statementMap = new ConcurrentSkipListMap<Long, Map<Integer, PreparedStatement>>((var0, var2) -> var0 < var2 ? 1 : (var0 == var2 ? 0 : -1));
            statementMap.putAll(this.prepMap.subMap(startKey, true, endKey, true));
        }
        return statementMap;
    }

    @Override
    public <T> Observable<Row> findTempData(MetricId<T> id, long startTime, long endTime, int limit, Order order, int pageSize) {
        MetricType type = id.getType();
        SortedMap<Long, Map<Integer, PreparedStatement>> statementMap = this.subSetMap(startTime, endTime, order);
        Observable buckets = Observable.from(statementMap.values());
        if (order == Order.ASC) {
            if (limit <= 0) {
                return buckets.map(m -> (PreparedStatement)m.get(this.getMapKey(type, TempStatement.dataByDateRangeExclusiveASC))).concatMap(p -> this.rxSession.executeAndFetch(p.bind(id.getTenantId(), id.getType().getCode(), id.getName(), new Date(startTime), new Date(endTime)).setFetchSize(pageSize)));
            }
            return buckets.map(m -> (PreparedStatement)m.get(this.getMapKey(type, TempStatement.dataByDateRangeExclusiveWithLimitASC))).concatMap(p -> this.rxSession.executeAndFetch(p.bind(id.getTenantId(), id.getType().getCode(), id.getName(), new Date(startTime), new Date(endTime), limit).setFetchSize(pageSize)));
        }
        if (limit <= 0) {
            return buckets.map(m -> (PreparedStatement)m.get(this.getMapKey(type, TempStatement.dateRangeExclusive))).concatMap(p -> this.rxSession.executeAndFetch(p.bind(id.getTenantId(), id.getType().getCode(), id.getName(), new Date(startTime), new Date(endTime)).setFetchSize(pageSize)));
        }
        return buckets.map(m -> (PreparedStatement)m.get(this.getMapKey(type, TempStatement.dateRangeExclusiveWithLimit))).concatMap(p -> this.rxSession.executeAndFetch(p.bind(id.getTenantId(), id.getType().getCode(), id.getName(), new Date(startTime), new Date(endTime), limit).setFetchSize(pageSize)));
    }

    @Override
    public Observable<Row> findStringData(MetricId<String> id, long startTime, long endTime, int limit, Order order, int pageSize) {
        if (order == Order.ASC) {
            if (limit <= 0) {
                return this.rxSession.executeAndFetch(this.findStringDataByDateRangeExclusiveASC.bind(id.getTenantId(), MetricType.STRING.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)).setFetchSize(pageSize));
            }
            return this.rxSession.executeAndFetch(this.findStringDataByDateRangeExclusiveWithLimitASC.bind(id.getTenantId(), MetricType.STRING.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit).setFetchSize(pageSize));
        }
        if (limit <= 0) {
            return this.rxSession.executeAndFetch(this.findStringDataByDateRangeExclusive.bind(id.getTenantId(), MetricType.STRING.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime)).setFetchSize(pageSize));
        }
        return this.rxSession.executeAndFetch(this.findStringDataByDateRangeExclusiveWithLimit.bind(id.getTenantId(), MetricType.STRING.getCode(), id.getName(), 0L, TimeUUIDUtils.getTimeUUID(startTime), TimeUUIDUtils.getTimeUUID(endTime), limit).setFetchSize(pageSize));
    }

    @Override
    public <T> Observable<ResultSet> deleteMetricData(MetricId<T> id) {
        if (id.getType() == MetricType.STRING) {
            return this.rxSession.execute((Statement)this.deleteMetricData.bind(id.getTenantId(), id.getType().getCode(), id.getName(), 0L));
        }
        return this.getPrepForAllTempTables(TempStatement.DELETE_DATA).flatMap(p -> this.rxSession.execute((Statement)p.bind(id.getTenantId(), id.getType().getCode(), id.getName())));
    }

    @Override
    public <T> Observable<ResultSet> deleteMetricFromRetentionIndex(MetricId<T> id) {
        return this.rxSession.execute((Statement)this.deleteFromMetricRetentionIndex.bind(id.getTenantId(), id.getType().getCode(), id.getName()));
    }

    @Override
    public <T> Observable<ResultSet> deleteMetricFromMetricsIndex(MetricId<T> id) {
        return this.rxSession.execute((Statement)this.deleteMetricFromMetricsIndex.bind(id.getTenantId(), id.getType().getCode(), id.getName()));
    }

    private ByteBuffer getBytes(DataPoint<AvailabilityType> dataPoint) {
        return ByteBuffer.wrap(new byte[]{dataPoint.getValue().getCode()});
    }

    @Override
    public <T> ResultSetFuture findDataRetentions(String tenantId, MetricType<T> type) {
        return this.session.executeAsync(this.findDataRetentions.bind(tenantId, type.getCode()));
    }

    @Override
    public <T> Observable<ResultSet> updateRetentionsIndex(String tenantId, MetricType<T> type, Map<String, Integer> retentions) {
        return Observable.from(retentions.entrySet()).map(entry -> this.updateRetentionsIndex.bind(tenantId, type.getCode(), entry.getKey(), entry.getValue())).compose((Observable.Transformer)new BatchStatementTransformer()).flatMap(arg_0 -> ((RxSession)this.rxSession).execute(arg_0));
    }

    @Override
    public <T> Observable<ResultSet> insertIntoMetricsTagsIndex(Metric<T> metric, Map<String, String> tags) {
        MetricId metricId = metric.getMetricId();
        return this.tagsUpdates(tags, (name, value) -> this.insertMetricsTagsIndex.bind(metricId.getTenantId(), name, value, metricId.getType().getCode(), metricId.getName()));
    }

    @Override
    public <T> Observable<ResultSet> deleteFromMetricsTagsIndex(MetricId<T> id, Map<String, String> tags) {
        return this.tagsUpdates(tags, (name, value) -> this.deleteMetricsTagsIndex.bind(id.getTenantId(), name, value, id.getType().getCode(), id.getName()));
    }

    private Observable<ResultSet> tagsUpdates(Map<String, String> tags, BiFunction<String, String, BoundStatement> bindVars) {
        return Observable.from(tags.entrySet()).map(entry -> (BoundStatement)bindVars.apply((String)entry.getKey(), (String)entry.getValue())).flatMap(arg_0 -> ((RxSession)this.rxSession).execute(arg_0));
    }

    @Override
    public Observable<Row> findMetricsByTagName(String tenantId, String tag) {
        return this.rxSession.executeAndFetch((Statement)this.findMetricsByTagName.bind(tenantId, tag));
    }

    @Override
    public Observable<Row> findMetricsByTagNameValue(String tenantId, String tag, String ... tvalues) {
        return this.rxSession.executeAndFetch((Statement)this.findMetricsByTagNameValue.bind(tenantId, tag, Arrays.asList(tvalues)));
    }

    @Override
    public <T> ResultSetFuture updateRetentionsIndex(Metric<T> metric) {
        return this.session.executeAsync(this.updateRetentionsIndex.bind(metric.getMetricId().getTenantId(), metric.getMetricId().getType().getCode(), metric.getMetricId().getName(), metric.getDataRetention()));
    }

    @Override
    public <T> Observable<ResultSet> insertCompressedData(MetricId<T> id, long timeslice, CompressedPointContainer cpc, int ttl) {
        BoundStatement b2;
        Observable.just((Object)cpc.getValueBuffer(), (Object)cpc.getTimestampBuffer(), (Object)cpc.getTagsBuffer()).doOnNext(bb -> {
            if (bb != null && bb.position() != 0) {
                bb.rewind();
            }
        });
        BiConsumer<BoundStatement, Integer> mapper = (b, i) -> b.setString((int)i, id.getTenantId()).setByte(i + 1, id.getType().getCode()).setString(i + 2, id.getName()).setLong(i + 3, 0L).setTimestamp(i + 4, new Date(timeslice));
        int i2 = 0;
        if (cpc.getTagsBuffer() != null) {
            b2 = this.insertCompressedDataWithTags.bind().setInt(i2, ttl).setBytes(i2 + 1, cpc.getValueBuffer()).setBytes(i2 + 2, cpc.getTagsBuffer());
            mapper.accept(b2, 3);
        } else {
            b2 = this.insertCompressedData.bind().setInt(i2, ttl).setBytes(i2 + 1, cpc.getValueBuffer());
            mapper.accept(b2, 2);
        }
        return this.rxSession.execute((Statement)b2);
    }

    @Override
    public <T> Observable<ResultSet> deleteAndInsertCompressedGauge(MetricId<T> id, long timeslice, CompressedPointContainer cpc, long sliceStart, long sliceEnd, int ttl) {
        return Observable.just((Object)this.deleteMetricDataWithLimit.bind().setString(0, id.getTenantId()).setByte(1, id.getType().getCode()).setString(2, id.getName()).setLong(3, 0L).setUUID(4, TimeUUIDUtils.getTimeUUID(sliceStart)).setUUID(5, TimeUUIDUtils.getTimeUUID(sliceEnd))).concatMap(st -> this.rxSession.execute((Statement)st)).concatWith(this.insertCompressedData(id, timeslice, cpc, ttl));
    }

    @Override
    public Observable<Row> findAllMetricsFromTagsIndex() {
        return this.rxSession.executeAndFetch((Statement)this.findAllMetricsFromTagsIndex.bind());
    }

    void removeTempStatements(String tableName) {
        Long mapKey = this.tableToMapKey(tableName);
        this.prepMap.remove(mapKey);
    }

    @Override
    public void shutdown() {
        this.session.getCluster().unregister(this.tableCreator);
        this.tableCreator = null;
    }

    public void setTempTableCreator(TemporaryTableStatementCreator creator) {
        if (this.tableCreator != null) {
            this.session.getCluster().unregister(this.tableCreator);
        }
        this.tableCreator = creator;
        this.session.getCluster().register(this.tableCreator);
    }

    static /* synthetic */ String access$000() {
        return byDateRangeExclusiveBase;
    }

    static /* synthetic */ String access$100() {
        return dateRangeExclusiveWithLimitBase;
    }

    static /* synthetic */ String access$200() {
        return dataByDateRangeExclusiveASCBase;
    }

    static /* synthetic */ String access$300() {
        return dataByDateRangeExclusiveWithLimitASCBase;
    }

    static /* synthetic */ String access$400() {
        return scanTableBase;
    }

    static /* synthetic */ String access$500() {
        return findMetricInDataBase;
    }

    static /* synthetic */ String access$600() {
        return findAllMetricsInDataBases;
    }

    static /* synthetic */ String access$700() {
        return data;
    }

    static /* synthetic */ String access$800() {
        return dataWithTags;
    }

    static /* synthetic */ String access$900() {
        return TEMP_TABLE_BASE_CREATE;
    }

    static /* synthetic */ String access$1000() {
        return DELETE_FROM_DATA_BASE;
    }

    private class TemporaryTableStatementCreator
    implements SchemaChangeListener {
        private final CoreLogger log = CoreLogging.getCoreLogger(TemporaryTableStatementCreator.class);

        private TemporaryTableStatementCreator() {
        }

        @Override
        public void onTableAdded(TableMetadata tableMetadata) {
            this.log.debugf("Table added %s", tableMetadata.getName());
            if (tableMetadata.getName().startsWith(DataAccessImpl.TEMP_TABLE_NAME_PROTOTYPE)) {
                this.log.debugf("Registering prepared statements for table %s", tableMetadata.getName());
                Observable.fromCallable(() -> {
                    DataAccessImpl.this.prepareTempStatements(tableMetadata.getName(), DataAccessImpl.this.tableToMapKey(tableMetadata.getName()));
                    return null;
                }).subscribeOn(Schedulers.io()).subscribe();
            }
        }

        @Override
        public void onTableRemoved(TableMetadata tableMetadata) {
            if (tableMetadata.getName().startsWith(DataAccessImpl.TEMP_TABLE_NAME_PROTOTYPE)) {
                this.log.debugf("Removing prepared statements for table %s", tableMetadata.getName());
                DataAccessImpl.this.removeTempStatements(tableMetadata.getName());
            }
        }

        @Override
        public void onKeyspaceAdded(KeyspaceMetadata keyspaceMetadata) {
        }

        @Override
        public void onKeyspaceRemoved(KeyspaceMetadata keyspaceMetadata) {
        }

        @Override
        public void onKeyspaceChanged(KeyspaceMetadata keyspaceMetadata, KeyspaceMetadata keyspaceMetadata1) {
        }

        @Override
        public void onTableChanged(TableMetadata tableMetadata, TableMetadata tableMetadata1) {
        }

        @Override
        public void onUserTypeAdded(UserType userType) {
        }

        @Override
        public void onUserTypeRemoved(UserType userType) {
        }

        @Override
        public void onUserTypeChanged(UserType userType, UserType userType1) {
        }

        @Override
        public void onFunctionAdded(FunctionMetadata functionMetadata) {
        }

        @Override
        public void onFunctionRemoved(FunctionMetadata functionMetadata) {
        }

        @Override
        public void onFunctionChanged(FunctionMetadata functionMetadata, FunctionMetadata functionMetadata1) {
        }

        @Override
        public void onAggregateAdded(AggregateMetadata aggregateMetadata) {
        }

        @Override
        public void onAggregateRemoved(AggregateMetadata aggregateMetadata) {
        }

        @Override
        public void onAggregateChanged(AggregateMetadata aggregateMetadata, AggregateMetadata aggregateMetadata1) {
        }

        @Override
        public void onMaterializedViewAdded(MaterializedViewMetadata materializedViewMetadata) {
        }

        @Override
        public void onMaterializedViewRemoved(MaterializedViewMetadata materializedViewMetadata) {
        }

        @Override
        public void onMaterializedViewChanged(MaterializedViewMetadata materializedViewMetadata, MaterializedViewMetadata materializedViewMetadata1) {
        }

        @Override
        public void onRegister(Cluster cluster) {
        }

        @Override
        public void onUnregister(Cluster cluster) {
        }
    }

    private static enum TempStatement {
        dateRangeExclusive(DataAccessImpl.access$000(), StatementType.READ),
        dateRangeExclusiveWithLimit(DataAccessImpl.access$100(), StatementType.READ),
        dataByDateRangeExclusiveASC(DataAccessImpl.access$200(), StatementType.READ),
        dataByDateRangeExclusiveWithLimitASC(DataAccessImpl.access$300(), StatementType.READ),
        SCAN_WITH_TOKEN_RANGES(DataAccessImpl.access$400(), StatementType.SCAN),
        CHECK_EXISTENCE_OF_METRIC_IN_TABLE(DataAccessImpl.access$500(), StatementType.SCAN),
        LIST_ALL_METRICS_FROM_TABLE(DataAccessImpl.access$600(), StatementType.SCAN),
        INSERT_DATA(DataAccessImpl.access$700(), StatementType.WRITE),
        INSERT_DATA_WITH_TAGS(DataAccessImpl.access$800(), StatementType.WRITE),
        CREATE_TABLE(DataAccessImpl.access$900(), StatementType.CREATE),
        DELETE_DATA(DataAccessImpl.access$1000(), StatementType.DELETE);

        private final String statement;
        private StatementType type;

        private TempStatement(String st, StatementType t) {
            this.statement = st;
            this.type = t;
        }

        public String getStatement() {
            return this.statement;
        }

        public StatementType getType() {
            return this.type;
        }
    }

    private static enum StatementType {
        READ,
        WRITE,
        SCAN,
        CREATE,
        DELETE;

    }
}

