/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service.transformers;

import java.util.List;
import org.hawkular.metrics.core.service.transformers.NumericDataPointCollector;
import org.hawkular.metrics.model.BucketPoint;
import org.hawkular.metrics.model.Buckets;
import org.hawkular.metrics.model.DataPoint;
import org.hawkular.metrics.model.NumericBucketPoint;
import org.hawkular.metrics.model.Percentile;
import rx.Observable;

public class NumericBucketPointTransformer
implements Observable.Transformer<DataPoint<? extends Number>, List<NumericBucketPoint>> {
    private final Buckets buckets;
    private final List<Percentile> percentiles;

    public NumericBucketPointTransformer(Buckets buckets, List<Percentile> percentiles) {
        this.buckets = buckets;
        this.percentiles = percentiles;
    }

    public Observable<List<NumericBucketPoint>> call(Observable<DataPoint<? extends Number>> dataPoints) {
        return dataPoints.groupBy(dataPoint -> this.buckets.getIndex(dataPoint.getTimestamp())).flatMap(group -> group.collect(() -> new NumericDataPointCollector(this.buckets, (Integer)group.getKey(), this.percentiles), NumericDataPointCollector::increment)).map(NumericDataPointCollector::toBucketPoint).toMap(BucketPoint::getStart).map(pointMap -> NumericBucketPoint.toList(pointMap, this.buckets));
    }
}

