/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.pager;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.LegacyLayout;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.io.util.DataInputBuffer;
import org.apache.cassandra.io.util.DataOutputBufferFixed;
import org.apache.cassandra.transport.ProtocolException;
import org.apache.cassandra.utils.ByteBufferUtil;

public class PagingState {
    public final ByteBuffer partitionKey;
    public final RowMark rowMark;
    public final int remaining;
    public final int remainingInPartition;

    public PagingState(ByteBuffer partitionKey, RowMark rowMark, int remaining, int remainingInPartition) {
        this.partitionKey = partitionKey;
        this.rowMark = rowMark;
        this.remaining = remaining;
        this.remainingInPartition = remainingInPartition;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PagingState deserialize(ByteBuffer bytes, int protocolVersion) {
        if (bytes == null) {
            return null;
        }
        try (DataInputBuffer in = new DataInputBuffer(bytes, true);){
            int remainingInPartition;
            int remaining;
            RowMark mark;
            ByteBuffer pk;
            if (protocolVersion <= 3) {
                pk = ByteBufferUtil.readWithShortLength(in);
                mark = new RowMark(ByteBufferUtil.readWithShortLength(in), protocolVersion);
                remaining = in.readInt();
                remainingInPartition = in.available() > 0 ? in.readInt() : Integer.MAX_VALUE;
            } else {
                pk = ByteBufferUtil.readWithVIntLength(in);
                mark = new RowMark(ByteBufferUtil.readWithVIntLength(in), protocolVersion);
                remaining = (int)in.readUnsignedVInt();
                remainingInPartition = (int)in.readUnsignedVInt();
            }
            PagingState pagingState = new PagingState(pk.hasRemaining() ? pk : null, mark.mark.hasRemaining() ? mark : null, remaining, remainingInPartition);
            return pagingState;
        }
        catch (IOException e) {
            throw new ProtocolException("Invalid value for the paging state");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer serialize(int protocolVersion) {
        assert (this.rowMark == null || protocolVersion == this.rowMark.protocolVersion);
        try (DataOutputBufferFixed out = new DataOutputBufferFixed(this.serializedSize(protocolVersion));){
            ByteBuffer mark;
            ByteBuffer pk = this.partitionKey == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.partitionKey;
            ByteBuffer byteBuffer = mark = this.rowMark == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.rowMark.mark;
            if (protocolVersion <= 3) {
                ByteBufferUtil.writeWithShortLength(pk, out);
                ByteBufferUtil.writeWithShortLength(mark, out);
                out.writeInt(this.remaining);
                out.writeInt(this.remainingInPartition);
            } else {
                ByteBufferUtil.writeWithVIntLength(pk, out);
                ByteBufferUtil.writeWithVIntLength(mark, out);
                out.writeUnsignedVInt(this.remaining);
                out.writeUnsignedVInt(this.remainingInPartition);
            }
            ByteBuffer byteBuffer2 = out.buffer();
            return byteBuffer2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int serializedSize(int protocolVersion) {
        ByteBuffer mark;
        assert (this.rowMark == null || protocolVersion == this.rowMark.protocolVersion);
        ByteBuffer pk = this.partitionKey == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.partitionKey;
        ByteBuffer byteBuffer = mark = this.rowMark == null ? ByteBufferUtil.EMPTY_BYTE_BUFFER : this.rowMark.mark;
        if (protocolVersion <= 3) {
            return ByteBufferUtil.serializedSizeWithShortLength(pk) + ByteBufferUtil.serializedSizeWithShortLength(mark) + 8;
        }
        return ByteBufferUtil.serializedSizeWithVIntLength(pk) + ByteBufferUtil.serializedSizeWithVIntLength(mark) + TypeSizes.sizeofUnsignedVInt(this.remaining) + TypeSizes.sizeofUnsignedVInt(this.remainingInPartition);
    }

    public final int hashCode() {
        return Objects.hash(this.partitionKey, this.rowMark, this.remaining, this.remainingInPartition);
    }

    public final boolean equals(Object o) {
        if (!(o instanceof PagingState)) {
            return false;
        }
        PagingState that = (PagingState)o;
        return Objects.equals(this.partitionKey, that.partitionKey) && Objects.equals(this.rowMark, that.rowMark) && this.remaining == that.remaining && this.remainingInPartition == that.remainingInPartition;
    }

    public String toString() {
        return String.format("PagingState(key=%s, cellname=%s, remaining=%d, remainingInPartition=%d", this.partitionKey != null ? ByteBufferUtil.bytesToHex(this.partitionKey) : null, this.rowMark, this.remaining, this.remainingInPartition);
    }

    public static class RowMark {
        private final ByteBuffer mark;
        private final int protocolVersion;

        private RowMark(ByteBuffer mark, int protocolVersion) {
            this.mark = mark;
            this.protocolVersion = protocolVersion;
        }

        private static List<AbstractType<?>> makeClusteringTypes(CFMetaData metadata) {
            int size = metadata.clusteringColumns().size();
            ArrayList l = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                l.add(BytesType.instance);
            }
            return l;
        }

        public static RowMark create(CFMetaData metadata, Row row, int protocolVersion) {
            ByteBuffer mark;
            if (protocolVersion <= 3) {
                Iterator<Cell> cells = row.cellsInLegacyOrder(metadata, true).iterator();
                if (!cells.hasNext()) {
                    assert (!metadata.isCompactTable());
                    mark = LegacyLayout.encodeCellName(metadata, row.clustering(), ByteBufferUtil.EMPTY_BYTE_BUFFER, null);
                } else {
                    Cell cell = cells.next();
                    mark = LegacyLayout.encodeCellName(metadata, row.clustering(), cell.column().name.bytes, cell.column().isComplex() ? cell.path().get(0) : null);
                }
            } else {
                mark = Clustering.serializer.serialize(row.clustering(), 10, RowMark.makeClusteringTypes(metadata));
            }
            return new RowMark(mark, protocolVersion);
        }

        public Clustering clustering(CFMetaData metadata) {
            if (this.mark == null) {
                return null;
            }
            return this.protocolVersion <= 3 ? LegacyLayout.decodeClustering(metadata, this.mark) : Clustering.serializer.deserialize(this.mark, 10, RowMark.makeClusteringTypes(metadata));
        }

        public final int hashCode() {
            return Objects.hash(this.mark, this.protocolVersion);
        }

        public final boolean equals(Object o) {
            if (!(o instanceof RowMark)) {
                return false;
            }
            RowMark that = (RowMark)o;
            return Objects.equals(this.mark, that.mark) && this.protocolVersion == that.protocolVersion;
        }

        public String toString() {
            return this.mark == null ? "null" : ByteBufferUtil.bytesToHex(this.mark);
        }
    }
}

