/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.jobs;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hawkular.metrics.core.jobs.DeleteTenant;
import org.hawkular.metrics.core.jobs.JobsService;
import org.hawkular.metrics.core.jobs.JobsServiceImplMBean;
import org.hawkular.metrics.core.jobs.TempDataCompressor;
import org.hawkular.metrics.core.jobs.TempTableCreator;
import org.hawkular.metrics.core.service.MetricsService;
import org.hawkular.metrics.scheduler.api.JobDetails;
import org.hawkular.metrics.scheduler.api.RetryPolicy;
import org.hawkular.metrics.scheduler.api.Scheduler;
import org.hawkular.metrics.scheduler.api.SingleExecutionTrigger;
import org.hawkular.metrics.sysconfig.ConfigurationService;
import org.hawkular.rx.cassandra.driver.RxSession;
import org.jboss.logging.Logger;
import org.joda.time.Minutes;
import rx.Single;
import rx.functions.Func2;

public class JobsServiceImpl
implements JobsService,
JobsServiceImplMBean {
    public static final String CONFIG_PREFIX = "org.hawkular.metrics.jobs.";
    private static Logger logger = Logger.getLogger(JobsServiceImpl.class);
    private Scheduler scheduler;
    private RxSession session;
    private MetricsService metricsService;
    private DeleteTenant deleteTenant;
    private ConfigurationService configurationService;

    public void setMetricsService(MetricsService metricsService) {
        this.metricsService = metricsService;
    }

    public void setSession(RxSession session) {
        this.session = session;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public void start() {
        this.deleteTenant = new DeleteTenant(this.session, this.metricsService);
        Func2 deleteTenantRetryPolicy = (details, throwable) -> () -> {
            logger.warn((Object)("Execution of " + details + " failed"), throwable);
            logger.info((Object)(details + " will be retried in 5 minutes"));
            return Minutes.minutes(5).toStandardDuration().getMillis();
        };
        this.scheduler.register("DELETE_TENANT", this.deleteTenant, (Func2<JobDetails, Throwable, RetryPolicy>)deleteTenantRetryPolicy);
        TempTableCreator tempCreator = new TempTableCreator(this.metricsService, this.configurationService);
        this.scheduler.register("TEMP_TABLE_CREATOR", tempCreator);
        TempDataCompressor tempJob = new TempDataCompressor(this.metricsService, this.configurationService);
        this.scheduler.register("TEMP_DATA_COMPRESSOR", tempJob);
        this.scheduler.start();
    }

    @Override
    public void shutdown() {
        this.scheduler.shutdown();
    }

    @Override
    public Single<? extends JobDetails> submitDeleteTenantJob(String tenantId, String jobName) {
        return this.scheduler.scheduleJob("DELETE_TENANT", jobName, ImmutableMap.of("tenantId", tenantId), new SingleExecutionTrigger.Builder().withDelay(1L, TimeUnit.MINUTES).build());
    }

    private void submitCompressJob(Map<String, String> parameters) {
        String jobName = String.format("%s_single_%s", "COMPRESS_DATA", parameters.get("compression.time.target"));
        this.scheduler.scheduleJob("COMPRESS_DATA", jobName, parameters, new SingleExecutionTrigger.Builder().withDelay(1L, TimeUnit.MINUTES).build()).toBlocking().value();
    }

    @Override
    public void submitCompressJob(long timestamp) {
        logger.debugf("Scheduling manual submitCompressJob with default blocksize, timestamp->%d", timestamp);
        this.submitCompressJob(ImmutableMap.of("compression.time.target", Long.valueOf(timestamp).toString()));
    }

    @Override
    public void submitCompressJob(long timestamp, String blockSize) {
        logger.debugf("Scheduling manual submitCompressJob with defined blocksize, timestamp->%d, blockSize->%s", timestamp, (Object)blockSize);
        this.submitCompressJob(ImmutableMap.of("compression.time.target", Long.valueOf(timestamp).toString(), "compression.block.size", blockSize));
    }
}

