/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.metrics.core.service;

import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.math3.stat.descriptive.summary.Sum;
import org.hawkular.metrics.model.NumericBucketPoint;
import org.hawkular.metrics.model.Percentile;

final class SumNumericBucketPointCollector {
    private Sum min = new Sum();
    private Sum average = new Sum();
    private Sum median = new Sum();
    private Sum max = new Sum();
    private Sum sum = new Sum();
    private Sum samples = new Sum();
    private Map<String, Sum> percentiles = new HashMap<String, Sum>();
    private Long start;
    private Long end;

    SumNumericBucketPointCollector() {
    }

    void increment(NumericBucketPoint bucketPoint) {
        if (!bucketPoint.isEmpty()) {
            this.min.increment(bucketPoint.getMin());
            this.average.increment(bucketPoint.getAvg());
            this.median.increment(bucketPoint.getMedian());
            this.max.increment(bucketPoint.getMax());
            this.sum.increment(bucketPoint.getSum());
            this.samples.increment(1.0);
            if (bucketPoint.getPercentiles() != null) {
                for (Percentile p : bucketPoint.getPercentiles()) {
                    this.percentiles.computeIfAbsent(p.getOriginalQuantile(), k -> new Sum()).increment(p.getValue());
                }
            }
        }
        this.start = bucketPoint.getStart();
        this.end = bucketPoint.getEnd();
    }

    NumericBucketPoint toBucketPoint() {
        int localSamples = Integer.MAX_VALUE;
        if (this.samples.getN() >= Integer.MIN_VALUE && this.samples.getN() <= Integer.MAX_VALUE) {
            localSamples = (int)this.samples.getN();
        }
        NumericBucketPoint.Builder builder = new NumericBucketPoint.Builder(this.start, this.end).setMin(this.min.getResult()).setAvg(this.average.getResult()).setMedian(this.median.getResult()).setMax(this.max.getResult()).setSum(this.sum.getResult()).setSamples(localSamples);
        if (!this.percentiles.isEmpty()) {
            builder.setPercentiles(this.percentiles.entrySet().stream().map(e -> new Percentile((String)e.getKey(), ((Sum)e.getValue()).getResult())).collect(Collectors.toList()));
        }
        return builder.build();
    }
}

