/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.concurrent.Stage;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.Columns;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.LivenessInfo;
import org.apache.cassandra.db.Mutation;
import org.apache.cassandra.db.PartitionColumns;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadResponse;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.PartitionIterators;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.BTreeRow;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.RangeTombstoneMarker;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowDiffListener;
import org.apache.cassandra.db.rows.Rows;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.db.transform.MoreRows;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.exceptions.ReadTimeoutException;
import org.apache.cassandra.net.AsyncOneResponse;
import org.apache.cassandra.net.MessageIn;
import org.apache.cassandra.net.MessageOut;
import org.apache.cassandra.net.MessagingService;
import org.apache.cassandra.service.ReadCallback;
import org.apache.cassandra.service.ResponseResolver;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.utils.FBUtilities;

public class DataResolver
extends ResponseResolver {
    @VisibleForTesting
    final List<AsyncOneResponse> repairResults = Collections.synchronizedList(new ArrayList());

    public DataResolver(Keyspace keyspace, ReadCommand command, ConsistencyLevel consistency, int maxResponseCount) {
        super(keyspace, command, consistency, maxResponseCount);
    }

    @Override
    public PartitionIterator getData() {
        ReadResponse response = (ReadResponse)((MessageIn)this.responses.iterator().next()).payload;
        return UnfilteredPartitionIterators.filter(response.makeIterator(this.command), this.command.nowInSec());
    }

    @Override
    public PartitionIterator resolve() {
        int count = this.responses.size();
        ArrayList<UnfilteredPartitionIterator> iters = new ArrayList<UnfilteredPartitionIterator>(count);
        InetAddress[] sources = new InetAddress[count];
        for (int i = 0; i < count; ++i) {
            MessageIn msg = (MessageIn)this.responses.get(i);
            iters.add(((ReadResponse)msg.payload).makeIterator(this.command));
            sources[i] = msg.from;
        }
        DataLimits.Counter counter = this.command.limits().newCounter(this.command.nowInSec(), true);
        return counter.applyTo(this.mergeWithShortReadProtection(iters, sources, counter));
    }

    @Override
    public void compareResponses() {
        try (PartitionIterator iterator = this.resolve();){
            PartitionIterators.consume(iterator);
        }
    }

    private PartitionIterator mergeWithShortReadProtection(List<UnfilteredPartitionIterator> results, InetAddress[] sources, DataLimits.Counter resultCounter) {
        if (results.size() == 1) {
            return UnfilteredPartitionIterators.filter(results.get(0), this.command.nowInSec());
        }
        RepairMergeListener listener = new RepairMergeListener(sources);
        if (!this.command.limits().isUnlimited()) {
            for (int i = 0; i < results.size(); ++i) {
                results.set(i, Transformation.apply(results.get(i), new ShortReadProtection(sources[i], resultCounter)));
            }
        }
        return UnfilteredPartitionIterators.mergeAndFilter(results, this.command.nowInSec(), listener);
    }

    @Override
    public boolean isDataPresent() {
        return !this.responses.isEmpty();
    }

    private class ShortReadProtection
    extends Transformation<UnfilteredRowIterator> {
        private final InetAddress source;
        private final DataLimits.Counter counter;
        private final DataLimits.Counter postReconciliationCounter;

        private ShortReadProtection(InetAddress source, DataLimits.Counter postReconciliationCounter) {
            this.source = source;
            this.counter = DataResolver.this.command.limits().newCounter(DataResolver.this.command.nowInSec(), false).onlyCount();
            this.postReconciliationCounter = postReconciliationCounter;
        }

        @Override
        public UnfilteredRowIterator applyToPartition(UnfilteredRowIterator partition) {
            partition = Transformation.apply(partition, this.counter);
            ShortReadRowProtection protection = new ShortReadRowProtection(partition.metadata(), partition.partitionKey());
            partition = MoreRows.extend(partition, protection);
            partition = Transformation.apply(partition, protection);
            return partition;
        }

        private class ShortReadRowProtection
        extends Transformation
        implements MoreRows<UnfilteredRowIterator> {
            final CFMetaData metadata;
            final DecoratedKey partitionKey;
            Clustering lastClustering;
            int lastCount = 0;

            private ShortReadRowProtection(CFMetaData metadata, DecoratedKey partitionKey) {
                this.metadata = metadata;
                this.partitionKey = partitionKey;
            }

            @Override
            public Row applyToRow(Row row) {
                this.lastClustering = row.clustering();
                return row;
            }

            @Override
            public UnfilteredRowIterator moreContents() {
                if (this.lastCount == ShortReadProtection.this.counter.counted() || !ShortReadProtection.this.counter.isDoneForPartition()) {
                    return null;
                }
                this.lastCount = ShortReadProtection.this.counter.counted();
                assert (!ShortReadProtection.this.postReconciliationCounter.isDoneForPartition());
                int n = ShortReadProtection.this.postReconciliationCounter.countedInCurrentPartition();
                int x = ShortReadProtection.this.counter.countedInCurrentPartition();
                int toQuery = Math.max(n * n / x - n, 1);
                DataLimits retryLimits = DataResolver.this.command.limits().forShortReadRetry(toQuery);
                ClusteringIndexFilter filter = DataResolver.this.command.clusteringIndexFilter(this.partitionKey);
                ClusteringIndexFilter retryFilter = this.lastClustering == null ? filter : filter.forPaging(this.metadata.comparator, this.lastClustering, false);
                SinglePartitionReadCommand cmd = SinglePartitionReadCommand.create(DataResolver.this.command.metadata(), DataResolver.this.command.nowInSec(), DataResolver.this.command.columnFilter(), DataResolver.this.command.rowFilter(), retryLimits, this.partitionKey, retryFilter);
                return this.doShortReadRetry(cmd);
            }

            private UnfilteredRowIterator doShortReadRetry(SinglePartitionReadCommand retryCommand) {
                DataResolver resolver = new DataResolver(DataResolver.this.keyspace, retryCommand, ConsistencyLevel.ONE, 1);
                ReadCallback handler = new ReadCallback(resolver, ConsistencyLevel.ONE, retryCommand, Collections.singletonList(ShortReadProtection.this.source));
                if (StorageProxy.canDoLocalRequest(ShortReadProtection.this.source)) {
                    StageManager.getStage(Stage.READ).maybeExecuteImmediately(new StorageProxy.LocalReadRunnable(retryCommand, handler));
                } else {
                    MessagingService.instance().sendRRWithFailure(retryCommand.createMessage(MessagingService.current_version), ShortReadProtection.this.source, handler);
                }
                handler.awaitResults();
                assert (resolver.responses.size() == 1);
                return UnfilteredPartitionIterators.getOnlyElement(((ReadResponse)((MessageIn)resolver.responses.get((int)0)).payload).makeIterator(DataResolver.this.command), retryCommand);
            }
        }
    }

    private class RepairMergeListener
    implements UnfilteredPartitionIterators.MergeListener {
        private final InetAddress[] sources;

        public RepairMergeListener(InetAddress[] sources) {
            this.sources = sources;
        }

        @Override
        public UnfilteredRowIterators.MergeListener getRowMergeListener(DecoratedKey partitionKey, List<UnfilteredRowIterator> versions) {
            return new MergeListener(partitionKey, this.columns(versions), this.isReversed(versions));
        }

        private PartitionColumns columns(List<UnfilteredRowIterator> versions) {
            Columns statics = Columns.NONE;
            Columns regulars = Columns.NONE;
            for (UnfilteredRowIterator iter2 : versions) {
                if (iter2 == null) continue;
                PartitionColumns cols = iter2.columns();
                statics = statics.mergeTo(cols.statics);
                regulars = regulars.mergeTo(cols.regulars);
            }
            return new PartitionColumns(statics, regulars);
        }

        private boolean isReversed(List<UnfilteredRowIterator> versions) {
            for (UnfilteredRowIterator iter2 : versions) {
                if (iter2 == null) continue;
                return iter2.isReverseOrder();
            }
            assert (false) : "Expected at least one iterator";
            return false;
        }

        @Override
        public void close() {
            try {
                FBUtilities.waitOnFutures(DataResolver.this.repairResults, DatabaseDescriptor.getWriteRpcTimeout());
            }
            catch (TimeoutException ex) {
                int blockFor = DataResolver.this.consistency.blockFor(DataResolver.this.keyspace);
                if (Tracing.isTracing()) {
                    Tracing.trace("Timed out while read-repairing after receiving all {} data and digest responses", (Object)blockFor);
                } else {
                    ResponseResolver.logger.debug("Timeout while read-repairing after receiving all {} data and digest responses", (Object)blockFor);
                }
                throw new ReadTimeoutException(DataResolver.this.consistency, blockFor - 1, blockFor, true);
            }
        }

        private class MergeListener
        implements UnfilteredRowIterators.MergeListener {
            private final DecoratedKey partitionKey;
            private final PartitionColumns columns;
            private final boolean isReversed;
            private final PartitionUpdate[] repairs;
            private final Row.Builder[] currentRows;
            private final RowDiffListener diffListener;
            private DeletionTime partitionLevelDeletion;
            private DeletionTime mergedDeletionTime;
            private final DeletionTime[] sourceDeletionTime;
            private final Slice.Bound[] markerToRepair;

            public MergeListener(DecoratedKey partitionKey, PartitionColumns columns, boolean isReversed) {
                this.repairs = new PartitionUpdate[RepairMergeListener.this.sources.length];
                this.currentRows = new Row.Builder[RepairMergeListener.this.sources.length];
                this.sourceDeletionTime = new DeletionTime[RepairMergeListener.this.sources.length];
                this.markerToRepair = new Slice.Bound[RepairMergeListener.this.sources.length];
                this.partitionKey = partitionKey;
                this.columns = columns;
                this.isReversed = isReversed;
                this.diffListener = new RowDiffListener(){

                    @Override
                    public void onPrimaryKeyLivenessInfo(int i, Clustering clustering, LivenessInfo merged, LivenessInfo original) {
                        if (merged != null && !merged.equals(original)) {
                            MergeListener.this.currentRow(i, clustering).addPrimaryKeyLivenessInfo(merged);
                        }
                    }

                    @Override
                    public void onDeletion(int i, Clustering clustering, Row.Deletion merged, Row.Deletion original) {
                        if (merged != null && !merged.equals(original)) {
                            MergeListener.this.currentRow(i, clustering).addRowDeletion(merged);
                        }
                    }

                    @Override
                    public void onComplexDeletion(int i, Clustering clustering, ColumnDefinition column, DeletionTime merged, DeletionTime original) {
                        if (merged != null && !merged.equals(original)) {
                            MergeListener.this.currentRow(i, clustering).addComplexDeletion(column, merged);
                        }
                    }

                    @Override
                    public void onCell(int i, Clustering clustering, Cell merged, Cell original) {
                        if (merged != null && !merged.equals(original)) {
                            MergeListener.this.currentRow(i, clustering).addCell(merged);
                        }
                    }
                };
            }

            private PartitionUpdate update(int i) {
                if (this.repairs[i] == null) {
                    this.repairs[i] = new PartitionUpdate(DataResolver.this.command.metadata(), this.partitionKey, this.columns, 1);
                }
                return this.repairs[i];
            }

            private Row.Builder currentRow(int i, Clustering clustering) {
                if (this.currentRows[i] == null) {
                    this.currentRows[i] = BTreeRow.sortedBuilder();
                    this.currentRows[i].newRow(clustering);
                }
                return this.currentRows[i];
            }

            @Override
            public void onMergedPartitionLevelDeletion(DeletionTime mergedDeletion, DeletionTime[] versions) {
                this.partitionLevelDeletion = mergedDeletion;
                for (int i = 0; i < versions.length; ++i) {
                    if (!mergedDeletion.supersedes(versions[i])) continue;
                    this.update(i).addPartitionDeletion(mergedDeletion);
                }
            }

            @Override
            public void onMergedRows(Row merged, Row[] versions) {
                if (merged.isEmpty()) {
                    return;
                }
                Rows.diff(this.diffListener, merged, versions);
                for (int i = 0; i < this.currentRows.length; ++i) {
                    if (this.currentRows[i] == null) continue;
                    this.update(i).add(this.currentRows[i].build());
                }
                Arrays.fill(this.currentRows, null);
            }

            private DeletionTime currentDeletion() {
                return this.mergedDeletionTime == null ? this.partitionLevelDeletion : this.mergedDeletionTime;
            }

            @Override
            public void onMergedRangeTombstoneMarkers(RangeTombstoneMarker merged, RangeTombstoneMarker[] versions) {
                DeletionTime currentDeletion = this.currentDeletion();
                for (int i = 0; i < versions.length; ++i) {
                    DeletionTime sourceDeletion;
                    DeletionTime newDeletion;
                    RangeTombstoneMarker marker = versions[i];
                    if (marker != null) {
                        DeletionTime deletionTime = this.sourceDeletionTime[i] = marker.isOpen(this.isReversed) ? marker.openDeletionTime(this.isReversed) : null;
                    }
                    if (merged == null) {
                        if (marker == null) continue;
                        assert (!currentDeletion.isLive()) : currentDeletion.toString();
                        if (this.markerToRepair[i] == null) {
                            assert (marker.isClose(this.isReversed) && currentDeletion.equals(marker.closeDeletionTime(this.isReversed))) : String.format("currentDeletion=%s, marker=%s", currentDeletion, marker.toString(DataResolver.this.command.metadata()));
                            if (marker.isOpen(this.isReversed) && currentDeletion.equals(marker.openDeletionTime(this.isReversed))) continue;
                            this.markerToRepair[i] = marker.closeBound(this.isReversed).invert();
                            continue;
                        }
                        if (!marker.isOpen(this.isReversed) || !currentDeletion.equals(marker.openDeletionTime(this.isReversed))) continue;
                        this.closeOpenMarker(i, marker.openBound(this.isReversed).invert());
                        continue;
                    }
                    if (merged.isClose(this.isReversed) && this.markerToRepair[i] != null) {
                        this.closeOpenMarker(i, merged.closeBound(this.isReversed));
                    }
                    if (!merged.isOpen(this.isReversed) || (newDeletion = merged.openDeletionTime(this.isReversed)).equals(sourceDeletion = this.sourceDeletionTime[i])) continue;
                    this.markerToRepair[i] = merged.openBound(this.isReversed);
                }
                if (merged != null) {
                    this.mergedDeletionTime = merged.isOpen(this.isReversed) ? merged.openDeletionTime(this.isReversed) : null;
                }
            }

            private void closeOpenMarker(int i, Slice.Bound close) {
                Slice.Bound open = this.markerToRepair[i];
                this.update(i).add(new RangeTombstone(Slice.make(this.isReversed ? close : open, this.isReversed ? open : close), this.currentDeletion()));
                this.markerToRepair[i] = null;
            }

            @Override
            public void close() {
                for (int i = 0; i < this.repairs.length; ++i) {
                    if (this.repairs[i] == null) continue;
                    Tracing.trace("Sending read-repair-mutation to {}", (Object)RepairMergeListener.this.sources[i]);
                    MessageOut<Mutation> msg = new Mutation(this.repairs[i]).createMessage(MessagingService.Verb.READ_REPAIR);
                    DataResolver.this.repairResults.add(MessagingService.instance().sendRR(msg, RepairMergeListener.this.sources[i]));
                }
            }
        }
    }
}

