/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.compaction.writers;

import java.util.Set;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Directories;
import org.apache.cassandra.db.SerializationHeader;
import org.apache.cassandra.db.compaction.writers.CompactionAwareWriter;
import org.apache.cassandra.db.lifecycle.LifecycleTransaction;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.io.sstable.Descriptor;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableWriter;
import org.apache.cassandra.io.sstable.metadata.MetadataCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCompactionWriter
extends CompactionAwareWriter {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultCompactionWriter.class);

    public DefaultCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables) {
        this(cfs, directories, txn, nonExpiredSSTables, false, false);
    }

    public DefaultCompactionWriter(ColumnFamilyStore cfs, Directories directories, LifecycleTransaction txn, Set<SSTableReader> nonExpiredSSTables, boolean offline, boolean keepOriginals) {
        super(cfs, directories, txn, nonExpiredSSTables, offline, keepOriginals);
    }

    @Override
    public boolean realAppend(UnfilteredRowIterator partition) {
        return this.sstableWriter.append(partition) != null;
    }

    @Override
    protected void switchCompactionLocation(Directories.DataDirectory directory) {
        SSTableWriter writer = SSTableWriter.create(Descriptor.fromFilename(this.cfs.getSSTablePath(this.getDirectories().getLocationForDisk(directory))), this.estimatedTotalKeys, (Long)this.minRepairedAt, this.cfs.metadata, new MetadataCollector(this.txn.originals(), this.cfs.metadata.comparator, 0), SerializationHeader.make(this.cfs.metadata, this.nonExpiredSSTables), this.txn);
        this.sstableWriter.switchWriter(writer);
    }

    @Override
    public long estimatedKeys() {
        return this.estimatedTotalKeys;
    }
}

