/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.schema;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.cassandra.config.CFMetaData;

public final class Tables
implements Iterable<CFMetaData> {
    private final ImmutableMap<String, CFMetaData> tables;

    private Tables(Builder builder) {
        this.tables = builder.tables.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Tables none() {
        return Tables.builder().build();
    }

    public static Tables of(CFMetaData ... tables) {
        return Tables.builder().add(tables).build();
    }

    public static Tables of(Iterable<CFMetaData> tables) {
        return Tables.builder().add(tables).build();
    }

    @Override
    public Iterator<CFMetaData> iterator() {
        return ((ImmutableCollection)this.tables.values()).iterator();
    }

    public int size() {
        return this.tables.size();
    }

    public Optional<CFMetaData> get(String name) {
        return Optional.ofNullable(this.tables.get(name));
    }

    @Nullable
    public CFMetaData getNullable(String name) {
        return this.tables.get(name);
    }

    public Tables with(CFMetaData table) {
        if (this.get(table.cfName).isPresent()) {
            throw new IllegalStateException(String.format("Table %s already exists", table.cfName));
        }
        return Tables.builder().add(this).add(table).build();
    }

    public Tables without(String name) {
        CFMetaData table = this.get(name).orElseThrow(() -> new IllegalStateException(String.format("Table %s doesn't exists", name)));
        return Tables.builder().add(Iterables.filter(this, t -> t != table)).build();
    }

    MapDifference<String, CFMetaData> diff(Tables other) {
        return Maps.difference(this.tables, other.tables);
    }

    public boolean equals(Object o) {
        return this == o || o instanceof Tables && this.tables.equals(((Tables)o).tables);
    }

    public int hashCode() {
        return this.tables.hashCode();
    }

    public String toString() {
        return ((AbstractCollection)this.tables.values()).toString();
    }

    public static final class Builder {
        final ImmutableMap.Builder<String, CFMetaData> tables = new ImmutableMap.Builder();

        private Builder() {
        }

        public Tables build() {
            return new Tables(this);
        }

        public Builder add(CFMetaData table) {
            this.tables.put(table.cfName, table);
            return this;
        }

        public Builder add(CFMetaData ... tables) {
            for (CFMetaData table : tables) {
                this.add(table);
            }
            return this;
        }

        public Builder add(Iterable<CFMetaData> tables) {
            tables.forEach(this::add);
            return this;
        }
    }
}

